// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from PeripheralDeviceSlot.idl.

package com.raritan.idl.peripheral;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface DeviceSlot {
  static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceSlot:1.0.0", null);

  public static final int ERR_INVALID_PARAMS = 1;

  public static final int ERR_NOT_SUPPORTED = 2;

  public static final int CHANNEL_INVALID = -1;

  public enum Events {
    EVT_KEY_DEVICE_CHANGED,
    EVT_KEY_SETTINGS_CHANGED;
  }

  static public class Location implements Cloneable {
    public String x = new String();
    public String y = new String();
    public String z = new String();

    public Object clone() {
      Location copy = new Location();

      copy.x = this.x;
      copy.y = this.y;
      copy.z = this.z;

      return copy;
    }

  }

  static public class Settings implements Cloneable {
    public String name = new String();
    public String description = new String();
    public com.raritan.idl.peripheral.DeviceSlot.Location location = new com.raritan.idl.peripheral.DeviceSlot.Location();
    public boolean useDefaultThresholds = false;
    public java.util.Map<String, String> properties = new java.util.HashMap<>();

    public Object clone() {
      Settings copy = new Settings();

      copy.name = this.name;
      copy.description = this.description;
      Object locationCopy = this.location.clone();
      copy.location = (com.raritan.idl.peripheral.DeviceSlot.Location) locationCopy;
      copy.useDefaultThresholds = this.useDefaultThresholds;
      copy.properties = new java.util.HashMap<String, String>(this.properties);

      return copy;
    }

  }

  public class GetDeviceResult {
    public com.raritan.idl.peripheral.Device _ret_;
  }

  GetDeviceResult getDevice() throws Exception;

  AsyncRequest getDevice(AsyncRpcResponse<GetDeviceResult> rsp);

  AsyncRequest getDevice(AsyncRpcResponse<GetDeviceResult> rsp, RpcCtrl rpcCtrl);


  public class AssignResult {
    public int _ret_;
  }

  AssignResult assign(com.raritan.idl.peripheral.DeviceID devid) throws Exception;

  AsyncRequest assign(com.raritan.idl.peripheral.DeviceID devid, AsyncRpcResponse<AssignResult> rsp);

  AsyncRequest assign(com.raritan.idl.peripheral.DeviceID devid, AsyncRpcResponse<AssignResult> rsp, RpcCtrl rpcCtrl);


  public class AssignAddressResult {
    public int _ret_;
  }

  AssignAddressResult assignAddress(String packageClass, com.raritan.idl.peripheral.Address address) throws Exception;

  AsyncRequest assignAddress(String packageClass, com.raritan.idl.peripheral.Address address, AsyncRpcResponse<AssignAddressResult> rsp);

  AsyncRequest assignAddress(String packageClass, com.raritan.idl.peripheral.Address address, AsyncRpcResponse<AssignAddressResult> rsp, RpcCtrl rpcCtrl);


  public class UnassignResult {
    public int _ret_;
  }

  UnassignResult unassign() throws Exception;

  AsyncRequest unassign(AsyncRpcResponse<UnassignResult> rsp);

  AsyncRequest unassign(AsyncRpcResponse<UnassignResult> rsp, RpcCtrl rpcCtrl);


  public class GetSettingsResult {
    public com.raritan.idl.peripheral.DeviceSlot.Settings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(com.raritan.idl.peripheral.DeviceSlot.Settings settings) throws Exception;

  AsyncRequest setSettings(com.raritan.idl.peripheral.DeviceSlot.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(com.raritan.idl.peripheral.DeviceSlot.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);

}
