// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Security.idl.

package com.raritan.json_rpc.security;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class Security_3_0_1_Proxy extends ObjectProxy implements com.raritan.idl.security.Security_3_0_1 {

  public Security_3_0_1_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public Security_3_0_1_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.security.Security_3_0_1.typeInfo);
  }

  public static Security_3_0_1_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new Security_3_0_1_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public GetSettingsResult getSettings() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getSettings", params);
    GetSettingsResult ret = new GetSettingsResult();
    ret._ret_ = com.raritan.json_rpc.security.Security_3_0_1.Settings_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getSettings(final AsyncRpcResponse<GetSettingsResult> rsp) {
    return getSettings(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getSettings(final AsyncRpcResponse<GetSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetSettingsResult ret = new GetSettingsResult();
          ret._ret_ = com.raritan.json_rpc.security.Security_3_0_1.Settings_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetSettingsResult setSettings(final com.raritan.idl.security.Security_3_0_1.Settings settings) throws Exception {
    JSONObject params = new JSONObject();
    params.put("settings", com.raritan.json_rpc.security.Security_3_0_1.Settings_Codec.encode(settings));
    final JSONObject result = rpcCall("setSettings", params);
    SetSettingsResult ret = new SetSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setSettings(final com.raritan.idl.security.Security_3_0_1.Settings settings, final AsyncRpcResponse<SetSettingsResult> rsp) {
    return setSettings(settings, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setSettings(final com.raritan.idl.security.Security_3_0_1.Settings settings, final AsyncRpcResponse<SetSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("settings", com.raritan.json_rpc.security.Security_3_0_1.Settings_Codec.encode(settings));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetSettingsResult ret = new SetSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetHttpRedirSettingsResult getHttpRedirSettings() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getHttpRedirSettings", params);
    GetHttpRedirSettingsResult ret = new GetHttpRedirSettingsResult();
    ret._ret_ = result.getBoolean("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest getHttpRedirSettings(final AsyncRpcResponse<GetHttpRedirSettingsResult> rsp) {
    return getHttpRedirSettings(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getHttpRedirSettings(final AsyncRpcResponse<GetHttpRedirSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getHttpRedirSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetHttpRedirSettingsResult ret = new GetHttpRedirSettingsResult();
          ret._ret_ = result.getBoolean("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void setHttpRedirSettings(final boolean http2httpsRedir) throws Exception {
    JSONObject params = new JSONObject();
    params.put("http2httpsRedir", http2httpsRedir);
    rpcCall("setHttpRedirSettings", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest setHttpRedirSettings(final boolean http2httpsRedir, final AsyncRpcResponse<Void> rsp) {
    return setHttpRedirSettings(http2httpsRedir, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setHttpRedirSettings(final boolean http2httpsRedir, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("http2httpsRedir", http2httpsRedir);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setHttpRedirSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetIpFwSettingsResult getIpFwSettings() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getIpFwSettings", params);
    GetIpFwSettingsResult ret = new GetIpFwSettingsResult();
    ret._ret_ = com.raritan.json_rpc.security.IpFw_2_0_0_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getIpFwSettings(final AsyncRpcResponse<GetIpFwSettingsResult> rsp) {
    return getIpFwSettings(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getIpFwSettings(final AsyncRpcResponse<GetIpFwSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getIpFwSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetIpFwSettingsResult ret = new GetIpFwSettingsResult();
          ret._ret_ = com.raritan.json_rpc.security.IpFw_2_0_0_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetIpFwSettingsResult setIpFwSettings(final com.raritan.idl.security.IpFw_2_0_0 ipFw) throws Exception {
    JSONObject params = new JSONObject();
    params.put("ipFw", com.raritan.json_rpc.security.IpFw_2_0_0_Codec.encode(ipFw));
    final JSONObject result = rpcCall("setIpFwSettings", params);
    SetIpFwSettingsResult ret = new SetIpFwSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setIpFwSettings(final com.raritan.idl.security.IpFw_2_0_0 ipFw, final AsyncRpcResponse<SetIpFwSettingsResult> rsp) {
    return setIpFwSettings(ipFw, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setIpFwSettings(final com.raritan.idl.security.IpFw_2_0_0 ipFw, final AsyncRpcResponse<SetIpFwSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("ipFw", com.raritan.json_rpc.security.IpFw_2_0_0_Codec.encode(ipFw));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setIpFwSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetIpFwSettingsResult ret = new SetIpFwSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetIpV6FwSettingsResult getIpV6FwSettings() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getIpV6FwSettings", params);
    GetIpV6FwSettingsResult ret = new GetIpV6FwSettingsResult();
    ret._ret_ = com.raritan.json_rpc.security.IpFw_2_0_0_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getIpV6FwSettings(final AsyncRpcResponse<GetIpV6FwSettingsResult> rsp) {
    return getIpV6FwSettings(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getIpV6FwSettings(final AsyncRpcResponse<GetIpV6FwSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getIpV6FwSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetIpV6FwSettingsResult ret = new GetIpV6FwSettingsResult();
          ret._ret_ = com.raritan.json_rpc.security.IpFw_2_0_0_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetIpV6FwSettingsResult setIpV6FwSettings(final com.raritan.idl.security.IpFw_2_0_0 ipV6Fw) throws Exception {
    JSONObject params = new JSONObject();
    params.put("ipV6Fw", com.raritan.json_rpc.security.IpFw_2_0_0_Codec.encode(ipV6Fw));
    final JSONObject result = rpcCall("setIpV6FwSettings", params);
    SetIpV6FwSettingsResult ret = new SetIpV6FwSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setIpV6FwSettings(final com.raritan.idl.security.IpFw_2_0_0 ipV6Fw, final AsyncRpcResponse<SetIpV6FwSettingsResult> rsp) {
    return setIpV6FwSettings(ipV6Fw, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setIpV6FwSettings(final com.raritan.idl.security.IpFw_2_0_0 ipV6Fw, final AsyncRpcResponse<SetIpV6FwSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("ipV6Fw", com.raritan.json_rpc.security.IpFw_2_0_0_Codec.encode(ipV6Fw));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setIpV6FwSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetIpV6FwSettingsResult ret = new SetIpV6FwSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetRoleAccessControlSettingsResult getRoleAccessControlSettings() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getRoleAccessControlSettings", params);
    GetRoleAccessControlSettingsResult ret = new GetRoleAccessControlSettingsResult();
    ret._ret_ = com.raritan.json_rpc.security.RoleAccessControl_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getRoleAccessControlSettings(final AsyncRpcResponse<GetRoleAccessControlSettingsResult> rsp) {
    return getRoleAccessControlSettings(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getRoleAccessControlSettings(final AsyncRpcResponse<GetRoleAccessControlSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getRoleAccessControlSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetRoleAccessControlSettingsResult ret = new GetRoleAccessControlSettingsResult();
          ret._ret_ = com.raritan.json_rpc.security.RoleAccessControl_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetRoleAccessControlSettingsResult setRoleAccessControlSettings(final com.raritan.idl.security.RoleAccessControl settings) throws Exception {
    JSONObject params = new JSONObject();
    params.put("settings", com.raritan.json_rpc.security.RoleAccessControl_Codec.encode(settings));
    final JSONObject result = rpcCall("setRoleAccessControlSettings", params);
    SetRoleAccessControlSettingsResult ret = new SetRoleAccessControlSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setRoleAccessControlSettings(final com.raritan.idl.security.RoleAccessControl settings, final AsyncRpcResponse<SetRoleAccessControlSettingsResult> rsp) {
    return setRoleAccessControlSettings(settings, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setRoleAccessControlSettings(final com.raritan.idl.security.RoleAccessControl settings, final AsyncRpcResponse<SetRoleAccessControlSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("settings", com.raritan.json_rpc.security.RoleAccessControl_Codec.encode(settings));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setRoleAccessControlSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetRoleAccessControlSettingsResult ret = new SetRoleAccessControlSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetRoleAccessControlSettingsV6Result getRoleAccessControlSettingsV6() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getRoleAccessControlSettingsV6", params);
    GetRoleAccessControlSettingsV6Result ret = new GetRoleAccessControlSettingsV6Result();
    ret._ret_ = com.raritan.json_rpc.security.RoleAccessControl_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getRoleAccessControlSettingsV6(final AsyncRpcResponse<GetRoleAccessControlSettingsV6Result> rsp) {
    return getRoleAccessControlSettingsV6(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getRoleAccessControlSettingsV6(final AsyncRpcResponse<GetRoleAccessControlSettingsV6Result> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getRoleAccessControlSettingsV6", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetRoleAccessControlSettingsV6Result ret = new GetRoleAccessControlSettingsV6Result();
          ret._ret_ = com.raritan.json_rpc.security.RoleAccessControl_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetRoleAccessControlSettingsV6Result setRoleAccessControlSettingsV6(final com.raritan.idl.security.RoleAccessControl settings) throws Exception {
    JSONObject params = new JSONObject();
    params.put("settings", com.raritan.json_rpc.security.RoleAccessControl_Codec.encode(settings));
    final JSONObject result = rpcCall("setRoleAccessControlSettingsV6", params);
    SetRoleAccessControlSettingsV6Result ret = new SetRoleAccessControlSettingsV6Result();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setRoleAccessControlSettingsV6(final com.raritan.idl.security.RoleAccessControl settings, final AsyncRpcResponse<SetRoleAccessControlSettingsV6Result> rsp) {
    return setRoleAccessControlSettingsV6(settings, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setRoleAccessControlSettingsV6(final com.raritan.idl.security.RoleAccessControl settings, final AsyncRpcResponse<SetRoleAccessControlSettingsV6Result> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("settings", com.raritan.json_rpc.security.RoleAccessControl_Codec.encode(settings));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setRoleAccessControlSettingsV6", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetRoleAccessControlSettingsV6Result ret = new SetRoleAccessControlSettingsV6Result();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetBlockSettingsResult getBlockSettings() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getBlockSettings", params);
    GetBlockSettingsResult ret = new GetBlockSettingsResult();
    ret.blockTimeout = result.getInt("blockTimeout");
    ret.maxFailedLogins = result.getInt("maxFailedLogins");
    return ret;
  }

  @Override
  public AsyncRequest getBlockSettings(final AsyncRpcResponse<GetBlockSettingsResult> rsp) {
    return getBlockSettings(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getBlockSettings(final AsyncRpcResponse<GetBlockSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getBlockSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetBlockSettingsResult ret = new GetBlockSettingsResult();
          ret.blockTimeout = result.getInt("blockTimeout");
          ret.maxFailedLogins = result.getInt("maxFailedLogins");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetBlockSettingsResult setBlockSettings(final int blockTimeout, final int maxFailedLogins) throws Exception {
    JSONObject params = new JSONObject();
    params.put("blockTimeout", blockTimeout);
    params.put("maxFailedLogins", maxFailedLogins);
    final JSONObject result = rpcCall("setBlockSettings", params);
    SetBlockSettingsResult ret = new SetBlockSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setBlockSettings(final int blockTimeout, final int maxFailedLogins, final AsyncRpcResponse<SetBlockSettingsResult> rsp) {
    return setBlockSettings(blockTimeout, maxFailedLogins, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setBlockSettings(final int blockTimeout, final int maxFailedLogins, final AsyncRpcResponse<SetBlockSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("blockTimeout", blockTimeout);
      params.put("maxFailedLogins", maxFailedLogins);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setBlockSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetBlockSettingsResult ret = new SetBlockSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetPwSettingsResult getPwSettings() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getPwSettings", params);
    GetPwSettingsResult ret = new GetPwSettingsResult();
    ret._ret_ = com.raritan.json_rpc.security.PasswordSettings_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getPwSettings(final AsyncRpcResponse<GetPwSettingsResult> rsp) {
    return getPwSettings(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getPwSettings(final AsyncRpcResponse<GetPwSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getPwSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetPwSettingsResult ret = new GetPwSettingsResult();
          ret._ret_ = com.raritan.json_rpc.security.PasswordSettings_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetPwSettingsResult setPwSettings(final com.raritan.idl.security.PasswordSettings pwSettings) throws Exception {
    JSONObject params = new JSONObject();
    params.put("pwSettings", com.raritan.json_rpc.security.PasswordSettings_Codec.encode(pwSettings));
    final JSONObject result = rpcCall("setPwSettings", params);
    SetPwSettingsResult ret = new SetPwSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setPwSettings(final com.raritan.idl.security.PasswordSettings pwSettings, final AsyncRpcResponse<SetPwSettingsResult> rsp) {
    return setPwSettings(pwSettings, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setPwSettings(final com.raritan.idl.security.PasswordSettings pwSettings, final AsyncRpcResponse<SetPwSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("pwSettings", com.raritan.json_rpc.security.PasswordSettings_Codec.encode(pwSettings));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setPwSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetPwSettingsResult ret = new SetPwSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetIdleTimeoutSettingsResult getIdleTimeoutSettings() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getIdleTimeoutSettings", params);
    GetIdleTimeoutSettingsResult ret = new GetIdleTimeoutSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest getIdleTimeoutSettings(final AsyncRpcResponse<GetIdleTimeoutSettingsResult> rsp) {
    return getIdleTimeoutSettings(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getIdleTimeoutSettings(final AsyncRpcResponse<GetIdleTimeoutSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getIdleTimeoutSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetIdleTimeoutSettingsResult ret = new GetIdleTimeoutSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetIdleTimeoutSettingsResult setIdleTimeoutSettings(final int idleTimeout) throws Exception {
    JSONObject params = new JSONObject();
    params.put("idleTimeout", idleTimeout);
    final JSONObject result = rpcCall("setIdleTimeoutSettings", params);
    SetIdleTimeoutSettingsResult ret = new SetIdleTimeoutSettingsResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setIdleTimeoutSettings(final int idleTimeout, final AsyncRpcResponse<SetIdleTimeoutSettingsResult> rsp) {
    return setIdleTimeoutSettings(idleTimeout, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setIdleTimeoutSettings(final int idleTimeout, final AsyncRpcResponse<SetIdleTimeoutSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("idleTimeout", idleTimeout);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setIdleTimeoutSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetIdleTimeoutSettingsResult ret = new SetIdleTimeoutSettingsResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetSingleLoginLimitationResult getSingleLoginLimitation() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getSingleLoginLimitation", params);
    GetSingleLoginLimitationResult ret = new GetSingleLoginLimitationResult();
    ret._ret_ = result.getBoolean("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest getSingleLoginLimitation(final AsyncRpcResponse<GetSingleLoginLimitationResult> rsp) {
    return getSingleLoginLimitation(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getSingleLoginLimitation(final AsyncRpcResponse<GetSingleLoginLimitationResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getSingleLoginLimitation", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetSingleLoginLimitationResult ret = new GetSingleLoginLimitationResult();
          ret._ret_ = result.getBoolean("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void setSingleLoginLimitation(final boolean singleLogin) throws Exception {
    JSONObject params = new JSONObject();
    params.put("singleLogin", singleLogin);
    rpcCall("setSingleLoginLimitation", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest setSingleLoginLimitation(final boolean singleLogin, final AsyncRpcResponse<Void> rsp) {
    return setSingleLoginLimitation(singleLogin, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setSingleLoginLimitation(final boolean singleLogin, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("singleLogin", singleLogin);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setSingleLoginLimitation", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetSSHSettingsResult getSSHSettings() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getSSHSettings", params);
    GetSSHSettingsResult ret = new GetSSHSettingsResult();
    ret._ret_ = com.raritan.json_rpc.security.SSHSettings_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getSSHSettings(final AsyncRpcResponse<GetSSHSettingsResult> rsp) {
    return getSSHSettings(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getSSHSettings(final AsyncRpcResponse<GetSSHSettingsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getSSHSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetSSHSettingsResult ret = new GetSSHSettingsResult();
          ret._ret_ = com.raritan.json_rpc.security.SSHSettings_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void setSSHSettings(final com.raritan.idl.security.SSHSettings settings) throws Exception {
    JSONObject params = new JSONObject();
    params.put("settings", com.raritan.json_rpc.security.SSHSettings_Codec.encode(settings));
    rpcCall("setSSHSettings", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest setSSHSettings(final com.raritan.idl.security.SSHSettings settings, final AsyncRpcResponse<Void> rsp) {
    return setSSHSettings(settings, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setSSHSettings(final com.raritan.idl.security.SSHSettings settings, final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("settings", com.raritan.json_rpc.security.SSHSettings_Codec.encode(settings));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setSSHSettings", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetRestrictedServiceAgreementResult getRestrictedServiceAgreement() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getRestrictedServiceAgreement", params);
    GetRestrictedServiceAgreementResult ret = new GetRestrictedServiceAgreementResult();
    ret._ret_ = com.raritan.json_rpc.security.RestrictedServiceAgreement_Codec.decode(result.getJSONObject("_ret_"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getRestrictedServiceAgreement(final AsyncRpcResponse<GetRestrictedServiceAgreementResult> rsp) {
    return getRestrictedServiceAgreement(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getRestrictedServiceAgreement(final AsyncRpcResponse<GetRestrictedServiceAgreementResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getRestrictedServiceAgreement", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetRestrictedServiceAgreementResult ret = new GetRestrictedServiceAgreementResult();
          ret._ret_ = com.raritan.json_rpc.security.RestrictedServiceAgreement_Codec.decode(result.getJSONObject("_ret_"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetRestrictedServiceAgreementResult setRestrictedServiceAgreement(final com.raritan.idl.security.RestrictedServiceAgreement settings) throws Exception {
    JSONObject params = new JSONObject();
    params.put("settings", com.raritan.json_rpc.security.RestrictedServiceAgreement_Codec.encode(settings));
    final JSONObject result = rpcCall("setRestrictedServiceAgreement", params);
    SetRestrictedServiceAgreementResult ret = new SetRestrictedServiceAgreementResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setRestrictedServiceAgreement(final com.raritan.idl.security.RestrictedServiceAgreement settings, final AsyncRpcResponse<SetRestrictedServiceAgreementResult> rsp) {
    return setRestrictedServiceAgreement(settings, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setRestrictedServiceAgreement(final com.raritan.idl.security.RestrictedServiceAgreement settings, final AsyncRpcResponse<SetRestrictedServiceAgreementResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("settings", com.raritan.json_rpc.security.RestrictedServiceAgreement_Codec.encode(settings));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setRestrictedServiceAgreement", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetRestrictedServiceAgreementResult ret = new SetRestrictedServiceAgreementResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetSupportedFrontPanelPrivilegesResult getSupportedFrontPanelPrivileges() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getSupportedFrontPanelPrivileges", params);
    GetSupportedFrontPanelPrivilegesResult ret = new GetSupportedFrontPanelPrivilegesResult();
    ret._ret_ = new java.util.ArrayList<String>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(array0.getString(i0_f));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getSupportedFrontPanelPrivileges(final AsyncRpcResponse<GetSupportedFrontPanelPrivilegesResult> rsp) {
    return getSupportedFrontPanelPrivileges(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getSupportedFrontPanelPrivileges(final AsyncRpcResponse<GetSupportedFrontPanelPrivilegesResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getSupportedFrontPanelPrivileges", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetSupportedFrontPanelPrivilegesResult ret = new GetSupportedFrontPanelPrivilegesResult();
          ret._ret_ = new java.util.ArrayList<String>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(array0.getString(i0_f));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetFrontPanelPrivilegesResult getFrontPanelPrivileges() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getFrontPanelPrivileges", params);
    GetFrontPanelPrivilegesResult ret = new GetFrontPanelPrivilegesResult();
    ret._ret_ = new java.util.ArrayList<String>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(array0.getString(i0_f));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getFrontPanelPrivileges(final AsyncRpcResponse<GetFrontPanelPrivilegesResult> rsp) {
    return getFrontPanelPrivileges(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getFrontPanelPrivileges(final AsyncRpcResponse<GetFrontPanelPrivilegesResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getFrontPanelPrivileges", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetFrontPanelPrivilegesResult ret = new GetFrontPanelPrivilegesResult();
          ret._ret_ = new java.util.ArrayList<String>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(array0.getString(i0_f));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetFrontPanelPrivilegesResult setFrontPanelPrivileges(final java.util.List<String> privileges) throws Exception {
    JSONObject params = new JSONObject();
    params.put("privileges", new JSONArray() {{
      final java.util.List<String> array0 = privileges;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(array0.get(i0_f));
      }
    }});
    final JSONObject result = rpcCall("setFrontPanelPrivileges", params);
    SetFrontPanelPrivilegesResult ret = new SetFrontPanelPrivilegesResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setFrontPanelPrivileges(final java.util.List<String> privileges, final AsyncRpcResponse<SetFrontPanelPrivilegesResult> rsp) {
    return setFrontPanelPrivileges(privileges, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setFrontPanelPrivileges(final java.util.List<String> privileges, final AsyncRpcResponse<SetFrontPanelPrivilegesResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("privileges", new JSONArray() {{
        final java.util.List<String> array0 = privileges;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(array0.get(i0_f));
        }
      }});
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setFrontPanelPrivileges", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetFrontPanelPrivilegesResult ret = new SetFrontPanelPrivilegesResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
