// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from LuaService.idl.

package com.raritan.idl.luaservice;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface Manager {
  static public final TypeInfo typeInfo = new TypeInfo("luaservice.Manager:1.0.0", null);

  public static final int NO_ERROR = 0;

  public static final int ERR_INVALID_NAME = 1;

  public static final int ERR_NO_SUCH_SCRIPT = 2;

  public static final int ERR_MAX_SCRIPT_NUMBERS_EXCEEDED = 3;

  public static final int ERR_MAX_SCRIPT_SIZE_EXCEEDED = 4;

  public static final int ERR_MAX_ALL_SCRIPT_SIZE_EXCEEDED = 5;

  public static final int ERR_NOT_TERMINATED = 6;

  public static final int ERR_NOT_RUNNING = 7;

  public static final int ERR_INVALID_ADDR = 8;

  public class SetScriptResult {
    public int _ret_;
  }

  SetScriptResult setScript(String name, String script, com.raritan.idl.luaservice.ScriptOptions options) throws Exception;

  AsyncRequest setScript(String name, String script, com.raritan.idl.luaservice.ScriptOptions options, AsyncRpcResponse<SetScriptResult> rsp);

  AsyncRequest setScript(String name, String script, com.raritan.idl.luaservice.ScriptOptions options, AsyncRpcResponse<SetScriptResult> rsp, RpcCtrl rpcCtrl);


  public class GetScriptResult {
    public int _ret_;
    public String script;
  }

  GetScriptResult getScript(String name) throws Exception;

  AsyncRequest getScript(String name, AsyncRpcResponse<GetScriptResult> rsp);

  AsyncRequest getScript(String name, AsyncRpcResponse<GetScriptResult> rsp, RpcCtrl rpcCtrl);


  public class GetScriptNamesResult {
    public java.util.List<String> _ret_;
  }

  GetScriptNamesResult getScriptNames() throws Exception;

  AsyncRequest getScriptNames(AsyncRpcResponse<GetScriptNamesResult> rsp);

  AsyncRequest getScriptNames(AsyncRpcResponse<GetScriptNamesResult> rsp, RpcCtrl rpcCtrl);


  public class DeleteScriptResult {
    public int _ret_;
  }

  DeleteScriptResult deleteScript(String name) throws Exception;

  AsyncRequest deleteScript(String name, AsyncRpcResponse<DeleteScriptResult> rsp);

  AsyncRequest deleteScript(String name, AsyncRpcResponse<DeleteScriptResult> rsp, RpcCtrl rpcCtrl);


  public class SetScriptOptionsResult {
    public int _ret_;
  }

  SetScriptOptionsResult setScriptOptions(String name, com.raritan.idl.luaservice.ScriptOptions options) throws Exception;

  AsyncRequest setScriptOptions(String name, com.raritan.idl.luaservice.ScriptOptions options, AsyncRpcResponse<SetScriptOptionsResult> rsp);

  AsyncRequest setScriptOptions(String name, com.raritan.idl.luaservice.ScriptOptions options, AsyncRpcResponse<SetScriptOptionsResult> rsp, RpcCtrl rpcCtrl);


  public class GetScriptOptionsResult {
    public int _ret_;
    public com.raritan.idl.luaservice.ScriptOptions options;
  }

  GetScriptOptionsResult getScriptOptions(String name) throws Exception;

  AsyncRequest getScriptOptions(String name, AsyncRpcResponse<GetScriptOptionsResult> rsp);

  AsyncRequest getScriptOptions(String name, AsyncRpcResponse<GetScriptOptionsResult> rsp, RpcCtrl rpcCtrl);


  public class GetEnvironmentResult {
    public com.raritan.idl.luaservice.Environment _ret_;
  }

  GetEnvironmentResult getEnvironment() throws Exception;

  AsyncRequest getEnvironment(AsyncRpcResponse<GetEnvironmentResult> rsp);

  AsyncRequest getEnvironment(AsyncRpcResponse<GetEnvironmentResult> rsp, RpcCtrl rpcCtrl);


  public class GetScriptOutputResult {
    public int _ret_;
    public long oAddr;
    public long nAddr;
    public String oString;
    public boolean more;
  }

  GetScriptOutputResult getScriptOutput(String name, long iAddr) throws Exception;

  AsyncRequest getScriptOutput(String name, long iAddr, AsyncRpcResponse<GetScriptOutputResult> rsp);

  AsyncRequest getScriptOutput(String name, long iAddr, AsyncRpcResponse<GetScriptOutputResult> rsp, RpcCtrl rpcCtrl);


  public class StartScriptResult {
    public int _ret_;
  }

  StartScriptResult startScript(String name) throws Exception;

  AsyncRequest startScript(String name, AsyncRpcResponse<StartScriptResult> rsp);

  AsyncRequest startScript(String name, AsyncRpcResponse<StartScriptResult> rsp, RpcCtrl rpcCtrl);


  public class TerminateScriptResult {
    public int _ret_;
  }

  TerminateScriptResult terminateScript(String name) throws Exception;

  AsyncRequest terminateScript(String name, AsyncRpcResponse<TerminateScriptResult> rsp);

  AsyncRequest terminateScript(String name, AsyncRpcResponse<TerminateScriptResult> rsp, RpcCtrl rpcCtrl);


  public class GetScriptStateResult {
    public int _ret_;
    public com.raritan.idl.luaservice.ScriptState state;
  }

  GetScriptStateResult getScriptState(String name) throws Exception;

  AsyncRequest getScriptState(String name, AsyncRpcResponse<GetScriptStateResult> rsp);

  AsyncRequest getScriptState(String name, AsyncRpcResponse<GetScriptStateResult> rsp, RpcCtrl rpcCtrl);


  public class GetScriptStatesResult {
    public java.util.Map<String, com.raritan.idl.luaservice.ScriptState> _ret_;
  }

  GetScriptStatesResult getScriptStates() throws Exception;

  AsyncRequest getScriptStates(AsyncRpcResponse<GetScriptStatesResult> rsp);

  AsyncRequest getScriptStates(AsyncRpcResponse<GetScriptStatesResult> rsp, RpcCtrl rpcCtrl);

}
