// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from DoorAccessControl.idl.

package com.raritan.idl.smartlock;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface DoorAccessControl_1_1_1 {
  static public final TypeInfo typeInfo = new TypeInfo("smartlock.DoorAccessControl:1.1.1", null);

  public static final int ERR_INVALID_SETTINGS = 1;

  public static final int ERR_NO_SUCH_ID = 2;

  public static final int ERR_MAX_RULES_REACHED = 3;

  static public class AbsoluteTimeCondition implements Cloneable {
    public boolean enabled = false;
    public java.util.Date validFrom = new java.util.Date();
    public java.util.Date validTill = new java.util.Date();

    public Object clone() {
      AbsoluteTimeCondition copy = new AbsoluteTimeCondition();

      copy.enabled = this.enabled;
      copy.validFrom = this.validFrom;
      copy.validTill = this.validTill;

      return copy;
    }

  }

  static public class PeriodicTimeCondition implements Cloneable {
    public boolean enabled = false;
    public java.util.List<Integer> daysOfWeek = new java.util.ArrayList<>();
    public int fromHourOfDay = 0;
    public int tillHourOfDay = 0;
    public int fromMinuteOfHour = 0;
    public int tillMinuteOfHour = 0;

    public Object clone() {
      PeriodicTimeCondition copy = new PeriodicTimeCondition();

      copy.enabled = this.enabled;
      copy.daysOfWeek = new java.util.ArrayList<Integer>(this.daysOfWeek);
      copy.fromHourOfDay = this.fromHourOfDay;
      copy.tillHourOfDay = this.tillHourOfDay;
      copy.fromMinuteOfHour = this.fromMinuteOfHour;
      copy.tillMinuteOfHour = this.tillMinuteOfHour;

      return copy;
    }

  }

  static public class CardReaderInfo implements Cloneable {
    public int linkId = 0;
    public String position = new String();

    public Object clone() {
      CardReaderInfo copy = new CardReaderInfo();

      copy.linkId = this.linkId;
      copy.position = this.position;

      return copy;
    }

  }

  static public class KeypadInfo implements Cloneable {
    public int linkId = 0;
    public String position = new String();

    public Object clone() {
      KeypadInfo copy = new KeypadInfo();

      copy.linkId = this.linkId;
      copy.position = this.position;

      return copy;
    }

  }

  static public class CardCondition implements Cloneable {
    public boolean enabled = false;
    public String cardUid = new String();
    public com.raritan.idl.smartlock.DoorAccessControl_1_1_1.CardReaderInfo cardReader = new com.raritan.idl.smartlock.DoorAccessControl_1_1_1.CardReaderInfo();

    public Object clone() {
      CardCondition copy = new CardCondition();

      copy.enabled = this.enabled;
      copy.cardUid = this.cardUid;
      Object cardReaderCopy = this.cardReader.clone();
      copy.cardReader = (com.raritan.idl.smartlock.DoorAccessControl_1_1_1.CardReaderInfo) cardReaderCopy;

      return copy;
    }

  }

  static public class KeypadCondition implements Cloneable {
    public boolean enabled = false;
    public String pin = new String();
    public com.raritan.idl.smartlock.DoorAccessControl_1_1_1.KeypadInfo keypad = new com.raritan.idl.smartlock.DoorAccessControl_1_1_1.KeypadInfo();

    public Object clone() {
      KeypadCondition copy = new KeypadCondition();

      copy.enabled = this.enabled;
      copy.pin = this.pin;
      Object keypadCopy = this.keypad.clone();
      copy.keypad = (com.raritan.idl.smartlock.DoorAccessControl_1_1_1.KeypadInfo) keypadCopy;

      return copy;
    }

  }

  static public class DoorAccessRule implements Cloneable {
    public String name = new String();
    public java.util.List<com.raritan.idl.peripheral.DeviceSlot_4_0_1> doorHandleLocks = new java.util.ArrayList<>();
    public com.raritan.idl.smartlock.DoorAccessControl_1_1_1.CardCondition cardCondition1 = new com.raritan.idl.smartlock.DoorAccessControl_1_1_1.CardCondition();
    public com.raritan.idl.smartlock.DoorAccessControl_1_1_1.CardCondition cardCondition2 = new com.raritan.idl.smartlock.DoorAccessControl_1_1_1.CardCondition();
    public com.raritan.idl.smartlock.DoorAccessControl_1_1_1.KeypadCondition keypadCondition1 = new com.raritan.idl.smartlock.DoorAccessControl_1_1_1.KeypadCondition();
    public com.raritan.idl.smartlock.DoorAccessControl_1_1_1.KeypadCondition keypadCondition2 = new com.raritan.idl.smartlock.DoorAccessControl_1_1_1.KeypadCondition();
    public int conditionsTimeout = 0;
    public com.raritan.idl.smartlock.DoorAccessControl_1_1_1.AbsoluteTimeCondition absoluteTime = new com.raritan.idl.smartlock.DoorAccessControl_1_1_1.AbsoluteTimeCondition();
    public com.raritan.idl.smartlock.DoorAccessControl_1_1_1.PeriodicTimeCondition periodicTime = new com.raritan.idl.smartlock.DoorAccessControl_1_1_1.PeriodicTimeCondition();

    public Object clone() {
      DoorAccessRule copy = new DoorAccessRule();

      copy.name = this.name;
      copy.doorHandleLocks = new java.util.ArrayList<com.raritan.idl.peripheral.DeviceSlot_4_0_1>(this.doorHandleLocks);
      Object cardCondition1Copy = this.cardCondition1.clone();
      copy.cardCondition1 = (com.raritan.idl.smartlock.DoorAccessControl_1_1_1.CardCondition) cardCondition1Copy;
      Object cardCondition2Copy = this.cardCondition2.clone();
      copy.cardCondition2 = (com.raritan.idl.smartlock.DoorAccessControl_1_1_1.CardCondition) cardCondition2Copy;
      Object keypadCondition1Copy = this.keypadCondition1.clone();
      copy.keypadCondition1 = (com.raritan.idl.smartlock.DoorAccessControl_1_1_1.KeypadCondition) keypadCondition1Copy;
      Object keypadCondition2Copy = this.keypadCondition2.clone();
      copy.keypadCondition2 = (com.raritan.idl.smartlock.DoorAccessControl_1_1_1.KeypadCondition) keypadCondition2Copy;
      copy.conditionsTimeout = this.conditionsTimeout;
      Object absoluteTimeCopy = this.absoluteTime.clone();
      copy.absoluteTime = (com.raritan.idl.smartlock.DoorAccessControl_1_1_1.AbsoluteTimeCondition) absoluteTimeCopy;
      Object periodicTimeCopy = this.periodicTime.clone();
      copy.periodicTime = (com.raritan.idl.smartlock.DoorAccessControl_1_1_1.PeriodicTimeCondition) periodicTimeCopy;

      return copy;
    }

  }

  public enum DoorAccessDenialReason {
    DENIED_NO_MATCHING_RULE,
    DENIED_ABSOLUTE_TIME_CONDITION,
    DENIED_PERIODIC_TIME_CONDITION,
    DENIED_CONDITIONS_TIMEOUT;
  }

  public class DoorAccessGrantedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("smartlock.DoorAccessControl_1_1_1.DoorAccessGrantedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int ruleId = 0;
    public com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule rule = new com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule();
  }

  public class DoorAccessDeniedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("smartlock.DoorAccessControl_1_1_1.DoorAccessDeniedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessDenialReason reason = com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessDenialReason.values()[0];
    public int ruleId = 0;
    public String ruleName = new String();
  }

  public class DoorAccessRuleAddedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("smartlock.DoorAccessControl_1_1_1.DoorAccessRuleAddedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int ruleId = 0;
    public com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule rule = new com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule();
  }

  public class DoorAccessRuleChangedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("smartlock.DoorAccessControl_1_1_1.DoorAccessRuleChangedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int ruleId = 0;
    public com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule oldRule = new com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule();
    public com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule newRule = new com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule();
  }

  public class DoorAccessRuleDeletedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("smartlock.DoorAccessControl_1_1_1.DoorAccessRuleDeletedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int ruleId = 0;
    public com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule rule = new com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule();
  }

  public class GetDoorAccessRulesResult {
    public java.util.Map<Integer, com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule> _ret_;
  }

  GetDoorAccessRulesResult getDoorAccessRules() throws Exception;

  AsyncRequest getDoorAccessRules(AsyncRpcResponse<GetDoorAccessRulesResult> rsp);

  AsyncRequest getDoorAccessRules(AsyncRpcResponse<GetDoorAccessRulesResult> rsp, RpcCtrl rpcCtrl);


  public class SetAllDoorAccessRulesResult {
    public int _ret_;
    public java.util.List<Integer> invalidRuleIds;
  }

  SetAllDoorAccessRulesResult setAllDoorAccessRules(java.util.Map<Integer, com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule> rules) throws Exception;

  AsyncRequest setAllDoorAccessRules(java.util.Map<Integer, com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule> rules, AsyncRpcResponse<SetAllDoorAccessRulesResult> rsp);

  AsyncRequest setAllDoorAccessRules(java.util.Map<Integer, com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule> rules, AsyncRpcResponse<SetAllDoorAccessRulesResult> rsp, RpcCtrl rpcCtrl);


  public class AddDoorAccessRuleResult {
    public int _ret_;
    public int ruleId;
  }

  AddDoorAccessRuleResult addDoorAccessRule(com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule rule) throws Exception;

  AsyncRequest addDoorAccessRule(com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule rule, AsyncRpcResponse<AddDoorAccessRuleResult> rsp);

  AsyncRequest addDoorAccessRule(com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule rule, AsyncRpcResponse<AddDoorAccessRuleResult> rsp, RpcCtrl rpcCtrl);


  public class ModifyDoorAccessRuleResult {
    public int _ret_;
  }

  ModifyDoorAccessRuleResult modifyDoorAccessRule(int id, com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule modifiedRule) throws Exception;

  AsyncRequest modifyDoorAccessRule(int id, com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule modifiedRule, AsyncRpcResponse<ModifyDoorAccessRuleResult> rsp);

  AsyncRequest modifyDoorAccessRule(int id, com.raritan.idl.smartlock.DoorAccessControl_1_1_1.DoorAccessRule modifiedRule, AsyncRpcResponse<ModifyDoorAccessRuleResult> rsp, RpcCtrl rpcCtrl);


  public class DeleteDoorAccessRuleResult {
    public int _ret_;
  }

  DeleteDoorAccessRuleResult deleteDoorAccessRule(int id) throws Exception;

  AsyncRequest deleteDoorAccessRule(int id, AsyncRpcResponse<DeleteDoorAccessRuleResult> rsp);

  AsyncRequest deleteDoorAccessRule(int id, AsyncRpcResponse<DeleteDoorAccessRuleResult> rsp, RpcCtrl rpcCtrl);

}
