// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from LhxParameter.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.lhxmodel {
  public class Parameter_2_0_0 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("lhxmodel.Parameter:2.0.0", null);

    public Parameter_2_0_0(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Parameter_2_0_0(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Parameter_2_0_0 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Parameter_2_0_0(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_INVALID_PARAMS = 1;

    public const int ERR_READ_ONLY = 2;

    public enum Events {
      EVT_KEY_VALUE_CHANGED,
      EVT_KEY_METADATA_CHANGED,
    }

    public enum Unit {
      NONE,
      NUMBER,
      BINARY,
      TEMP_ABS,
      TEMP_REL,
      BAR,
      PASCAL,
      SIEMENS,
      METER,
      VOLT,
      AMPERE,
      HOURS,
      MINUTES,
      SECONDS,
      TIME,
      METERS_PER_SECOND,
      NEWTON,
      GRAMMS,
      HUMIDITY_REL,
      HERTZ,
      OHM,
      PERCENT,
      LITERS_PER_MINUTE,
      LITERS_PER_HOUR,
    }

    public class Status : ICloneable {
      public object Clone() {
        Status copy = new Status();
        copy.switchedOn = this.switchedOn;
        copy.active = this.active;
        copy.overflow = this.overflow;
        copy.underflow = this.underflow;
        copy.valid = this.valid;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["switchedOn"] = this.switchedOn;
        json["active"] = this.active;
        json["overflow"] = this.overflow;
        json["underflow"] = this.underflow;
        json["valid"] = this.valid;
        return json;
      }

      public static Status Decode(LightJson.JsonObject json, Agent agent) {
        Status inst = new Status();
        inst.switchedOn = (bool)json["switchedOn"];
        inst.active = (bool)json["active"];
        inst.overflow = (bool)json["overflow"];
        inst.underflow = (bool)json["underflow"];
        inst.valid = (bool)json["valid"];
        return inst;
      }

      public bool switchedOn = false;
      public bool active = false;
      public bool overflow = false;
      public bool underflow = false;
      public bool valid = false;
    }

    public class MetaData : ICloneable {
      public object Clone() {
        MetaData copy = new MetaData();
        copy.unit = this.unit;
        copy.id = this.id;
        copy.defaultValue = this.defaultValue;
        copy.min = this.min;
        copy.max = this.max;
        copy.read_only = this.read_only;
        copy.decDigits = this.decDigits;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["unit"] = (int)this.unit;
        json["id"] = this.id;
        json["defaultValue"] = this.defaultValue;
        json["min"] = this.min;
        json["max"] = this.max;
        json["read_only"] = this.read_only;
        json["decDigits"] = this.decDigits;
        return json;
      }

      public static MetaData Decode(LightJson.JsonObject json, Agent agent) {
        MetaData inst = new MetaData();
        inst.unit = (Com.Raritan.Idl.lhxmodel.Parameter_2_0_0.Unit)(int)json["unit"];
        inst.id = (string)json["id"];
        inst.defaultValue = (double)json["defaultValue"];
        inst.min = (double)json["min"];
        inst.max = (double)json["max"];
        inst.read_only = (bool)json["read_only"];
        inst.decDigits = (int)json["decDigits"];
        return inst;
      }

      public Com.Raritan.Idl.lhxmodel.Parameter_2_0_0.Unit unit = Com.Raritan.Idl.lhxmodel.Parameter_2_0_0.Unit.NONE;
      public string id = "";
      public double defaultValue = 0.0;
      public double min = 0.0;
      public double max = 0.0;
      public bool read_only = false;
      public int decDigits = 0;
    }

    public class Value : ICloneable {
      public object Clone() {
        Value copy = new Value();
        copy.timestamp = this.timestamp;
        copy.status = this.status;
        copy.value = this.value;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["timestamp"] = (this.timestamp.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        json["status"] = this.status.Encode();
        json["value"] = this.value;
        return json;
      }

      public static Value Decode(LightJson.JsonObject json, Agent agent) {
        Value inst = new Value();
        inst.timestamp = new System.DateTime(json["timestamp"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        inst.status = Com.Raritan.Idl.lhxmodel.Parameter_2_0_0.Status.Decode(json["status"], agent);
        inst.value = (double)json["value"];
        return inst;
      }

      public System.DateTime timestamp = new System.DateTime(0);
      public Com.Raritan.Idl.lhxmodel.Parameter_2_0_0.Status status = new Com.Raritan.Idl.lhxmodel.Parameter_2_0_0.Status();
      public double value = 0.0;
    }

    public class GetMetaDataResult {
      public Com.Raritan.Idl.lhxmodel.Parameter_2_0_0.MetaData _ret_;
    }

    public GetMetaDataResult getMetaData() {
      JsonObject _parameters = null;
      var _result = RpcCall("getMetaData", _parameters);
      var _ret = new GetMetaDataResult();
      _ret._ret_ = Com.Raritan.Idl.lhxmodel.Parameter_2_0_0.MetaData.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getMetaData(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getMetaData", _parameters,
        _result => {
          try {
            var _ret = new GetMetaDataResult();
            _ret._ret_ = Com.Raritan.Idl.lhxmodel.Parameter_2_0_0.MetaData.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetValueResult {
      public Com.Raritan.Idl.lhxmodel.Parameter_2_0_0.Value _ret_;
    }

    public GetValueResult getValue() {
      JsonObject _parameters = null;
      var _result = RpcCall("getValue", _parameters);
      var _ret = new GetValueResult();
      _ret._ret_ = Com.Raritan.Idl.lhxmodel.Parameter_2_0_0.Value.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getValue(AsyncRpcResponse<GetValueResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getValue(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getValue(AsyncRpcResponse<GetValueResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getValue", _parameters,
        _result => {
          try {
            var _ret = new GetValueResult();
            _ret._ret_ = Com.Raritan.Idl.lhxmodel.Parameter_2_0_0.Value.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetRawValueResult {
      public int _ret_;
    }

    public GetRawValueResult getRawValue() {
      JsonObject _parameters = null;
      var _result = RpcCall("getRawValue", _parameters);
      var _ret = new GetRawValueResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest getRawValue(AsyncRpcResponse<GetRawValueResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getRawValue(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getRawValue(AsyncRpcResponse<GetRawValueResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getRawValue", _parameters,
        _result => {
          try {
            var _ret = new GetRawValueResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetRawValueResult {
      public int _ret_;
    }

    public SetRawValueResult setRawValue(int rawValue, bool validateRange) {
      var _parameters = new LightJson.JsonObject();
      _parameters["rawValue"] = rawValue;
      _parameters["validateRange"] = validateRange;

      var _result = RpcCall("setRawValue", _parameters);
      var _ret = new SetRawValueResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setRawValue(int rawValue, bool validateRange, AsyncRpcResponse<SetRawValueResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setRawValue(rawValue, validateRange, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setRawValue(int rawValue, bool validateRange, AsyncRpcResponse<SetRawValueResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["rawValue"] = rawValue;
        _parameters["validateRange"] = validateRange;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setRawValue", _parameters,
        _result => {
          try {
            var _ret = new SetRawValueResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
