// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Net.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.net {

  public class InterfaceInfo_2_0_0 : ICloneable {
    public object Clone() {
      InterfaceInfo_2_0_0 copy = new InterfaceInfo_2_0_0();
      copy.name = this.name;
      copy.label = this.label;
      copy.type = this.type;
      copy.enabled = this.enabled;
      copy.masterIfName = this.masterIfName;
      copy.state = this.state;
      copy.macAddr = this.macAddr;
      copy.mtu = this.mtu;
      copy.ipv4 = this.ipv4;
      copy.ipv6 = this.ipv6;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["name"] = this.name;
      json["label"] = this.label;
      json["type"] = (int)this.type;
      json["enabled"] = this.enabled;
      json["masterIfName"] = this.masterIfName;
      json["state"] = (int)this.state;
      json["macAddr"] = this.macAddr;
      json["mtu"] = this.mtu;
      json["ipv4"] = this.ipv4.Encode();
      json["ipv6"] = this.ipv6.Encode();
      return json;
    }

    public static InterfaceInfo_2_0_0 Decode(LightJson.JsonObject json, Agent agent) {
      InterfaceInfo_2_0_0 inst = new InterfaceInfo_2_0_0();
      inst.name = (string)json["name"];
      inst.label = (string)json["label"];
      inst.type = (Com.Raritan.Idl.net.InterfaceType)(int)json["type"];
      inst.enabled = (bool)json["enabled"];
      inst.masterIfName = (string)json["masterIfName"];
      inst.state = (Com.Raritan.Idl.net.InterfaceOpState)(int)json["state"];
      inst.macAddr = (string)json["macAddr"];
      inst.mtu = (int)json["mtu"];
      inst.ipv4 = Com.Raritan.Idl.net.InterfaceIPv4Info.Decode(json["ipv4"], agent);
      inst.ipv6 = Com.Raritan.Idl.net.InterfaceIPv6Info.Decode(json["ipv6"], agent);
      return inst;
    }

    public string name = "";
    public string label = "";
    public Com.Raritan.Idl.net.InterfaceType type = Com.Raritan.Idl.net.InterfaceType.ETHERNET;
    public bool enabled = false;
    public string masterIfName = "";
    public Com.Raritan.Idl.net.InterfaceOpState state = Com.Raritan.Idl.net.InterfaceOpState.NOT_PRESENT;
    public string macAddr = "";
    public int mtu = 0;
    public Com.Raritan.Idl.net.InterfaceIPv4Info ipv4 = new Com.Raritan.Idl.net.InterfaceIPv4Info();
    public Com.Raritan.Idl.net.InterfaceIPv6Info ipv6 = new Com.Raritan.Idl.net.InterfaceIPv6Info();
  }
}
