// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from PortForwardingAutoSetup.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.net {

  public class PortForwardingAutoSetupStatus : ICloneable {
    public object Clone() {
      PortForwardingAutoSetupStatus copy = new PortForwardingAutoSetupStatus();
      copy.startTime = this.startTime;
      copy.remainingExpansionUnits = this.remainingExpansionUnits;
      copy.runningState = this.runningState;
      copy.expansionUnits = this.expansionUnits;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["startTime"] = (this.startTime.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
      json["remainingExpansionUnits"] = this.remainingExpansionUnits;
      json["runningState"] = (int)this.runningState;
      json["expansionUnits"] = new JsonArray(this.expansionUnits.Select(_entry => (JsonValue) new JsonObject(new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, LightJson.JsonValue>> {
        new System.Collections.Generic.KeyValuePair<string, JsonValue>("key", _entry.Key),
        new System.Collections.Generic.KeyValuePair<string, JsonValue>("value", _entry.Value.Encode())
      })));
      return json;
    }

    public static PortForwardingAutoSetupStatus Decode(LightJson.JsonObject json, Agent agent) {
      PortForwardingAutoSetupStatus inst = new PortForwardingAutoSetupStatus();
      inst.startTime = new System.DateTime(json["startTime"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
      inst.remainingExpansionUnits = (int)json["remainingExpansionUnits"];
      inst.runningState = (Com.Raritan.Idl.net.PortForwardingAutoSetupRunningState)(int)json["runningState"];
      inst.expansionUnits = DictionaryHelper.Create(json["expansionUnits"].AsJsonArray.Select(
        _value => new System.Collections.Generic.KeyValuePair<int, Com.Raritan.Idl.net.PortForwardingAutoSetupExpansionUnit>(_value["key"], Com.Raritan.Idl.net.PortForwardingAutoSetupExpansionUnit.Decode(_value["value"], agent))));
      return inst;
    }

    public System.DateTime startTime = new System.DateTime(0);
    public int remainingExpansionUnits = 0;
    public Com.Raritan.Idl.net.PortForwardingAutoSetupRunningState runningState = Com.Raritan.Idl.net.PortForwardingAutoSetupRunningState.PF_AUTO_SETUP_NONE;
    public System.Collections.Generic.IDictionary<int, Com.Raritan.Idl.net.PortForwardingAutoSetupExpansionUnit> expansionUnits = new System.Collections.Generic.Dictionary<int, Com.Raritan.Idl.net.PortForwardingAutoSetupExpansionUnit>();
  }
}
