// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Security.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.security {

  public class BlockSettings : ICloneable {
    public object Clone() {
      BlockSettings copy = new BlockSettings();
      copy.maxFailedLogins = this.maxFailedLogins;
      copy.blockTimeout = this.blockTimeout;
      copy.failedLoginTimeout = this.failedLoginTimeout;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["maxFailedLogins"] = this.maxFailedLogins;
      json["blockTimeout"] = this.blockTimeout;
      json["failedLoginTimeout"] = this.failedLoginTimeout;
      return json;
    }

    public static BlockSettings Decode(LightJson.JsonObject json, Agent agent) {
      BlockSettings inst = new BlockSettings();
      inst.maxFailedLogins = (int)json["maxFailedLogins"];
      inst.blockTimeout = (int)json["blockTimeout"];
      inst.failedLoginTimeout = (int)json["failedLoginTimeout"];
      return inst;
    }

    public int maxFailedLogins = 0;
    public int blockTimeout = 0;
    public int failedLoginTimeout = 0;
  }
}
