# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from AuthManager.idl.

use strict;

package Raritan::RPC::auth::AuthManager;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "auth.AuthManager:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::auth::AuthManager::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant ERR_UNSUPPORTED_TYPE => 1;

use Raritan::RPC::auth::Policy;

sub getPolicy($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getPolicy', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::auth::Policy::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::auth::Policy;

sub setPolicy($$) {
    my ($self, $p) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'p'} = Raritan::RPC::auth::Policy::encode($p);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setPolicy', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('auth.AuthManager', 1, 0, 0, 'Raritan::RPC::auth::AuthManager');
1;
