# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from PeripheralDevicePackage.idl.

use strict;

package Raritan::RPC::peripheral::DoorHandleControllerPackage_2_0_0;

use parent qw(Raritan::RPC::peripheral::Package_2_0_0);

use constant typeId => "peripheral.DoorHandleControllerPackage:2.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::peripheral::DoorHandleControllerPackage_2_0_0::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant SUCCESS => 0;

use constant ERR_NOT_SUPPORTED => 1;

use constant ERR_OPERATION_FAILED => 2;

sub getSupportedHandleTypes($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSupportedHandleTypes', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = $rsp->{'_ret_'}->[$i0];
    }
    return $_ret_;
}

sub getSupportedExternalDeviceTypes($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSupportedExternalDeviceTypes', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = $rsp->{'_ret_'}->[$i0];
    }
    return $_ret_;
}

sub getHandleType($$) {
    my ($self, $channel) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'channel'} = 1 * $channel;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getHandleType', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub getExternalDeviceType($$) {
    my ($self, $channel) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'channel'} = 1 * $channel;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getExternalDeviceType', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub setHandleType($$$) {
    my ($self, $channel, $handleType) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'channel'} = 1 * $channel;
    $args->{'handleType'} = "$handleType";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setHandleType', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub setExternalDeviceType($$$) {
    my ($self, $channel, $type) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'channel'} = 1 * $channel;
    $args->{'type'} = "$type";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setExternalDeviceType', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('peripheral.DoorHandleControllerPackage', 2, 0, 0, 'Raritan::RPC::peripheral::DoorHandleControllerPackage_2_0_0');
1;
