// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from DsamDevice.idl.

package com.raritan.idl.dsam;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface DsamDevice {
  static public final TypeInfo typeInfo = new TypeInfo("dsam.DsamDevice:1.0.0", null);

  public static final int SUCCESS = 0;

  static public class FirmwareVersion implements Cloneable {
    public int major = 0;
    public int minor = 0;

    public Object clone() {
      FirmwareVersion copy = new FirmwareVersion();

      copy.major = this.major;
      copy.minor = this.minor;

      return copy;
    }

  }

  static public class Info implements Cloneable {
    public int dsamNumber = 0;
    public String serialNumber = new String();
    public int portCount = 0;
    public int hardwareVersion = 0;
    public com.raritan.idl.dsam.DsamDevice.FirmwareVersion firmwareVersion = new com.raritan.idl.dsam.DsamDevice.FirmwareVersion();

    public Object clone() {
      Info copy = new Info();

      copy.dsamNumber = this.dsamNumber;
      copy.serialNumber = this.serialNumber;
      copy.portCount = this.portCount;
      copy.hardwareVersion = this.hardwareVersion;
      Object firmwareVersionCopy = this.firmwareVersion.clone();
      copy.firmwareVersion = (com.raritan.idl.dsam.DsamDevice.FirmwareVersion) firmwareVersionCopy;

      return copy;
    }

  }

  public class GetInfoResult {
    public com.raritan.idl.dsam.DsamDevice.Info _ret_;
  }

  GetInfoResult getInfo() throws Exception;

  AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult> rsp);

  AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult> rsp, RpcCtrl rpcCtrl);


  public class GetPortsResult {
    public java.util.Map<Integer, com.raritan.idl.dsam.DsamPort> _ret_;
  }

  GetPortsResult getPorts() throws Exception;

  AsyncRequest getPorts(AsyncRpcResponse<GetPortsResult> rsp);

  AsyncRequest getPorts(AsyncRpcResponse<GetPortsResult> rsp, RpcCtrl rpcCtrl);


  public class StartFirmwareUpdateResult {
    public int _ret_;
  }

  StartFirmwareUpdateResult startFirmwareUpdate() throws Exception;

  AsyncRequest startFirmwareUpdate(AsyncRpcResponse<StartFirmwareUpdateResult> rsp);

  AsyncRequest startFirmwareUpdate(AsyncRpcResponse<StartFirmwareUpdateResult> rsp, RpcCtrl rpcCtrl);

}
