// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from StorageManager.idl.

package com.raritan.idl.webcam;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface StorageManager_1_0_3 {
  static public final TypeInfo typeInfo = new TypeInfo("webcam.StorageManager:1.0.3", null);

  public static final int NO_ERROR = 0;

  public static final int ERR_INVALID_PARAM = 1;

  public static final int ERR_INIT_IN_PROGRESS = 2;

  public static final int ERR_ALREADY_RUNNING = 3;

  public static final int ERR_TOO_LARGE = 4;

  public static final int ERR_OPERATION_NOT_SUPPORTED = 5;

  public enum StorageType {
    LOCAL,
    FTP,
    CIFS,
    NFS;
  }

  public enum Direction {
    ASCENDING,
    DESCENDING;
  }

  public enum StorageStatus {
    INITIALIZING,
    READY;
  }

  static public class WebcamStorageInfo implements Cloneable {
    public com.raritan.idl.webcam.Webcam_2_0_2 webcam = null;
    public long newestIndex = 0;
    public long oldestIndex = 0;
    public int count = 0;

    public Object clone() {
      WebcamStorageInfo copy = new WebcamStorageInfo();

      copy.webcam = this.webcam;
      copy.newestIndex = this.newestIndex;
      copy.oldestIndex = this.oldestIndex;
      copy.count = this.count;

      return copy;
    }

  }

  static public class StorageInformation implements Cloneable {
    public com.raritan.idl.webcam.StorageManager_1_0_3.StorageStatus status = com.raritan.idl.webcam.StorageManager_1_0_3.StorageStatus.values()[0];
    public int capacity = 0;
    public int used = 0;
    public java.util.List<com.raritan.idl.webcam.StorageManager_1_0_3.WebcamStorageInfo> webcamStorageInfo = new java.util.ArrayList<>();

    public Object clone() {
      StorageInformation copy = new StorageInformation();

      copy.status = this.status;
      copy.capacity = this.capacity;
      copy.used = this.used;
      copy.webcamStorageInfo = new java.util.ArrayList<com.raritan.idl.webcam.StorageManager_1_0_3.WebcamStorageInfo>(this.webcamStorageInfo);

      return copy;
    }

  }

  static public class StorageSettings implements Cloneable {
    public com.raritan.idl.webcam.StorageManager_1_0_3.StorageType type = com.raritan.idl.webcam.StorageManager_1_0_3.StorageType.values()[0];
    public int capacity = 0;
    public String server = new String();
    public String username = new String();
    public String password = new String();

    public Object clone() {
      StorageSettings copy = new StorageSettings();

      copy.type = this.type;
      copy.capacity = this.capacity;
      copy.server = this.server;
      copy.username = this.username;
      copy.password = this.password;

      return copy;
    }

  }

  static public class StorageMetaData implements Cloneable {
    public long index = 0;
    public com.raritan.idl.webcam.Webcam_2_0_2 webcam = null;

    public Object clone() {
      StorageMetaData copy = new StorageMetaData();

      copy.index = this.index;
      copy.webcam = this.webcam;

      return copy;
    }

  }

  static public class ImageStorageMetaData implements Cloneable {
    public com.raritan.idl.webcam.ImageMetaData imageMeta = new com.raritan.idl.webcam.ImageMetaData();
    public int fileSize = 0;
    public com.raritan.idl.webcam.StorageManager_1_0_3.StorageMetaData storageMeta = new com.raritan.idl.webcam.StorageManager_1_0_3.StorageMetaData();

    public Object clone() {
      ImageStorageMetaData copy = new ImageStorageMetaData();

      Object imageMetaCopy = this.imageMeta.clone();
      copy.imageMeta = (com.raritan.idl.webcam.ImageMetaData) imageMetaCopy;
      copy.fileSize = this.fileSize;
      Object storageMetaCopy = this.storageMeta.clone();
      copy.storageMeta = (com.raritan.idl.webcam.StorageManager_1_0_3.StorageMetaData) storageMetaCopy;

      return copy;
    }

  }

  static public class StorageImage implements Cloneable {
    public com.raritan.idl.webcam.Image_2_0_0 image = new com.raritan.idl.webcam.Image_2_0_0();
    public com.raritan.idl.webcam.StorageManager_1_0_3.StorageMetaData metaData = new com.raritan.idl.webcam.StorageManager_1_0_3.StorageMetaData();

    public Object clone() {
      StorageImage copy = new StorageImage();

      Object imageCopy = this.image.clone();
      copy.image = (com.raritan.idl.webcam.Image_2_0_0) imageCopy;
      Object metaDataCopy = this.metaData.clone();
      copy.metaData = (com.raritan.idl.webcam.StorageManager_1_0_3.StorageMetaData) metaDataCopy;

      return copy;
    }

  }

  static public class Activity implements Cloneable {
    public com.raritan.idl.webcam.Webcam_2_0_2 webcam = null;
    public int interval = 0;
    public int count = 0;
    public int done = 0;

    public Object clone() {
      Activity copy = new Activity();

      copy.webcam = this.webcam;
      copy.interval = this.interval;
      copy.count = this.count;
      copy.done = this.done;

      return copy;
    }

  }

  public class ImageUploadStartedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("webcam.StorageManager_1_0_3.ImageUploadStartedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.webcam.Webcam_2_0_2 webcam = null;
    public String folderUrl = new String();
  }

  public class GetSupportedStorageTypesResult {
    public java.util.List<com.raritan.idl.webcam.StorageManager_1_0_3.StorageType> _ret_;
  }

  GetSupportedStorageTypesResult getSupportedStorageTypes() throws Exception;

  AsyncRequest getSupportedStorageTypes(AsyncRpcResponse<GetSupportedStorageTypesResult> rsp);

  AsyncRequest getSupportedStorageTypes(AsyncRpcResponse<GetSupportedStorageTypesResult> rsp, RpcCtrl rpcCtrl);


  public class GetInformationResult {
    public com.raritan.idl.webcam.StorageManager_1_0_3.StorageInformation _ret_;
  }

  GetInformationResult getInformation() throws Exception;

  AsyncRequest getInformation(AsyncRpcResponse<GetInformationResult> rsp);

  AsyncRequest getInformation(AsyncRpcResponse<GetInformationResult> rsp, RpcCtrl rpcCtrl);


  public class GetSettingsResult {
    public com.raritan.idl.webcam.StorageManager_1_0_3.StorageSettings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(com.raritan.idl.webcam.StorageManager_1_0_3.StorageSettings settings) throws Exception;

  AsyncRequest setSettings(com.raritan.idl.webcam.StorageManager_1_0_3.StorageSettings settings, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(com.raritan.idl.webcam.StorageManager_1_0_3.StorageSettings settings, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class AddImageResult {
    public int _ret_;
    public long index;
  }

  AddImageResult addImage(com.raritan.idl.webcam.Webcam_2_0_2 webcam, com.raritan.idl.webcam.Image_2_0_0 image) throws Exception;

  AsyncRequest addImage(com.raritan.idl.webcam.Webcam_2_0_2 webcam, com.raritan.idl.webcam.Image_2_0_0 image, AsyncRpcResponse<AddImageResult> rsp);

  AsyncRequest addImage(com.raritan.idl.webcam.Webcam_2_0_2 webcam, com.raritan.idl.webcam.Image_2_0_0 image, AsyncRpcResponse<AddImageResult> rsp, RpcCtrl rpcCtrl);


  public class RemoveImagesResult {
    public int _ret_;
  }

  RemoveImagesResult removeImages(com.raritan.idl.webcam.Webcam_2_0_2 webcam, long start, int count, com.raritan.idl.webcam.StorageManager_1_0_3.Direction direction) throws Exception;

  AsyncRequest removeImages(com.raritan.idl.webcam.Webcam_2_0_2 webcam, long start, int count, com.raritan.idl.webcam.StorageManager_1_0_3.Direction direction, AsyncRpcResponse<RemoveImagesResult> rsp);

  AsyncRequest removeImages(com.raritan.idl.webcam.Webcam_2_0_2 webcam, long start, int count, com.raritan.idl.webcam.StorageManager_1_0_3.Direction direction, AsyncRpcResponse<RemoveImagesResult> rsp, RpcCtrl rpcCtrl);


  public class GetMetaDataResult {
    public int _ret_;
    public java.util.List<com.raritan.idl.webcam.StorageManager_1_0_3.ImageStorageMetaData> meta;
  }

  GetMetaDataResult getMetaData(com.raritan.idl.webcam.Webcam_2_0_2 webcam, long start, int count, com.raritan.idl.webcam.StorageManager_1_0_3.Direction direction) throws Exception;

  AsyncRequest getMetaData(com.raritan.idl.webcam.Webcam_2_0_2 webcam, long start, int count, com.raritan.idl.webcam.StorageManager_1_0_3.Direction direction, AsyncRpcResponse<GetMetaDataResult> rsp);

  AsyncRequest getMetaData(com.raritan.idl.webcam.Webcam_2_0_2 webcam, long start, int count, com.raritan.idl.webcam.StorageManager_1_0_3.Direction direction, AsyncRpcResponse<GetMetaDataResult> rsp, RpcCtrl rpcCtrl);


  public class GetImagesResult {
    public int _ret_;
    public java.util.List<com.raritan.idl.webcam.StorageManager_1_0_3.StorageImage> image;
  }

  GetImagesResult getImages(com.raritan.idl.webcam.Webcam_2_0_2 webcam, long start, int count, com.raritan.idl.webcam.StorageManager_1_0_3.Direction direction) throws Exception;

  AsyncRequest getImages(com.raritan.idl.webcam.Webcam_2_0_2 webcam, long start, int count, com.raritan.idl.webcam.StorageManager_1_0_3.Direction direction, AsyncRpcResponse<GetImagesResult> rsp);

  AsyncRequest getImages(com.raritan.idl.webcam.Webcam_2_0_2 webcam, long start, int count, com.raritan.idl.webcam.StorageManager_1_0_3.Direction direction, AsyncRpcResponse<GetImagesResult> rsp, RpcCtrl rpcCtrl);


  public class GetActivitiesResult {
    public java.util.List<com.raritan.idl.webcam.StorageManager_1_0_3.Activity> _ret_;
  }

  GetActivitiesResult getActivities() throws Exception;

  AsyncRequest getActivities(AsyncRpcResponse<GetActivitiesResult> rsp);

  AsyncRequest getActivities(AsyncRpcResponse<GetActivitiesResult> rsp, RpcCtrl rpcCtrl);


  public class StartActivityResult {
    public int _ret_;
  }

  StartActivityResult startActivity(com.raritan.idl.webcam.Webcam_2_0_2 webcam, int count, int interval) throws Exception;

  AsyncRequest startActivity(com.raritan.idl.webcam.Webcam_2_0_2 webcam, int count, int interval, AsyncRpcResponse<StartActivityResult> rsp);

  AsyncRequest startActivity(com.raritan.idl.webcam.Webcam_2_0_2 webcam, int count, int interval, AsyncRpcResponse<StartActivityResult> rsp, RpcCtrl rpcCtrl);


  public class StartActivityWithFolderResult {
    public int _ret_;
  }

  StartActivityWithFolderResult startActivityWithFolder(com.raritan.idl.webcam.Webcam_2_0_2 webcam, int count, int interval, String folder) throws Exception;

  AsyncRequest startActivityWithFolder(com.raritan.idl.webcam.Webcam_2_0_2 webcam, int count, int interval, String folder, AsyncRpcResponse<StartActivityWithFolderResult> rsp);

  AsyncRequest startActivityWithFolder(com.raritan.idl.webcam.Webcam_2_0_2 webcam, int count, int interval, String folder, AsyncRpcResponse<StartActivityWithFolderResult> rsp, RpcCtrl rpcCtrl);


  public class StopActivityResult {
    public int _ret_;
  }

  StopActivityResult stopActivity(com.raritan.idl.webcam.Webcam_2_0_2 webcam) throws Exception;

  AsyncRequest stopActivity(com.raritan.idl.webcam.Webcam_2_0_2 webcam, AsyncRpcResponse<StopActivityResult> rsp);

  AsyncRequest stopActivity(com.raritan.idl.webcam.Webcam_2_0_2 webcam, AsyncRpcResponse<StopActivityResult> rsp, RpcCtrl rpcCtrl);

}
