// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ServerSSLCert.idl.

package com.raritan.json_rpc.cert;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class ServerSSLCert_Proxy extends ObjectProxy implements com.raritan.idl.cert.ServerSSLCert {

  public ServerSSLCert_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public ServerSSLCert_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.cert.ServerSSLCert.typeInfo);
  }

  public static ServerSSLCert_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new ServerSSLCert_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public GenerateUnsignedKeyPairResult generateUnsignedKeyPair(final com.raritan.idl.cert.ServerSSLCert.ReqInfo reqInfo, final String challenge) throws Exception {
    JSONObject params = new JSONObject();
    params.put("reqInfo", com.raritan.json_rpc.cert.ServerSSLCert.ReqInfo_Codec.encode(reqInfo));
    params.put("challenge", challenge);
    final JSONObject result = rpcCall("generateUnsignedKeyPair", params);
    GenerateUnsignedKeyPairResult ret = new GenerateUnsignedKeyPairResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest generateUnsignedKeyPair(final com.raritan.idl.cert.ServerSSLCert.ReqInfo reqInfo, final String challenge, final AsyncRpcResponse<GenerateUnsignedKeyPairResult> rsp) {
    return generateUnsignedKeyPair(reqInfo, challenge, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest generateUnsignedKeyPair(final com.raritan.idl.cert.ServerSSLCert.ReqInfo reqInfo, final String challenge, final AsyncRpcResponse<GenerateUnsignedKeyPairResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("reqInfo", com.raritan.json_rpc.cert.ServerSSLCert.ReqInfo_Codec.encode(reqInfo));
      params.put("challenge", challenge);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("generateUnsignedKeyPair", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GenerateUnsignedKeyPairResult ret = new GenerateUnsignedKeyPairResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GenerateSelfSignedKeyPairResult generateSelfSignedKeyPair(final com.raritan.idl.cert.ServerSSLCert.ReqInfo reqInfo, final int days) throws Exception {
    JSONObject params = new JSONObject();
    params.put("reqInfo", com.raritan.json_rpc.cert.ServerSSLCert.ReqInfo_Codec.encode(reqInfo));
    params.put("days", days);
    final JSONObject result = rpcCall("generateSelfSignedKeyPair", params);
    GenerateSelfSignedKeyPairResult ret = new GenerateSelfSignedKeyPairResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest generateSelfSignedKeyPair(final com.raritan.idl.cert.ServerSSLCert.ReqInfo reqInfo, final int days, final AsyncRpcResponse<GenerateSelfSignedKeyPairResult> rsp) {
    return generateSelfSignedKeyPair(reqInfo, days, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest generateSelfSignedKeyPair(final com.raritan.idl.cert.ServerSSLCert.ReqInfo reqInfo, final int days, final AsyncRpcResponse<GenerateSelfSignedKeyPairResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("reqInfo", com.raritan.json_rpc.cert.ServerSSLCert.ReqInfo_Codec.encode(reqInfo));
      params.put("days", days);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("generateSelfSignedKeyPair", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GenerateSelfSignedKeyPairResult ret = new GenerateSelfSignedKeyPairResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public Void deletePending() throws Exception {
    JSONObject params = null;
    rpcCall("deletePending", params);
    Void ret = null;
    return ret;
  }

  @Override
  public AsyncRequest deletePending(final AsyncRpcResponse<Void> rsp) {
    return deletePending(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest deletePending(final AsyncRpcResponse<Void> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("deletePending", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          Void ret = null;
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetInfoResult getInfo() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getInfo", params);
    GetInfoResult ret = new GetInfoResult();
    ret.info = com.raritan.json_rpc.cert.ServerSSLCert.Info_Codec.decode(result.getJSONObject("info"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getInfo(final AsyncRpcResponse<GetInfoResult> rsp) {
    return getInfo(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getInfo(final AsyncRpcResponse<GetInfoResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getInfo", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetInfoResult ret = new GetInfoResult();
          ret.info = com.raritan.json_rpc.cert.ServerSSLCert.Info_Codec.decode(result.getJSONObject("info"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public InstallPendingKeyPairResult installPendingKeyPair() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("installPendingKeyPair", params);
    InstallPendingKeyPairResult ret = new InstallPendingKeyPairResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest installPendingKeyPair(final AsyncRpcResponse<InstallPendingKeyPairResult> rsp) {
    return installPendingKeyPair(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest installPendingKeyPair(final AsyncRpcResponse<InstallPendingKeyPairResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("installPendingKeyPair", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          InstallPendingKeyPairResult ret = new InstallPendingKeyPairResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
