// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2010 Raritan Inc. All rights reserved.

package com.raritan.util;

import java.util.ArrayList;
import java.util.List;

public class AsyncMultiRequestFailure extends Exception {
    private static final long serialVersionUID = 1L;

    private List<AsyncRequest> m_failedRequests;
    ArrayList<Exception> m_failExcs = new ArrayList<Exception>();

    public AsyncMultiRequestFailure(List<AsyncRequest> failRequests) {
        super("Some asynchronous requests failed.");
        m_failedRequests = failRequests;

        for (AsyncRequest request : failRequests) {
            m_failExcs.add(request.getFailureException());
        }
    }

    public List<AsyncRequest> getFailRequests() {
        return m_failedRequests;
    }

    public List<Exception> getFailureExceptions() {
        return m_failExcs;
    }
}
