// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from DataPushService.idl.

package com.raritan.idl.event;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface DataPushService_1_0_3 {
  static public final TypeInfo typeInfo = new TypeInfo("event.DataPushService:1.0.3", null);

  public enum EntryType {
    SENSORLIST,
    SENSORLOG,
    AMSLIST,
    AMSLOG,
    AUDITLOG;
  }

  public static final int ERR_NO_SUCH_ID = 1;

  public static final int ERR_INVALID_PARAMS = 2;

  public static final int ERR_MAX_ENTRIES_REACHED = 3;

  static public class MqttSettings implements Cloneable {
    public String topicPrefix = new String();

    public Object clone() {
      MqttSettings copy = new MqttSettings();

      copy.topicPrefix = this.topicPrefix;

      return copy;
    }

  }

  static public class EntrySettings implements Cloneable {
    public String url = new String();
    public boolean allowOffTimeRangeCerts = false;
    public String caCertChain = new String();
    public boolean useAuth = false;
    public String username = new String();
    public String password = new String();
    public com.raritan.idl.event.DataPushService_1_0_3.EntryType type = com.raritan.idl.event.DataPushService_1_0_3.EntryType.values()[0];
    public java.util.List<String> items = new java.util.ArrayList<>();
    public com.raritan.idl.event.DataPushService_1_0_3.MqttSettings mqttSettings = new com.raritan.idl.event.DataPushService_1_0_3.MqttSettings();

    public Object clone() {
      EntrySettings copy = new EntrySettings();

      copy.url = this.url;
      copy.allowOffTimeRangeCerts = this.allowOffTimeRangeCerts;
      copy.caCertChain = this.caCertChain;
      copy.useAuth = this.useAuth;
      copy.username = this.username;
      copy.password = this.password;
      copy.type = this.type;
      copy.items = new java.util.ArrayList<String>(this.items);
      Object mqttSettingsCopy = this.mqttSettings.clone();
      copy.mqttSettings = (com.raritan.idl.event.DataPushService_1_0_3.MqttSettings) mqttSettingsCopy;

      return copy;
    }

  }

  static public class EntryStatus implements Cloneable {
    public boolean busy = false;
    public boolean rescheduled = false;
    public java.util.Date lastAttemptTime = new java.util.Date();
    public java.util.Date lastSuccessTime = new java.util.Date();

    public Object clone() {
      EntryStatus copy = new EntryStatus();

      copy.busy = this.busy;
      copy.rescheduled = this.rescheduled;
      copy.lastAttemptTime = this.lastAttemptTime;
      copy.lastSuccessTime = this.lastSuccessTime;

      return copy;
    }

  }

  public class EntryAddedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("event.DataPushService_1_0_3.EntryAddedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int entryId = 0;
    public com.raritan.idl.event.DataPushService_1_0_3.EntrySettings settings = new com.raritan.idl.event.DataPushService_1_0_3.EntrySettings();
  }

  public class EntryModifiedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("event.DataPushService_1_0_3.EntryModifiedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int entryId = 0;
    public com.raritan.idl.event.DataPushService_1_0_3.EntrySettings oldSettings = new com.raritan.idl.event.DataPushService_1_0_3.EntrySettings();
    public com.raritan.idl.event.DataPushService_1_0_3.EntrySettings newSettings = new com.raritan.idl.event.DataPushService_1_0_3.EntrySettings();
  }

  public class EntryDeletedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("event.DataPushService_1_0_3.EntryDeletedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int entryId = 0;
  }

  public class EntryStatusChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("event.DataPushService_1_0_3.EntryStatusChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public int entryId = 0;
    public com.raritan.idl.event.DataPushService_1_0_3.EntryStatus newStatus = new com.raritan.idl.event.DataPushService_1_0_3.EntryStatus();
  }

  public class AddEntryResult {
    public int _ret_;
    public int entryId;
  }

  AddEntryResult addEntry(com.raritan.idl.event.DataPushService_1_0_3.EntrySettings entrySettings) throws Exception;

  AsyncRequest addEntry(com.raritan.idl.event.DataPushService_1_0_3.EntrySettings entrySettings, AsyncRpcResponse<AddEntryResult> rsp);

  AsyncRequest addEntry(com.raritan.idl.event.DataPushService_1_0_3.EntrySettings entrySettings, AsyncRpcResponse<AddEntryResult> rsp, RpcCtrl rpcCtrl);


  public class ModifyEntryResult {
    public int _ret_;
  }

  ModifyEntryResult modifyEntry(int entryId, com.raritan.idl.event.DataPushService_1_0_3.EntrySettings entrySettings) throws Exception;

  AsyncRequest modifyEntry(int entryId, com.raritan.idl.event.DataPushService_1_0_3.EntrySettings entrySettings, AsyncRpcResponse<ModifyEntryResult> rsp);

  AsyncRequest modifyEntry(int entryId, com.raritan.idl.event.DataPushService_1_0_3.EntrySettings entrySettings, AsyncRpcResponse<ModifyEntryResult> rsp, RpcCtrl rpcCtrl);


  public class DeleteEntryResult {
    public int _ret_;
  }

  DeleteEntryResult deleteEntry(int entryId) throws Exception;

  AsyncRequest deleteEntry(int entryId, AsyncRpcResponse<DeleteEntryResult> rsp);

  AsyncRequest deleteEntry(int entryId, AsyncRpcResponse<DeleteEntryResult> rsp, RpcCtrl rpcCtrl);


  public class GetEntryResult {
    public int _ret_;
    public com.raritan.idl.event.DataPushService_1_0_3.EntrySettings entrySettings;
  }

  GetEntryResult getEntry(int entryId) throws Exception;

  AsyncRequest getEntry(int entryId, AsyncRpcResponse<GetEntryResult> rsp);

  AsyncRequest getEntry(int entryId, AsyncRpcResponse<GetEntryResult> rsp, RpcCtrl rpcCtrl);


  public class ListEntriesResult {
    public java.util.Map<Integer, com.raritan.idl.event.DataPushService_1_0_3.EntrySettings> _ret_;
  }

  ListEntriesResult listEntries() throws Exception;

  AsyncRequest listEntries(AsyncRpcResponse<ListEntriesResult> rsp);

  AsyncRequest listEntries(AsyncRpcResponse<ListEntriesResult> rsp, RpcCtrl rpcCtrl);


  public class PushDataResult {
    public int _ret_;
  }

  PushDataResult pushData(int entryId) throws Exception;

  AsyncRequest pushData(int entryId, AsyncRpcResponse<PushDataResult> rsp);

  AsyncRequest pushData(int entryId, AsyncRpcResponse<PushDataResult> rsp, RpcCtrl rpcCtrl);

  Void cancelDataPush(int entryId) throws Exception;

  AsyncRequest cancelDataPush(int entryId, AsyncRpcResponse<Void> rsp);

  AsyncRequest cancelDataPush(int entryId, AsyncRpcResponse<Void> rsp, RpcCtrl rpcCtrl);


  public class GetEntryStatusResult {
    public int _ret_;
    public com.raritan.idl.event.DataPushService_1_0_3.EntryStatus entryStatus;
  }

  GetEntryStatusResult getEntryStatus(int entryId) throws Exception;

  AsyncRequest getEntryStatus(int entryId, AsyncRpcResponse<GetEntryStatusResult> rsp);

  AsyncRequest getEntryStatus(int entryId, AsyncRpcResponse<GetEntryStatusResult> rsp, RpcCtrl rpcCtrl);

}
