// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from PeripheralDeviceManager.idl.

package com.raritan.idl.peripheral;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface DeviceManager {
  static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager:1.0.0", null);

  public static final int ERR_INVALID_PARAMS = 1;

  public enum Events {
    EVT_KEY_SETTINGS_CHANGED,
    EVT_KEY_DEVICE_ADDED,
    EVT_KEY_DEVICE_REMOVED;
  }

  public enum ZCoordMode {
    RACKUNITS,
    FREEFORM;
  }

  static public class Settings implements Cloneable {
    public com.raritan.idl.peripheral.DeviceManager.ZCoordMode zCoordMode = com.raritan.idl.peripheral.DeviceManager.ZCoordMode.values()[0];
    public boolean autoManageNewDevices = false;
    public float deviceAltitude = 0.0f;
    public int presenceDetectionTimeout = 0;
    public java.util.Map<String, com.raritan.idl.sensors.NumericSensor_3_0_0.Thresholds> defaultThresholdsMap = new java.util.HashMap<>();

    public Object clone() {
      Settings copy = new Settings();

      copy.zCoordMode = this.zCoordMode;
      copy.autoManageNewDevices = this.autoManageNewDevices;
      copy.deviceAltitude = this.deviceAltitude;
      copy.presenceDetectionTimeout = this.presenceDetectionTimeout;
      copy.defaultThresholdsMap = new java.util.HashMap<String, com.raritan.idl.sensors.NumericSensor_3_0_0.Thresholds>(this.defaultThresholdsMap);

      return copy;
    }

  }

  static public class MetaData implements Cloneable {
    public int oneWirePortCount = 0;
    public int onboardDeviceCount = 0;

    public Object clone() {
      MetaData copy = new MetaData();

      copy.oneWirePortCount = this.oneWirePortCount;
      copy.onboardDeviceCount = this.onboardDeviceCount;

      return copy;
    }

  }

  static public class DeviceTypeInfo implements Cloneable {
    public com.raritan.idl.sensors.Sensor_3_0_0.TypeSpec type = new com.raritan.idl.sensors.Sensor_3_0_0.TypeSpec();
    public boolean isActuator = false;
    public String identifier = new String();
    public String name = new String();
    public com.raritan.idl.sensors.NumericSensor_3_0_0.Range defaultRange = new com.raritan.idl.sensors.NumericSensor_3_0_0.Range();
    public int defaultDecDigits = 0;

    public Object clone() {
      DeviceTypeInfo copy = new DeviceTypeInfo();

      Object typeCopy = this.type.clone();
      copy.type = (com.raritan.idl.sensors.Sensor_3_0_0.TypeSpec) typeCopy;
      copy.isActuator = this.isActuator;
      copy.identifier = this.identifier;
      copy.name = this.name;
      Object defaultRangeCopy = this.defaultRange.clone();
      copy.defaultRange = (com.raritan.idl.sensors.NumericSensor_3_0_0.Range) defaultRangeCopy;
      copy.defaultDecDigits = this.defaultDecDigits;

      return copy;
    }

  }

  public class GetDeviceSlotsResult {
    public java.util.List<com.raritan.idl.peripheral.DeviceSlot> _ret_;
  }

  GetDeviceSlotsResult getDeviceSlots() throws Exception;

  AsyncRequest getDeviceSlots(AsyncRpcResponse<GetDeviceSlotsResult> rsp);

  AsyncRequest getDeviceSlots(AsyncRpcResponse<GetDeviceSlotsResult> rsp, RpcCtrl rpcCtrl);


  public class GetDeviceSlotResult {
    public com.raritan.idl.peripheral.DeviceSlot _ret_;
  }

  GetDeviceSlotResult getDeviceSlot(int idx) throws Exception;

  AsyncRequest getDeviceSlot(int idx, AsyncRpcResponse<GetDeviceSlotResult> rsp);

  AsyncRequest getDeviceSlot(int idx, AsyncRpcResponse<GetDeviceSlotResult> rsp, RpcCtrl rpcCtrl);


  public class GetDiscoveredDevicesResult {
    public java.util.List<com.raritan.idl.peripheral.Device> _ret_;
  }

  GetDiscoveredDevicesResult getDiscoveredDevices() throws Exception;

  AsyncRequest getDiscoveredDevices(AsyncRpcResponse<GetDiscoveredDevicesResult> rsp);

  AsyncRequest getDiscoveredDevices(AsyncRpcResponse<GetDiscoveredDevicesResult> rsp, RpcCtrl rpcCtrl);


  public class GetSettingsResult {
    public com.raritan.idl.peripheral.DeviceManager.Settings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(com.raritan.idl.peripheral.DeviceManager.Settings settings) throws Exception;

  AsyncRequest setSettings(com.raritan.idl.peripheral.DeviceManager.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(com.raritan.idl.peripheral.DeviceManager.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class GetMetaDataResult {
    public com.raritan.idl.peripheral.DeviceManager.MetaData _ret_;
  }

  GetMetaDataResult getMetaData() throws Exception;

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp);

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp, RpcCtrl rpcCtrl);


  public class GetDeviceTypeInfosResult {
    public java.util.List<com.raritan.idl.peripheral.DeviceManager.DeviceTypeInfo> _ret_;
  }

  GetDeviceTypeInfosResult getDeviceTypeInfos() throws Exception;

  AsyncRequest getDeviceTypeInfos(AsyncRpcResponse<GetDeviceTypeInfosResult> rsp);

  AsyncRequest getDeviceTypeInfos(AsyncRpcResponse<GetDeviceTypeInfosResult> rsp, RpcCtrl rpcCtrl);

}
