// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from PeripheralDeviceSlot.idl.

package com.raritan.idl.peripheral;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface DeviceSlot_5_0_0 {
  static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceSlot:5.0.0", null);

  public static final int ERR_INVALID_PARAMS = 1;

  public static final int ERR_NOT_SUPPORTED = 2;

  public static final int CHANNEL_INVALID = -1;

  static public class Location implements Cloneable {
    public String x = new String();
    public String y = new String();
    public String z = new String();

    public Object clone() {
      Location copy = new Location();

      copy.x = this.x;
      copy.y = this.y;
      copy.z = this.z;

      return copy;
    }

  }

  static public class Settings implements Cloneable {
    public String name = new String();
    public String description = new String();
    public com.raritan.idl.peripheral.DeviceSlot_5_0_0.Location location = new com.raritan.idl.peripheral.DeviceSlot_5_0_0.Location();
    public boolean useDefaultThresholds = false;
    public java.util.Map<String, String> properties = new java.util.HashMap<>();

    public Object clone() {
      Settings copy = new Settings();

      copy.name = this.name;
      copy.description = this.description;
      Object locationCopy = this.location.clone();
      copy.location = (com.raritan.idl.peripheral.DeviceSlot_5_0_0.Location) locationCopy;
      copy.useDefaultThresholds = this.useDefaultThresholds;
      copy.properties = new java.util.HashMap<String, String>(this.properties);

      return copy;
    }

  }

  public class DeviceChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceSlot_5_0_0.DeviceChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.peripheral.Device_7_0_0 oldDevice = new com.raritan.idl.peripheral.Device_7_0_0();
    public com.raritan.idl.peripheral.Device_7_0_0 newDevice = new com.raritan.idl.peripheral.Device_7_0_0();
  }

  public class SettingsChangedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceSlot_5_0_0.SettingsChangedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.peripheral.DeviceSlot_5_0_0.Settings oldSettings = new com.raritan.idl.peripheral.DeviceSlot_5_0_0.Settings();
    public com.raritan.idl.peripheral.DeviceSlot_5_0_0.Settings newSettings = new com.raritan.idl.peripheral.DeviceSlot_5_0_0.Settings();
  }

  public class GetDeviceResult {
    public com.raritan.idl.peripheral.Device_7_0_0 _ret_;
  }

  GetDeviceResult getDevice() throws Exception;

  AsyncRequest getDevice(AsyncRpcResponse<GetDeviceResult> rsp);

  AsyncRequest getDevice(AsyncRpcResponse<GetDeviceResult> rsp, RpcCtrl rpcCtrl);


  public class AssignResult {
    public int _ret_;
  }

  AssignResult assign(com.raritan.idl.peripheral.DeviceID_5_0_0 devid) throws Exception;

  AsyncRequest assign(com.raritan.idl.peripheral.DeviceID_5_0_0 devid, AsyncRpcResponse<AssignResult> rsp);

  AsyncRequest assign(com.raritan.idl.peripheral.DeviceID_5_0_0 devid, AsyncRpcResponse<AssignResult> rsp, RpcCtrl rpcCtrl);


  public class AssignAddressResult {
    public int _ret_;
  }

  AssignAddressResult assignAddress(String packageClass, com.raritan.idl.peripheral.Address_8_0_0 address) throws Exception;

  AsyncRequest assignAddress(String packageClass, com.raritan.idl.peripheral.Address_8_0_0 address, AsyncRpcResponse<AssignAddressResult> rsp);

  AsyncRequest assignAddress(String packageClass, com.raritan.idl.peripheral.Address_8_0_0 address, AsyncRpcResponse<AssignAddressResult> rsp, RpcCtrl rpcCtrl);


  public class UnassignResult {
    public int _ret_;
  }

  UnassignResult unassign() throws Exception;

  AsyncRequest unassign(AsyncRpcResponse<UnassignResult> rsp);

  AsyncRequest unassign(AsyncRpcResponse<UnassignResult> rsp, RpcCtrl rpcCtrl);


  public class GetSettingsResult {
    public com.raritan.idl.peripheral.DeviceSlot_5_0_0.Settings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(com.raritan.idl.peripheral.DeviceSlot_5_0_0.Settings settings) throws Exception;

  AsyncRequest setSettings(com.raritan.idl.peripheral.DeviceSlot_5_0_0.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(com.raritan.idl.peripheral.DeviceSlot_5_0_0.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);

}
