// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from PeripheralG2Production.idl.

package com.raritan.idl.peripheral;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface G2Production {
  static public final TypeInfo typeInfo = new TypeInfo("peripheral.G2Production:1.0.0", null);

  public static final int ERR_INVALID_PARAMS = 1;

  public static final int ERR_NO_CONFIG_MODE = 2;

  public static final int ERR_NO_DEVICE = 3;

  public static final int ERR_NO_FIRMWARE_FILE = 4;

  public static final int ERR_FIRMWARE_INVALID = 5;

  public static final int ERR_PROTECTED = 6;

  static public class FirmwareInfo implements Cloneable {
    public int crc = 0;
    public String compiler = new String();
    public int compilerVersion = 0;
    public String compileDate = new String();
    public int version = 0;
    public int subVersion = 0;
    public int configurationId = 0;

    public Object clone() {
      FirmwareInfo copy = new FirmwareInfo();

      copy.crc = this.crc;
      copy.compiler = this.compiler;
      copy.compilerVersion = this.compilerVersion;
      copy.compileDate = this.compileDate;
      copy.version = this.version;
      copy.subVersion = this.subVersion;
      copy.configurationId = this.configurationId;

      return copy;
    }

  }

  public class UpdateFirmwareResult {
    public int _ret_;
    public com.raritan.idl.peripheral.G2Production.FirmwareInfo info;
  }

  UpdateFirmwareResult updateFirmware(String romcode) throws Exception;

  AsyncRequest updateFirmware(String romcode, AsyncRpcResponse<UpdateFirmwareResult> rsp);

  AsyncRequest updateFirmware(String romcode, AsyncRpcResponse<UpdateFirmwareResult> rsp, RpcCtrl rpcCtrl);


  public class UpdateFirmwarePosResult {
    public int _ret_;
    public com.raritan.idl.peripheral.G2Production.FirmwareInfo info;
  }

  UpdateFirmwarePosResult updateFirmwarePos(java.util.List<com.raritan.idl.peripheral.PosElement> position) throws Exception;

  AsyncRequest updateFirmwarePos(java.util.List<com.raritan.idl.peripheral.PosElement> position, AsyncRpcResponse<UpdateFirmwarePosResult> rsp);

  AsyncRequest updateFirmwarePos(java.util.List<com.raritan.idl.peripheral.PosElement> position, AsyncRpcResponse<UpdateFirmwarePosResult> rsp, RpcCtrl rpcCtrl);


  public class GetFirmwareInfoResult {
    public int _ret_;
    public com.raritan.idl.peripheral.G2Production.FirmwareInfo info;
  }

  GetFirmwareInfoResult getFirmwareInfo(String romcode) throws Exception;

  AsyncRequest getFirmwareInfo(String romcode, AsyncRpcResponse<GetFirmwareInfoResult> rsp);

  AsyncRequest getFirmwareInfo(String romcode, AsyncRpcResponse<GetFirmwareInfoResult> rsp, RpcCtrl rpcCtrl);


  public class GetFirmwareInfoPosResult {
    public int _ret_;
    public com.raritan.idl.peripheral.G2Production.FirmwareInfo info;
  }

  GetFirmwareInfoPosResult getFirmwareInfoPos(java.util.List<com.raritan.idl.peripheral.PosElement> position) throws Exception;

  AsyncRequest getFirmwareInfoPos(java.util.List<com.raritan.idl.peripheral.PosElement> position, AsyncRpcResponse<GetFirmwareInfoPosResult> rsp);

  AsyncRequest getFirmwareInfoPos(java.util.List<com.raritan.idl.peripheral.PosElement> position, AsyncRpcResponse<GetFirmwareInfoPosResult> rsp, RpcCtrl rpcCtrl);


  public enum ConfigurationSpace {
    HARDWARE,
    FUNCTION,
    FIRMWARE,
    RESERVED;
  }

  public class ReadConfigurationSpaceResult {
    public int _ret_;
    public java.util.List<Byte> cfg;
  }

  ReadConfigurationSpaceResult readConfigurationSpace(String romcode, com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs) throws Exception;

  AsyncRequest readConfigurationSpace(String romcode, com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, AsyncRpcResponse<ReadConfigurationSpaceResult> rsp);

  AsyncRequest readConfigurationSpace(String romcode, com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, AsyncRpcResponse<ReadConfigurationSpaceResult> rsp, RpcCtrl rpcCtrl);


  public class ReadConfigurationSpacePosResult {
    public int _ret_;
    public java.util.List<Byte> cfg;
  }

  ReadConfigurationSpacePosResult readConfigurationSpacePos(java.util.List<com.raritan.idl.peripheral.PosElement> position, com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs) throws Exception;

  AsyncRequest readConfigurationSpacePos(java.util.List<com.raritan.idl.peripheral.PosElement> position, com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, AsyncRpcResponse<ReadConfigurationSpacePosResult> rsp);

  AsyncRequest readConfigurationSpacePos(java.util.List<com.raritan.idl.peripheral.PosElement> position, com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, AsyncRpcResponse<ReadConfigurationSpacePosResult> rsp, RpcCtrl rpcCtrl);


  public class WriteConfigurationSpaceResult {
    public int _ret_;
  }

  WriteConfigurationSpaceResult writeConfigurationSpace(String romcode, com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, java.util.List<Byte> cfg) throws Exception;

  AsyncRequest writeConfigurationSpace(String romcode, com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, java.util.List<Byte> cfg, AsyncRpcResponse<WriteConfigurationSpaceResult> rsp);

  AsyncRequest writeConfigurationSpace(String romcode, com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, java.util.List<Byte> cfg, AsyncRpcResponse<WriteConfigurationSpaceResult> rsp, RpcCtrl rpcCtrl);


  public class WriteConfigurationSpacePosResult {
    public int _ret_;
  }

  WriteConfigurationSpacePosResult writeConfigurationSpacePos(java.util.List<com.raritan.idl.peripheral.PosElement> position, com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, java.util.List<Byte> cfg) throws Exception;

  AsyncRequest writeConfigurationSpacePos(java.util.List<com.raritan.idl.peripheral.PosElement> position, com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, java.util.List<Byte> cfg, AsyncRpcResponse<WriteConfigurationSpacePosResult> rsp);

  AsyncRequest writeConfigurationSpacePos(java.util.List<com.raritan.idl.peripheral.PosElement> position, com.raritan.idl.peripheral.G2Production.ConfigurationSpace cs, java.util.List<Byte> cfg, AsyncRpcResponse<WriteConfigurationSpacePosResult> rsp, RpcCtrl rpcCtrl);


  public enum ResetMethod {
    BROWNOUT,
    WATCHDOG;
  }

  public class ResetResult {
    public int _ret_;
  }

  ResetResult reset(String romcode, com.raritan.idl.peripheral.G2Production.ResetMethod method) throws Exception;

  AsyncRequest reset(String romcode, com.raritan.idl.peripheral.G2Production.ResetMethod method, AsyncRpcResponse<ResetResult> rsp);

  AsyncRequest reset(String romcode, com.raritan.idl.peripheral.G2Production.ResetMethod method, AsyncRpcResponse<ResetResult> rsp, RpcCtrl rpcCtrl);


  public class ResetPosResult {
    public int _ret_;
  }

  ResetPosResult resetPos(java.util.List<com.raritan.idl.peripheral.PosElement> position, com.raritan.idl.peripheral.G2Production.ResetMethod method) throws Exception;

  AsyncRequest resetPos(java.util.List<com.raritan.idl.peripheral.PosElement> position, com.raritan.idl.peripheral.G2Production.ResetMethod method, AsyncRpcResponse<ResetPosResult> rsp);

  AsyncRequest resetPos(java.util.List<com.raritan.idl.peripheral.PosElement> position, com.raritan.idl.peripheral.G2Production.ResetMethod method, AsyncRpcResponse<ResetPosResult> rsp, RpcCtrl rpcCtrl);

}
