// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from NameService.idl.

package com.raritan.json_rpc.jsonrpc;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class NameService_Proxy extends ObjectProxy implements com.raritan.idl.jsonrpc.NameService {

  public NameService_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public NameService_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.jsonrpc.NameService.typeInfo);
  }

  public static NameService_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new NameService_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public LookupResult lookup(final String name) throws Exception {
    JSONObject params = new JSONObject();
    params.put("name", name);
    final JSONObject result = rpcCall("lookup", params);
    LookupResult ret = new LookupResult();
    ret._ret_ = ObjectProxy.decode((result.isNull("_ret_") ? null : result.getJSONObject("_ret_")), agent);
    return ret;
  }

  @Override
  public AsyncRequest lookup(final String name, final AsyncRpcResponse<LookupResult> rsp) {
    return lookup(name, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest lookup(final String name, final AsyncRpcResponse<LookupResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("name", name);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("lookup", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          LookupResult ret = new LookupResult();
          ret._ret_ = ObjectProxy.decode((result.isNull("_ret_") ? null : result.getJSONObject("_ret_")), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
