// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from testrpc.idl.

package com.raritan.json_rpc.test;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class Ethernet_Proxy extends ObjectProxy implements com.raritan.idl.test.Ethernet {

  public Ethernet_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public Ethernet_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.test.Ethernet.typeInfo);
  }

  public static Ethernet_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new Ethernet_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public GetDevicesResult getDevices() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("getDevices", params);
    GetDevicesResult ret = new GetDevicesResult();
    ret._ret_ = new java.util.ArrayList<String>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(array0.getString(i0_f));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest getDevices(final AsyncRpcResponse<GetDevicesResult> rsp) {
    return getDevices(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getDevices(final AsyncRpcResponse<GetDevicesResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("getDevices", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetDevicesResult ret = new GetDevicesResult();
          ret._ret_ = new java.util.ArrayList<String>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(array0.getString(i0_f));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public SetParametersResult setParameters(final String device, final com.raritan.idl.test.Ethernet.Speed speed, final com.raritan.idl.test.Ethernet.Duplex duplex, final boolean isAutoNeg) throws Exception {
    JSONObject params = new JSONObject();
    params.put("device", device);
    params.put("speed", com.raritan.json_rpc.test.Ethernet.Speed_Codec.encode(speed));
    params.put("duplex", com.raritan.json_rpc.test.Ethernet.Duplex_Codec.encode(duplex));
    params.put("isAutoNeg", isAutoNeg);
    final JSONObject result = rpcCall("setParameters", params);
    SetParametersResult ret = new SetParametersResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest setParameters(final String device, final com.raritan.idl.test.Ethernet.Speed speed, final com.raritan.idl.test.Ethernet.Duplex duplex, final boolean isAutoNeg, final AsyncRpcResponse<SetParametersResult> rsp) {
    return setParameters(device, speed, duplex, isAutoNeg, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest setParameters(final String device, final com.raritan.idl.test.Ethernet.Speed speed, final com.raritan.idl.test.Ethernet.Duplex duplex, final boolean isAutoNeg, final AsyncRpcResponse<SetParametersResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("device", device);
      params.put("speed", com.raritan.json_rpc.test.Ethernet.Speed_Codec.encode(speed));
      params.put("duplex", com.raritan.json_rpc.test.Ethernet.Duplex_Codec.encode(duplex));
      params.put("isAutoNeg", isAutoNeg);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("setParameters", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          SetParametersResult ret = new SetParametersResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
