// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from OutletGroupManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.pdumodel {
  public class OutletGroupManager_1_1_6 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.OutletGroupManager:1.1.6", null);

    public OutletGroupManager_1_1_6(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public OutletGroupManager_1_1_6(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new OutletGroupManager_1_1_6 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new OutletGroupManager_1_1_6(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_INVALID_ARGUMENT = 1;

    public const int ERR_NO_SUCH_ID = 2;

    public const int ERR_MAX_GROUP_COUNT_REACHED = 3;

    public class GroupCreatedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.OutletGroupManager_1_1_6.GroupCreatedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public int id = 0;
      public int uniqueId = 0;
      public Com.Raritan.Idl.pdumodel.OutletGroup_1_1_6 group = null;
      public Com.Raritan.Idl.pdumodel.OutletGroup_1_1_6.Settings settings = new Com.Raritan.Idl.pdumodel.OutletGroup_1_1_6.Settings();
    }

    public class GroupDeletedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.OutletGroupManager_1_1_6.GroupDeletedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public int id = 0;
      public int uniqueId = 0;
      public Com.Raritan.Idl.pdumodel.OutletGroup_1_1_6.Settings settings = new Com.Raritan.Idl.pdumodel.OutletGroup_1_1_6.Settings();
    }

    public class CreateGroupResult {
      public int _ret_;
      public Com.Raritan.Idl.pdumodel.OutletGroup_1_1_6 group;
    }

    public CreateGroupResult createGroup(string name, System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.Outlet_3_0_0> members) {
      var _parameters = new LightJson.JsonObject();
      _parameters["name"] = name;
      _parameters["members"] = new JsonArray(members.Select(
        _value => (JsonValue)(_value != null ? _value.Encode() : JsonValue.Null)));

      var _result = RpcCall("createGroup", _parameters);
      var _ret = new CreateGroupResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.group = Com.Raritan.Idl.pdumodel.OutletGroup_1_1_6.StaticCast(ObjectProxy.Decode(_result["group"], agent));
      return _ret;
    }

    public AsyncRequest createGroup(string name, System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.Outlet_3_0_0> members, AsyncRpcResponse<CreateGroupResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return createGroup(name, members, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest createGroup(string name, System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.Outlet_3_0_0> members, AsyncRpcResponse<CreateGroupResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["name"] = name;
        _parameters["members"] = new JsonArray(members.Select(
          _value => (JsonValue)(_value != null ? _value.Encode() : JsonValue.Null)));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("createGroup", _parameters,
        _result => {
          try {
            var _ret = new CreateGroupResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.group = Com.Raritan.Idl.pdumodel.OutletGroup_1_1_6.StaticCast(ObjectProxy.Decode(_result["group"], agent));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetAllGroupsResult {
      public System.Collections.Generic.IDictionary<int, Com.Raritan.Idl.pdumodel.OutletGroup_1_1_6> _ret_;
    }

    public GetAllGroupsResult getAllGroups() {
      JsonObject _parameters = null;
      var _result = RpcCall("getAllGroups", _parameters);
      var _ret = new GetAllGroupsResult();
      _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
        _value => new System.Collections.Generic.KeyValuePair<int, Com.Raritan.Idl.pdumodel.OutletGroup_1_1_6>(_value["key"], Com.Raritan.Idl.pdumodel.OutletGroup_1_1_6.StaticCast(ObjectProxy.Decode(_value["value"], agent)))));
      return _ret;
    }

    public AsyncRequest getAllGroups(AsyncRpcResponse<GetAllGroupsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getAllGroups(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getAllGroups(AsyncRpcResponse<GetAllGroupsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getAllGroups", _parameters,
        _result => {
          try {
            var _ret = new GetAllGroupsResult();
            _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
              _value => new System.Collections.Generic.KeyValuePair<int, Com.Raritan.Idl.pdumodel.OutletGroup_1_1_6>(_value["key"], Com.Raritan.Idl.pdumodel.OutletGroup_1_1_6.StaticCast(ObjectProxy.Decode(_value["value"], agent)))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetGroupResult {
      public int _ret_;
      public Com.Raritan.Idl.pdumodel.OutletGroup_1_1_6 group;
    }

    public GetGroupResult getGroup(int id) {
      var _parameters = new LightJson.JsonObject();
      _parameters["id"] = id;

      var _result = RpcCall("getGroup", _parameters);
      var _ret = new GetGroupResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.group = Com.Raritan.Idl.pdumodel.OutletGroup_1_1_6.StaticCast(ObjectProxy.Decode(_result["group"], agent));
      return _ret;
    }

    public AsyncRequest getGroup(int id, AsyncRpcResponse<GetGroupResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getGroup(id, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getGroup(int id, AsyncRpcResponse<GetGroupResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["id"] = id;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getGroup", _parameters,
        _result => {
          try {
            var _ret = new GetGroupResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.group = Com.Raritan.Idl.pdumodel.OutletGroup_1_1_6.StaticCast(ObjectProxy.Decode(_result["group"], agent));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class DeleteGroupResult {
      public int _ret_;
    }

    public DeleteGroupResult deleteGroup(int id) {
      var _parameters = new LightJson.JsonObject();
      _parameters["id"] = id;

      var _result = RpcCall("deleteGroup", _parameters);
      var _ret = new DeleteGroupResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest deleteGroup(int id, AsyncRpcResponse<DeleteGroupResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return deleteGroup(id, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest deleteGroup(int id, AsyncRpcResponse<DeleteGroupResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["id"] = id;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("deleteGroup", _parameters,
        _result => {
          try {
            var _ret = new DeleteGroupResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
