// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from GatewaySensorManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.peripheral {
  public class GatewaySensorManager_2_0_1 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager:2.0.1", null);

    public GatewaySensorManager_2_0_1(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public GatewaySensorManager_2_0_1(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new GatewaySensorManager_2_0_1 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new GatewaySensorManager_2_0_1(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class SensorClass : ValueObject {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.SensorClass:1.0.0", ValueObject.typeInfo);

      public string classId = "";
    }

    public class NumericSensorClass : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.SensorClass {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.NumericSensorClass:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.SensorClass.typeInfo);

      public Com.Raritan.Idl.sensors.NumericSensor_4_0_8.MetaData metadata = new Com.Raritan.Idl.sensors.NumericSensor_4_0_8.MetaData();
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_8.Thresholds defaultThresholds = new Com.Raritan.Idl.sensors.NumericSensor_4_0_8.Thresholds();
      public bool preferCommonThresholds = false;
    }

    public class StateSensorClass : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.SensorClass {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.StateSensorClass:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.SensorClass.typeInfo);

      public Com.Raritan.Idl.sensors.Sensor_4_0_7.TypeSpec type = new Com.Raritan.Idl.sensors.Sensor_4_0_7.TypeSpec();
    }

    public class SwitchSensorClass : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.StateSensorClass {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.SwitchSensorClass:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.StateSensorClass.typeInfo);

    }

    public class RemoteDevice : ValueObject {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.RemoteDevice:1.0.0", ValueObject.typeInfo);

      public string deviceId = "";
      public bool disabled = false;
      public string name = "";
      public int timeoutMs = 0;
      public int retry = 0;
    }

    public const int MODBUS_VENDOR_NAME = 0;

    public const int MODBUS_PRODUCT_CODE = 1;

    public const int MODBUS_REVISION = 2;

    public const int MODBUS_VENDOR_URL = 3;

    public const int MODBUS_PRODUCT_NAME = 5;

    public const int MODBUS_MODEL_NAME = 6;

    public const int MODBUS_APP_NAME = 7;

    public class RemoteModbusDevice : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.RemoteDevice {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.RemoteModbusDevice:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.RemoteDevice.typeInfo);

      public System.Collections.Generic.IDictionary<int, string> detectionIdentifiers = new System.Collections.Generic.Dictionary<int, string>();
      public int unitId = 0;
    }

    public class RemoteModbusRTUDevice : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.RemoteModbusDevice {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.RemoteModbusRTUDevice:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.RemoteModbusDevice.typeInfo);

      public string busInterface = "";
      public Com.Raritan.Idl.peripheral.ModbusCfg.SerialSettings busSettings = new Com.Raritan.Idl.peripheral.ModbusCfg.SerialSettings();
      public int interframeDelayDeciChars = 0;
    }

    public class RemoteModbusTCPDevice : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.RemoteModbusDevice {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.RemoteModbusTCPDevice:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.RemoteModbusDevice.typeInfo);

      public string ipAddress = "";
      public int tcpPort = 0;
    }

    public class RemoteSnmpDevice : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.RemoteDevice {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.RemoteSnmpDevice:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.RemoteDevice.typeInfo);

      public string host = "";
    }

    public class RemoteSnmpV1V2Device : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.RemoteSnmpDevice {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.RemoteSnmpV1V2Device:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.RemoteSnmpDevice.typeInfo);

      public string community = "";
    }

    public enum SnmpSecurityLevel {
      NO_AUTH_NO_PRIV,
      AUTH_NO_PRIV,
      AUTH_PRIV,
    }

    public enum SnmpAuthProtocol {
      MD5,
      SHA1,
      SHA224,
      SHA256,
      SHA384,
      SHA512,
    }

    public enum SnmpPrivProtocol {
      DES,
      AES128,
      AES192,
      AES256,
      AES192_3DES,
      AES256_3DES,
    }

    public class RemoteSnmpV3Device : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.RemoteSnmpDevice {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.RemoteSnmpV3Device:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.RemoteSnmpDevice.typeInfo);

      public string user = "";
      public Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.SnmpSecurityLevel level = Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.SnmpSecurityLevel.NO_AUTH_NO_PRIV;
      public Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.SnmpAuthProtocol authProtocol = Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.SnmpAuthProtocol.MD5;
      public string authPassphrase = "";
      public Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.SnmpPrivProtocol privacyProtocol = Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.SnmpPrivProtocol.DES;
      public string privacyPassphrase = "";
    }

    public enum EncodingType {
      BOOL,
      INT,
      UINT,
      IEEE754,
      INT_ONES_COMPLEMENT,
      INT_SIGN_MAGNITUDE,
      INT_10K,
      UINT_10K,
      INT_BCD,
      INT_SIGN_MAGNITUDE_BCD,
      UINT_BCD,
      INT_PACKED_BCD,
      INT_SIGN_MAGNITUDE_PACKED_BCD,
      UINT_PACKED_BCD,
    }

    public enum Interpretation {
      DEFAULT,
      REJECT_DEVICE,
      REJECT_SENSOR,
      IGNORE,
      UNAVAILABLE,
      NUMERIC_INVALID,
      STATE_ON,
      STATE_OFF,
    }

    public class InterpretationRule : ValueObject {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.InterpretationRule:1.0.0", ValueObject.typeInfo);

      public Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Interpretation interpretation = Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Interpretation.DEFAULT;
      public int ignoreTimeout = 0;
    }

    public class InterpretationRuleInvertable : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRule {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.InterpretationRuleInvertable:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRule.typeInfo);

      public bool invertCondition = false;
    }

    public class InterpretationRuleModbusException : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRuleInvertable {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.InterpretationRuleModbusException:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRuleInvertable.typeInfo);

      public System.Collections.Generic.IEnumerable<int> exceptions = new System.Collections.Generic.List<int>();
    }

    public class InterpretationRuleModbusSystemError : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRuleInvertable {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.InterpretationRuleModbusSystemError:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRuleInvertable.typeInfo);

      public System.Collections.Generic.IEnumerable<int> errnos = new System.Collections.Generic.List<int>();
    }

    public class InterpretationRuleModbusSpecificError : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRuleInvertable {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.InterpretationRuleModbusSpecificError:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRuleInvertable.typeInfo);

      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.ModbusCfg.SpecificModbusErrors> errors = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.ModbusCfg.SpecificModbusErrors>();
    }

    public class InterpretationRuleRAW : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRuleInvertable {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.InterpretationRuleRAW:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRuleInvertable.typeInfo);

      public long value = 0;
      public long mask = 0;
    }

    public class InterpretationRuleRangeRAW : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRuleInvertable {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.InterpretationRuleRangeRAW:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRuleInvertable.typeInfo);

      public long min = 0;
      public long max = 0;
      public long mask = 0;
    }

    public class InterpretationRuleEnum : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRuleInvertable {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.InterpretationRuleEnum:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRuleInvertable.typeInfo);

      public System.Collections.Generic.IEnumerable<long> enumValues = new System.Collections.Generic.List<long>();
    }

    public class InterpretationRuleIEEE754INF : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRuleInvertable {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.InterpretationRuleIEEE754INF:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRuleInvertable.typeInfo);

    }

    public class InterpretationRuleIEEE754NAN : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRuleInvertable {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.InterpretationRuleIEEE754NAN:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRuleInvertable.typeInfo);

    }

    public class InterpretationRuleCatchAll : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRule {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.InterpretationRuleCatchAll:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRule.typeInfo);

    }

    public class ValueEncoding : ValueObject {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.ValueEncoding:1.0.0", ValueObject.typeInfo);

      public string encodingId = "";
      public Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.EncodingType type = Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.EncodingType.BOOL;
      public bool invertState = false;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRule> interpretationRules = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.InterpretationRule>();
      public int minAccessInterval = 0;
    }

    public class NumericValueEncoding : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ValueEncoding {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.NumericValueEncoding:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ValueEncoding.typeInfo);

      public float scalingFactor = 0.0f;
      public float offset = 0.0f;
    }

    public class ModbusValueEncodingBit : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ValueEncoding {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.ModbusValueEncodingBit:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ValueEncoding.typeInfo);

    }

    public class ModbusValueEncoding8 : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.NumericValueEncoding {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.ModbusValueEncoding8:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.NumericValueEncoding.typeInfo);

      public bool byteSwap = false;
      public long mask = 0;
      public int start = 0;
      public int width = 0;
    }

    public class ModbusValueEncoding16 : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ModbusValueEncoding8 {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.ModbusValueEncoding16:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ModbusValueEncoding8.typeInfo);

    }

    public enum ModbusEndianness {
      MODBUS_BIG_ENDIAN,
      MODBUS_LITTLE_ENDIAN,
    }

    public class ModbusValueEncoding32 : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ModbusValueEncoding16 {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.ModbusValueEncoding32:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ModbusValueEncoding16.typeInfo);

      public Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ModbusEndianness endianness = Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ModbusEndianness.MODBUS_BIG_ENDIAN;
    }

    public class ModbusValueEncoding48 : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ModbusValueEncoding32 {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.ModbusValueEncoding48:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ModbusValueEncoding32.typeInfo);

    }

    public class ModbusValueEncoding64 : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ModbusValueEncoding32 {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.ModbusValueEncoding64:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ModbusValueEncoding32.typeInfo);

    }

    public class Sensor : ValueObject {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.Sensor:1.0.0", ValueObject.typeInfo);

      public string sensorId = "";
      public bool disabled = false;
      public string deviceId = "";
      public string classId = "";
      public string encodingId = "";
      public string defaultName = "";
    }

    public class ModbusSensor : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Sensor {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.ModbusSensor:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Sensor.typeInfo);

      public Com.Raritan.Idl.peripheral.ModbusCfg.ModbusFunction function = Com.Raritan.Idl.peripheral.ModbusCfg.ModbusFunction.COIL;
      public int regAddr = 0;
    }

    public class SnmpSensor : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Sensor {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.SnmpSensor:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Sensor.typeInfo);

      public string oid = "";
    }

    public class ConfigurationPackage : ICloneable {
      public object Clone() {
        ConfigurationPackage copy = new ConfigurationPackage();
        copy.disabled = this.disabled;
        copy.name = this.name;
        copy.classes = this.classes;
        copy.devices = this.devices;
        copy.encodings = this.encodings;
        copy.sensors = this.sensors;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["disabled"] = this.disabled;
        json["name"] = this.name;
        json["classes"] = new JsonArray(this.classes.Select(
          _value => (JsonValue)(ValueObjectCodec.Encode(_value))));
        json["devices"] = new JsonArray(this.devices.Select(
          _value => (JsonValue)(ValueObjectCodec.Encode(_value))));
        json["encodings"] = new JsonArray(this.encodings.Select(
          _value => (JsonValue)(ValueObjectCodec.Encode(_value))));
        json["sensors"] = new JsonArray(this.sensors.Select(
          _value => (JsonValue)(ValueObjectCodec.Encode(_value))));
        return json;
      }

      public static ConfigurationPackage Decode(LightJson.JsonObject json, Agent agent) {
        ConfigurationPackage inst = new ConfigurationPackage();
        inst.disabled = (bool)json["disabled"];
        inst.name = (string)json["name"];
        inst.classes = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.SensorClass>(json["classes"].AsJsonArray.Select(
          _value => ((Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.SensorClass)ValueObjectCodec.DecodeAs(_value, agent, Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.SensorClass.typeInfo))));
        inst.devices = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.RemoteDevice>(json["devices"].AsJsonArray.Select(
          _value => ((Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.RemoteDevice)ValueObjectCodec.DecodeAs(_value, agent, Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.RemoteDevice.typeInfo))));
        inst.encodings = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ValueEncoding>(json["encodings"].AsJsonArray.Select(
          _value => ((Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ValueEncoding)ValueObjectCodec.DecodeAs(_value, agent, Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ValueEncoding.typeInfo))));
        inst.sensors = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Sensor>(json["sensors"].AsJsonArray.Select(
          _value => ((Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Sensor)ValueObjectCodec.DecodeAs(_value, agent, Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Sensor.typeInfo))));
        return inst;
      }

      public bool disabled = false;
      public string name = "";
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.SensorClass> classes = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.SensorClass>();
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.RemoteDevice> devices = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.RemoteDevice>();
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ValueEncoding> encodings = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ValueEncoding>();
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Sensor> sensors = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Sensor>();
    }

    public class GetConfigurationResult {
      public System.Collections.Generic.IDictionary<string, Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ConfigurationPackage> _ret_;
    }

    public GetConfigurationResult getConfiguration() {
      JsonObject _parameters = null;
      var _result = RpcCall("getConfiguration", _parameters);
      var _ret = new GetConfigurationResult();
      _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
        _value => new System.Collections.Generic.KeyValuePair<string, Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ConfigurationPackage>(_value["key"], Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ConfigurationPackage.Decode(_value["value"], agent))));
      return _ret;
    }

    public AsyncRequest getConfiguration(AsyncRpcResponse<GetConfigurationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getConfiguration(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getConfiguration(AsyncRpcResponse<GetConfigurationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getConfiguration", _parameters,
        _result => {
          try {
            var _ret = new GetConfigurationResult();
            _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
              _value => new System.Collections.Generic.KeyValuePair<string, Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ConfigurationPackage>(_value["key"], Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ConfigurationPackage.Decode(_value["value"], agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public const int ERR_CONFIG_INCONSISTENT = 1;

    public const int ERR_CONFIG_STORAGE_FAILED = 2;

    public class SetConfigurationResult {
      public int _ret_;
    }

    public SetConfigurationResult setConfiguration(System.Collections.Generic.IDictionary<string, Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ConfigurationPackage> cfg) {
      var _parameters = new LightJson.JsonObject();
      _parameters["cfg"] = new JsonArray(cfg.Select(_entry => (JsonValue) new JsonObject(new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, LightJson.JsonValue>> {
        new System.Collections.Generic.KeyValuePair<string, JsonValue>("key", _entry.Key),
        new System.Collections.Generic.KeyValuePair<string, JsonValue>("value", _entry.Value.Encode())
      })));

      var _result = RpcCall("setConfiguration", _parameters);
      var _ret = new SetConfigurationResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setConfiguration(System.Collections.Generic.IDictionary<string, Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ConfigurationPackage> cfg, AsyncRpcResponse<SetConfigurationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setConfiguration(cfg, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setConfiguration(System.Collections.Generic.IDictionary<string, Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ConfigurationPackage> cfg, AsyncRpcResponse<SetConfigurationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["cfg"] = new JsonArray(cfg.Select(_entry => (JsonValue) new JsonObject(new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, LightJson.JsonValue>> {
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("key", _entry.Key),
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("value", _entry.Value.Encode())
        })));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setConfiguration", _parameters,
        _result => {
          try {
            var _ret = new SetConfigurationResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ConfigurationChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.ConfigurationChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public System.Collections.Generic.IDictionary<string, Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ConfigurationPackage> configuration = new System.Collections.Generic.Dictionary<string, Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.ConfigurationPackage>();
    }

    public class FeedbackObject : ICloneable {
      public object Clone() {
        FeedbackObject copy = new FeedbackObject();
        copy.key = this.key;
        copy.value = this.value;
        copy.stateTansitionTo = this.stateTansitionTo;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["key"] = this.key;
        json["value"] = this.value;
        json["stateTansitionTo"] = (int)this.stateTansitionTo;
        return json;
      }

      public static FeedbackObject Decode(LightJson.JsonObject json, Agent agent) {
        FeedbackObject inst = new FeedbackObject();
        inst.key = (string)json["key"];
        inst.value = (string)json["value"];
        inst.stateTansitionTo = (Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.FeedbackObject.FeedbackState)(int)json["stateTansitionTo"];
        return inst;
      }


      public enum FeedbackState {
        UNSPECIFIED,
        INTENTIONALLY_UNUSED,
        FAILED_PRECONDITIONS_UNUSED,
        FAILED,
        GOOD,
      }
      public string key = "";
      public string value = "";
      public Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.FeedbackObject.FeedbackState stateTansitionTo = Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.FeedbackObject.FeedbackState.UNSPECIFIED;
    }

    public class Feedback : ValueObject {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.Feedback:1.0.0", ValueObject.typeInfo);

      public Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.FeedbackObject.FeedbackState currentState = Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.FeedbackObject.FeedbackState.UNSPECIFIED;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.FeedbackObject> infos = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.FeedbackObject>();
    }

    public class DeviceFeedback : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Feedback {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.DeviceFeedback:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Feedback.typeInfo);

      public string packageId = "";
      public string deviceId = "";
    }

    public class SensorFeedback : Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Feedback {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.SensorFeedback:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Feedback.typeInfo);

      public string packageId = "";
      public string deviceId = "";
      public string sensorId = "";
    }

    public class GetFeedbackResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Feedback> _ret_;
    }

    public GetFeedbackResult getFeedback() {
      JsonObject _parameters = null;
      var _result = RpcCall("getFeedback", _parameters);
      var _ret = new GetFeedbackResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Feedback>(_result["_ret_"].AsJsonArray.Select(
        _value => ((Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Feedback)ValueObjectCodec.DecodeAs(_value, agent, Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Feedback.typeInfo))));
      return _ret;
    }

    public AsyncRequest getFeedback(AsyncRpcResponse<GetFeedbackResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getFeedback(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getFeedback(AsyncRpcResponse<GetFeedbackResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getFeedback", _parameters,
        _result => {
          try {
            var _ret = new GetFeedbackResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Feedback>(_result["_ret_"].AsJsonArray.Select(
              _value => ((Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Feedback)ValueObjectCodec.DecodeAs(_value, agent, Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Feedback.typeInfo))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class FeedbackChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager_2_0_1.FeedbackChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Feedback> feedback = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager_2_0_1.Feedback>();
    }

  }
}
