// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Security.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.security {

  public class IpFw : ICloneable {
    public object Clone() {
      IpFw copy = new IpFw();
      copy.enabled = this.enabled;
      copy.defaultPolicy = this.defaultPolicy;
      copy.ruleSet = this.ruleSet;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["enabled"] = this.enabled;
      json["defaultPolicy"] = (int)this.defaultPolicy;
      json["ruleSet"] = new JsonArray(this.ruleSet.Select(
        _value => (JsonValue)(_value.Encode())));
      return json;
    }

    public static IpFw Decode(LightJson.JsonObject json, Agent agent) {
      IpFw inst = new IpFw();
      inst.enabled = (bool)json["enabled"];
      inst.defaultPolicy = (Com.Raritan.Idl.security.IpfwPolicy)(int)json["defaultPolicy"];
      inst.ruleSet = new System.Collections.Generic.List<Com.Raritan.Idl.security.IpfwRuleset>(json["ruleSet"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.security.IpfwRuleset.Decode(_value, agent)));
      return inst;
    }

    public bool enabled = false;
    public Com.Raritan.Idl.security.IpfwPolicy defaultPolicy = Com.Raritan.Idl.security.IpfwPolicy.ACCEPT;
    public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.security.IpfwRuleset> ruleSet = new System.Collections.Generic.List<Com.Raritan.Idl.security.IpfwRuleset>();
  }
}
