# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from DisplayControl.idl.

use strict;

package Raritan::RPC::display::DisplayControl_2_0_0;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "display.DisplayControl:2.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::display::DisplayControl_2_0_0::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant SUCCESS => 0;

use constant ERR_INVALID_VALUE => 1;

use Raritan::RPC::display::DisplayControl_2_0_0::DefaultViewItem;

sub getAvailableDefaultViews($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getAvailableDefaultViews', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::display::DisplayControl_2_0_0::DefaultViewItem::decode($agent, $rsp->{'_ret_'}->[$i0]);
    }
    return $_ret_;
}

use Raritan::RPC::display::DisplayControl_2_0_0::Settings;

sub getSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSettings', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::display::DisplayControl_2_0_0::Settings::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::display::DisplayControl_2_0_0::Settings;

sub setSettings($$) {
    my ($self, $settings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'settings'} = Raritan::RPC::display::DisplayControl_2_0_0::Settings::encode($settings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::display::DisplayControl_2_0_0::Info;

sub getInfo($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getInfo', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::display::DisplayControl_2_0_0::Info::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

sub showSmiley($$$$) {
    my ($self, $on, $happy, $msg) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'on'} = ($on) ? JSON::true : JSON::false;
    $args->{'happy'} = ($happy) ? JSON::true : JSON::false;
    $args->{'msg'} = "$msg";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'showSmiley', $args);
}

Raritan::RPC::Registry::registerProxyClass('display.DisplayControl', 2, 0, 0, 'Raritan::RPC::display::DisplayControl_2_0_0');
1;
