# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "Security.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.security


# enumeration
class IpfwPolicy(Enumeration):
    idlType = "security.IpfwPolicy:1.0.0"
    values = ["ACCEPT", "DROP", "REJECT"]

IpfwPolicy.ACCEPT = IpfwPolicy(0)
IpfwPolicy.DROP = IpfwPolicy(1)
IpfwPolicy.REJECT = IpfwPolicy(2)

# structure
class IpfwRule(Structure):
    idlType = "security.IpfwRule:1.0.0"
    elements = ["ipMask", "policy"]

    def __init__(self, ipMask="", policy=None):
        if policy is None:
            policy = raritan.rpc.security.IpfwPolicy.ACCEPT
        if not typecheck._is_int(ipMask):
            typecheck.is_string(ipMask, AssertionError)
        typecheck.is_enum(policy, raritan.rpc.security.IpfwPolicy, AssertionError)

        self.ipMask = ipMask
        self.policy = policy

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            ipMask = json['ipMask'] if 'ipMask' in json or not useDefaults else "",
            policy = raritan.rpc.security.IpfwPolicy.decode(json['policy']) if 'policy' in json or not useDefaults else raritan.rpc.security.IpfwPolicy.ACCEPT,
        )
        return obj

    def encode(self):
        json = {}
        json['ipMask'] = str(self.ipMask)
        json['policy'] = raritan.rpc.security.IpfwPolicy.encode(self.policy)
        return json

# structure
class IpFw(Structure):
    idlType = "security.IpFw:2.0.0"
    elements = ["enabled", "defaultPolicyIn", "defaultPolicyOut", "ruleSetIn", "ruleSetOut"]

    def __init__(self, enabled=False, defaultPolicyIn=None, defaultPolicyOut=None, ruleSetIn=[], ruleSetOut=[]):
        if defaultPolicyIn is None:
            defaultPolicyIn = raritan.rpc.security.IpfwPolicy.ACCEPT
        if defaultPolicyOut is None:
            defaultPolicyOut = raritan.rpc.security.IpfwPolicy.ACCEPT
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_enum(defaultPolicyIn, raritan.rpc.security.IpfwPolicy, AssertionError)
        typecheck.is_enum(defaultPolicyOut, raritan.rpc.security.IpfwPolicy, AssertionError)
        for x0 in ruleSetIn:
            typecheck.is_struct(x0, raritan.rpc.security.IpfwRule, AssertionError)
        for x0 in ruleSetOut:
            typecheck.is_struct(x0, raritan.rpc.security.IpfwRule, AssertionError)

        self.enabled = enabled
        self.defaultPolicyIn = defaultPolicyIn
        self.defaultPolicyOut = defaultPolicyOut
        self.ruleSetIn = ruleSetIn
        self.ruleSetOut = ruleSetOut

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
            defaultPolicyIn = raritan.rpc.security.IpfwPolicy.decode(json['defaultPolicyIn']) if 'defaultPolicyIn' in json or not useDefaults else raritan.rpc.security.IpfwPolicy.ACCEPT,
            defaultPolicyOut = raritan.rpc.security.IpfwPolicy.decode(json['defaultPolicyOut']) if 'defaultPolicyOut' in json or not useDefaults else raritan.rpc.security.IpfwPolicy.ACCEPT,
            ruleSetIn = [raritan.rpc.security.IpfwRule.decode(x0, agent, useDefaults=useDefaults) for x0 in json['ruleSetIn']] if 'ruleSetIn' in json or not useDefaults else [],
            ruleSetOut = [raritan.rpc.security.IpfwRule.decode(x0, agent, useDefaults=useDefaults) for x0 in json['ruleSetOut']] if 'ruleSetOut' in json or not useDefaults else [],
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['defaultPolicyIn'] = raritan.rpc.security.IpfwPolicy.encode(self.defaultPolicyIn)
        json['defaultPolicyOut'] = raritan.rpc.security.IpfwPolicy.encode(self.defaultPolicyOut)
        json['ruleSetIn'] = [raritan.rpc.security.IpfwRule.encode(x0) for x0 in self.ruleSetIn]
        json['ruleSetOut'] = [raritan.rpc.security.IpfwRule.encode(x0) for x0 in self.ruleSetOut]
        return json

# enumeration
class RoleAccessPolicy(Enumeration):
    idlType = "security.RoleAccessPolicy:1.0.0"
    values = ["ALLOW", "DENY"]

RoleAccessPolicy.ALLOW = RoleAccessPolicy(0)
RoleAccessPolicy.DENY = RoleAccessPolicy(1)

# structure
class RoleAccessRule(Structure):
    idlType = "security.RoleAccessRule:1.0.0"
    elements = ["startIp", "endIp", "roleId", "policy"]

    def __init__(self, startIp="", endIp="", roleId=0, policy=None):
        if policy is None:
            policy = raritan.rpc.security.RoleAccessPolicy.ALLOW
        if not typecheck._is_int(startIp):
            typecheck.is_string(startIp, AssertionError)
        if not typecheck._is_int(endIp):
            typecheck.is_string(endIp, AssertionError)
        typecheck.is_int(roleId, AssertionError)
        typecheck.is_enum(policy, raritan.rpc.security.RoleAccessPolicy, AssertionError)

        self.startIp = startIp
        self.endIp = endIp
        self.roleId = roleId
        self.policy = policy

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            startIp = json['startIp'] if 'startIp' in json or not useDefaults else "",
            endIp = json['endIp'] if 'endIp' in json or not useDefaults else "",
            roleId = json['roleId'] if 'roleId' in json or not useDefaults else 0,
            policy = raritan.rpc.security.RoleAccessPolicy.decode(json['policy']) if 'policy' in json or not useDefaults else raritan.rpc.security.RoleAccessPolicy.ALLOW,
        )
        return obj

    def encode(self):
        json = {}
        json['startIp'] = str(self.startIp)
        json['endIp'] = str(self.endIp)
        json['roleId'] = self.roleId
        json['policy'] = raritan.rpc.security.RoleAccessPolicy.encode(self.policy)
        return json

# structure
class RoleAccessControl(Structure):
    idlType = "security.RoleAccessControl:1.0.0"
    elements = ["enabled", "defaultPolicy", "rules"]

    def __init__(self, enabled=False, defaultPolicy=None, rules=[]):
        if defaultPolicy is None:
            defaultPolicy = raritan.rpc.security.RoleAccessPolicy.ALLOW
        typecheck.is_bool(enabled, AssertionError)
        typecheck.is_enum(defaultPolicy, raritan.rpc.security.RoleAccessPolicy, AssertionError)
        for x0 in rules:
            typecheck.is_struct(x0, raritan.rpc.security.RoleAccessRule, AssertionError)

        self.enabled = enabled
        self.defaultPolicy = defaultPolicy
        self.rules = rules

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
            defaultPolicy = raritan.rpc.security.RoleAccessPolicy.decode(json['defaultPolicy']) if 'defaultPolicy' in json or not useDefaults else raritan.rpc.security.RoleAccessPolicy.ALLOW,
            rules = [raritan.rpc.security.RoleAccessRule.decode(x0, agent, useDefaults=useDefaults) for x0 in json['rules']] if 'rules' in json or not useDefaults else [],
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['defaultPolicy'] = raritan.rpc.security.RoleAccessPolicy.encode(self.defaultPolicy)
        json['rules'] = [raritan.rpc.security.RoleAccessRule.encode(x0) for x0 in self.rules]
        return json

# structure
class BlockSettings(Structure):
    idlType = "security.BlockSettings:1.0.0"
    elements = ["maxFailedLogins", "blockTimeout", "failedLoginTimeout"]

    def __init__(self, maxFailedLogins=0, blockTimeout=0, failedLoginTimeout=0):
        typecheck.is_int(maxFailedLogins, AssertionError)
        typecheck.is_int(blockTimeout, AssertionError)
        typecheck.is_int(failedLoginTimeout, AssertionError)

        self.maxFailedLogins = maxFailedLogins
        self.blockTimeout = blockTimeout
        self.failedLoginTimeout = failedLoginTimeout

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            maxFailedLogins = json['maxFailedLogins'] if 'maxFailedLogins' in json or not useDefaults else 0,
            blockTimeout = json['blockTimeout'] if 'blockTimeout' in json or not useDefaults else 0,
            failedLoginTimeout = json['failedLoginTimeout'] if 'failedLoginTimeout' in json or not useDefaults else 0,
        )
        return obj

    def encode(self):
        json = {}
        json['maxFailedLogins'] = self.maxFailedLogins
        json['blockTimeout'] = self.blockTimeout
        json['failedLoginTimeout'] = self.failedLoginTimeout
        return json

# structure
class PasswordSettings(Structure):
    idlType = "security.PasswordSettings:1.0.0"
    elements = ["enableAging", "agingInterval", "enableStrongReq", "minPwLength", "maxPwLength", "enforceLower", "enforceUpper", "enforceNumeric", "enforceSpecial", "pwHistoryDepth"]

    def __init__(self, enableAging=False, agingInterval=0, enableStrongReq=False, minPwLength=0, maxPwLength=0, enforceLower=False, enforceUpper=False, enforceNumeric=False, enforceSpecial=False, pwHistoryDepth=0):
        typecheck.is_bool(enableAging, AssertionError)
        typecheck.is_int(agingInterval, AssertionError)
        typecheck.is_bool(enableStrongReq, AssertionError)
        typecheck.is_int(minPwLength, AssertionError)
        typecheck.is_int(maxPwLength, AssertionError)
        typecheck.is_bool(enforceLower, AssertionError)
        typecheck.is_bool(enforceUpper, AssertionError)
        typecheck.is_bool(enforceNumeric, AssertionError)
        typecheck.is_bool(enforceSpecial, AssertionError)
        typecheck.is_int(pwHistoryDepth, AssertionError)

        self.enableAging = enableAging
        self.agingInterval = agingInterval
        self.enableStrongReq = enableStrongReq
        self.minPwLength = minPwLength
        self.maxPwLength = maxPwLength
        self.enforceLower = enforceLower
        self.enforceUpper = enforceUpper
        self.enforceNumeric = enforceNumeric
        self.enforceSpecial = enforceSpecial
        self.pwHistoryDepth = pwHistoryDepth

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            enableAging = json['enableAging'] if 'enableAging' in json or not useDefaults else False,
            agingInterval = json['agingInterval'] if 'agingInterval' in json or not useDefaults else 0,
            enableStrongReq = json['enableStrongReq'] if 'enableStrongReq' in json or not useDefaults else False,
            minPwLength = json['minPwLength'] if 'minPwLength' in json or not useDefaults else 0,
            maxPwLength = json['maxPwLength'] if 'maxPwLength' in json or not useDefaults else 0,
            enforceLower = json['enforceLower'] if 'enforceLower' in json or not useDefaults else False,
            enforceUpper = json['enforceUpper'] if 'enforceUpper' in json or not useDefaults else False,
            enforceNumeric = json['enforceNumeric'] if 'enforceNumeric' in json or not useDefaults else False,
            enforceSpecial = json['enforceSpecial'] if 'enforceSpecial' in json or not useDefaults else False,
            pwHistoryDepth = json['pwHistoryDepth'] if 'pwHistoryDepth' in json or not useDefaults else 0,
        )
        return obj

    def encode(self):
        json = {}
        json['enableAging'] = self.enableAging
        json['agingInterval'] = self.agingInterval
        json['enableStrongReq'] = self.enableStrongReq
        json['minPwLength'] = self.minPwLength
        json['maxPwLength'] = self.maxPwLength
        json['enforceLower'] = self.enforceLower
        json['enforceUpper'] = self.enforceUpper
        json['enforceNumeric'] = self.enforceNumeric
        json['enforceSpecial'] = self.enforceSpecial
        json['pwHistoryDepth'] = self.pwHistoryDepth
        return json

# structure
class SSHSettings(Structure):
    idlType = "security.SSHSettings:1.0.0"
    elements = ["allowPasswordAuth", "allowPublicKeyAuth"]

    def __init__(self, allowPasswordAuth=False, allowPublicKeyAuth=False):
        typecheck.is_bool(allowPasswordAuth, AssertionError)
        typecheck.is_bool(allowPublicKeyAuth, AssertionError)

        self.allowPasswordAuth = allowPasswordAuth
        self.allowPublicKeyAuth = allowPublicKeyAuth

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            allowPasswordAuth = json['allowPasswordAuth'] if 'allowPasswordAuth' in json or not useDefaults else False,
            allowPublicKeyAuth = json['allowPublicKeyAuth'] if 'allowPublicKeyAuth' in json or not useDefaults else False,
        )
        return obj

    def encode(self):
        json = {}
        json['allowPasswordAuth'] = self.allowPasswordAuth
        json['allowPublicKeyAuth'] = self.allowPublicKeyAuth
        return json

# enumeration
class SSHHostKeyType(Enumeration):
    idlType = "security.SSHHostKeyType:2.0.0"
    values = ["SSH_HOST_KEY_TYPE_RSA", "SSH_HOST_KEY_TYPE_ECDSA", "SSH_HOST_KEY_TYPE_ED25519"]

SSHHostKeyType.SSH_HOST_KEY_TYPE_RSA = SSHHostKeyType(0)
SSHHostKeyType.SSH_HOST_KEY_TYPE_ECDSA = SSHHostKeyType(1)
SSHHostKeyType.SSH_HOST_KEY_TYPE_ED25519 = SSHHostKeyType(2)

# enumeration
class SSHKeyFingerprintType(Enumeration):
    idlType = "security.SSHKeyFingerprintType:1.0.0"
    values = ["SSH_KEY_FPRINT_TYPE_MD5_HEX", "SSH_KEY_FPRINT_TYPE_SHA256_BASE64", "SSH_KEY_FPRINT_TYPE_UNKNOWN"]

SSHKeyFingerprintType.SSH_KEY_FPRINT_TYPE_MD5_HEX = SSHKeyFingerprintType(0)
SSHKeyFingerprintType.SSH_KEY_FPRINT_TYPE_SHA256_BASE64 = SSHKeyFingerprintType(1)
SSHKeyFingerprintType.SSH_KEY_FPRINT_TYPE_UNKNOWN = SSHKeyFingerprintType(2)

# structure
class SSHKeyFingerprint(Structure):
    idlType = "security.SSHKeyFingerprint:1.0.0"
    elements = ["fingerprint", "type"]

    def __init__(self, fingerprint="", type=None):
        if type is None:
            type = raritan.rpc.security.SSHKeyFingerprintType.SSH_KEY_FPRINT_TYPE_MD5_HEX
        if not typecheck._is_int(fingerprint):
            typecheck.is_string(fingerprint, AssertionError)
        typecheck.is_enum(type, raritan.rpc.security.SSHKeyFingerprintType, AssertionError)

        self.fingerprint = fingerprint
        self.type = type

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            fingerprint = json['fingerprint'] if 'fingerprint' in json or not useDefaults else "",
            type = raritan.rpc.security.SSHKeyFingerprintType.decode(json['type']) if 'type' in json or not useDefaults else raritan.rpc.security.SSHKeyFingerprintType.SSH_KEY_FPRINT_TYPE_MD5_HEX,
        )
        return obj

    def encode(self):
        json = {}
        json['fingerprint'] = str(self.fingerprint)
        json['type'] = raritan.rpc.security.SSHKeyFingerprintType.encode(self.type)
        return json

# structure
class SSHHostKey(Structure):
    idlType = "security.SSHHostKey:2.0.0"
    elements = ["key", "type", "fingerprints"]

    def __init__(self, key="", type=None, fingerprints=[]):
        if type is None:
            type = raritan.rpc.security.SSHHostKeyType.SSH_HOST_KEY_TYPE_RSA
        if not typecheck._is_int(key):
            typecheck.is_string(key, AssertionError)
        typecheck.is_enum(type, raritan.rpc.security.SSHHostKeyType, AssertionError)
        for x0 in fingerprints:
            typecheck.is_struct(x0, raritan.rpc.security.SSHKeyFingerprint, AssertionError)

        self.key = key
        self.type = type
        self.fingerprints = fingerprints

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            key = json['key'] if 'key' in json or not useDefaults else "",
            type = raritan.rpc.security.SSHHostKeyType.decode(json['type']) if 'type' in json or not useDefaults else raritan.rpc.security.SSHHostKeyType.SSH_HOST_KEY_TYPE_RSA,
            fingerprints = [raritan.rpc.security.SSHKeyFingerprint.decode(x0, agent, useDefaults=useDefaults) for x0 in json['fingerprints']] if 'fingerprints' in json or not useDefaults else [],
        )
        return obj

    def encode(self):
        json = {}
        json['key'] = str(self.key)
        json['type'] = raritan.rpc.security.SSHHostKeyType.encode(self.type)
        json['fingerprints'] = [raritan.rpc.security.SSHKeyFingerprint.encode(x0) for x0 in self.fingerprints]
        return json

# structure
class RestrictedServiceAgreement(Structure):
    idlType = "security.RestrictedServiceAgreement:1.0.0"
    elements = ["enabled", "banner"]

    def __init__(self, enabled=False, banner=""):
        typecheck.is_bool(enabled, AssertionError)
        if not typecheck._is_int(banner):
            typecheck.is_string(banner, AssertionError)

        self.enabled = enabled
        self.banner = banner

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
            banner = json['banner'] if 'banner' in json or not useDefaults else "",
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        json['banner'] = str(self.banner)
        return json

# structure
class TpmInfo(Structure):
    idlType = "security.TpmInfo:1.0.0"
    elements = ["detected"]

    def __init__(self, detected=False):
        typecheck.is_bool(detected, AssertionError)

        self.detected = detected

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            detected = json['detected'] if 'detected' in json or not useDefaults else False,
        )
        return obj

    def encode(self):
        json = {}
        json['detected'] = self.detected
        return json

# structure
class FipsSettings(Structure):
    idlType = "security.FipsSettings:1.0.0"
    elements = ["enabled"]

    def __init__(self, enabled=False):
        typecheck.is_bool(enabled, AssertionError)

        self.enabled = enabled

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            enabled = json['enabled'] if 'enabled' in json or not useDefaults else False,
        )
        return obj

    def encode(self):
        json = {}
        json['enabled'] = self.enabled
        return json

# value object
class PasswordSettingsChanged(raritan.rpc.event.UserEvent):
    idlType = "security.PasswordSettingsChanged:1.0.0"

    def __init__(self, oldSettings=None, newSettings=None, actUserName="", actIpAddr="", source=None):
        super(raritan.rpc.security.PasswordSettingsChanged, self).__init__(actUserName, actIpAddr, source)
        if oldSettings is None:
            oldSettings = raritan.rpc.security.PasswordSettings()
        if newSettings is None:
            newSettings = raritan.rpc.security.PasswordSettings()
        typecheck.is_struct(oldSettings, raritan.rpc.security.PasswordSettings, AssertionError)
        typecheck.is_struct(newSettings, raritan.rpc.security.PasswordSettings, AssertionError)

        self.oldSettings = oldSettings
        self.newSettings = newSettings

    def encode(self):
        json = super(raritan.rpc.security.PasswordSettingsChanged, self).encode()
        json['oldSettings'] = raritan.rpc.security.PasswordSettings.encode(self.oldSettings)
        json['newSettings'] = raritan.rpc.security.PasswordSettings.encode(self.newSettings)
        return json

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            oldSettings = raritan.rpc.security.PasswordSettings.decode(json['oldSettings'], agent, useDefaults=useDefaults) if 'oldSettings' in json or not useDefaults else raritan.rpc.security.PasswordSettings(),
            newSettings = raritan.rpc.security.PasswordSettings.decode(json['newSettings'], agent, useDefaults=useDefaults) if 'newSettings' in json or not useDefaults else raritan.rpc.security.PasswordSettings(),
            # for event.UserEvent
            actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
            actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
            # for idl.Event
            source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
        )
        return obj

    def listElements(self):
        elements = ["oldSettings", "newSettings"]
        elements = elements + super(raritan.rpc.security.PasswordSettingsChanged, self).listElements()
        return elements

# value object
class FrontPanelPrivilegesChanged(raritan.rpc.event.UserEvent):
    idlType = "security.FrontPanelPrivilegesChanged:1.0.0"

    def __init__(self, oldPrivileges=[], newPrivileges=[], actUserName="", actIpAddr="", source=None):
        super(raritan.rpc.security.FrontPanelPrivilegesChanged, self).__init__(actUserName, actIpAddr, source)
        for x0 in oldPrivileges:
            if not typecheck._is_int(x0):
                typecheck.is_string(x0, AssertionError)
        for x0 in newPrivileges:
            if not typecheck._is_int(x0):
                typecheck.is_string(x0, AssertionError)

        self.oldPrivileges = oldPrivileges
        self.newPrivileges = newPrivileges

    def encode(self):
        json = super(raritan.rpc.security.FrontPanelPrivilegesChanged, self).encode()
        json['oldPrivileges'] = [str(x0) for x0 in self.oldPrivileges]
        json['newPrivileges'] = [str(x0) for x0 in self.newPrivileges]
        return json

    @classmethod
    def decode(cls, json, agent, useDefaults=False):
        obj = cls(
            oldPrivileges = [x0 for x0 in json['oldPrivileges']] if 'oldPrivileges' in json or not useDefaults else [],
            newPrivileges = [x0 for x0 in json['newPrivileges']] if 'newPrivileges' in json or not useDefaults else [],
            # for event.UserEvent
            actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
            actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
            # for idl.Event
            source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
        )
        return obj

    def listElements(self):
        elements = ["oldPrivileges", "newPrivileges"]
        elements = elements + super(raritan.rpc.security.FrontPanelPrivilegesChanged, self).listElements()
        return elements

# interface
class Security(Interface):
    idlType = "security.Security:5.0.1"

    ERR_INVALID_VALUE = 1

    class _getHttpRedirSettings(Interface.Method):
        name = 'getHttpRedirSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_bool(_ret_, DecodeException)
            return _ret_

    class _setHttpRedirSettings(Interface.Method):
        name = 'setHttpRedirSettings'

        @staticmethod
        def encode(http2httpsRedir):
            typecheck.is_bool(http2httpsRedir, AssertionError)
            args = {}
            args['http2httpsRedir'] = http2httpsRedir
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None

    class _isHstsEnabled(Interface.Method):
        name = 'isHstsEnabled'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_bool(_ret_, DecodeException)
            return _ret_

    class _setHstsEnabled(Interface.Method):
        name = 'setHstsEnabled'

        @staticmethod
        def encode(enable):
            typecheck.is_bool(enable, AssertionError)
            args = {}
            args['enable'] = enable
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None

    class _getIpFwSettings(Interface.Method):
        name = 'getIpFwSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.security.IpFw.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.security.IpFw, DecodeException)
            return _ret_

    class _setIpFwSettings(Interface.Method):
        name = 'setIpFwSettings'

        @staticmethod
        def encode(ipFw):
            typecheck.is_struct(ipFw, raritan.rpc.security.IpFw, AssertionError)
            args = {}
            args['ipFw'] = raritan.rpc.security.IpFw.encode(ipFw)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getIpV6FwSettings(Interface.Method):
        name = 'getIpV6FwSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.security.IpFw.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.security.IpFw, DecodeException)
            return _ret_

    class _setIpV6FwSettings(Interface.Method):
        name = 'setIpV6FwSettings'

        @staticmethod
        def encode(ipV6Fw):
            typecheck.is_struct(ipV6Fw, raritan.rpc.security.IpFw, AssertionError)
            args = {}
            args['ipV6Fw'] = raritan.rpc.security.IpFw.encode(ipV6Fw)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getRoleAccessControlSettings(Interface.Method):
        name = 'getRoleAccessControlSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.security.RoleAccessControl.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.security.RoleAccessControl, DecodeException)
            return _ret_

    class _setRoleAccessControlSettings(Interface.Method):
        name = 'setRoleAccessControlSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.security.RoleAccessControl, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.security.RoleAccessControl.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getRoleAccessControlSettingsV6(Interface.Method):
        name = 'getRoleAccessControlSettingsV6'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.security.RoleAccessControl.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.security.RoleAccessControl, DecodeException)
            return _ret_

    class _setRoleAccessControlSettingsV6(Interface.Method):
        name = 'setRoleAccessControlSettingsV6'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.security.RoleAccessControl, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.security.RoleAccessControl.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getBlockSettings(Interface.Method):
        name = 'getBlockSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.security.BlockSettings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.security.BlockSettings, DecodeException)
            return _ret_

    class _setBlockSettings(Interface.Method):
        name = 'setBlockSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.security.BlockSettings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.security.BlockSettings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getPwSettings(Interface.Method):
        name = 'getPwSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.security.PasswordSettings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.security.PasswordSettings, DecodeException)
            return _ret_

    class _setPwSettings(Interface.Method):
        name = 'setPwSettings'

        @staticmethod
        def encode(pwSettings):
            typecheck.is_struct(pwSettings, raritan.rpc.security.PasswordSettings, AssertionError)
            args = {}
            args['pwSettings'] = raritan.rpc.security.PasswordSettings.encode(pwSettings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getIdleTimeoutSettings(Interface.Method):
        name = 'getIdleTimeoutSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _setIdleTimeoutSettings(Interface.Method):
        name = 'setIdleTimeoutSettings'

        @staticmethod
        def encode(idleTimeout):
            typecheck.is_int(idleTimeout, AssertionError)
            args = {}
            args['idleTimeout'] = idleTimeout
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getSingleLoginLimitation(Interface.Method):
        name = 'getSingleLoginLimitation'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_bool(_ret_, DecodeException)
            return _ret_

    class _setSingleLoginLimitation(Interface.Method):
        name = 'setSingleLoginLimitation'

        @staticmethod
        def encode(singleLogin):
            typecheck.is_bool(singleLogin, AssertionError)
            args = {}
            args['singleLogin'] = singleLogin
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None

    class _getSSHSettings(Interface.Method):
        name = 'getSSHSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.security.SSHSettings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.security.SSHSettings, DecodeException)
            return _ret_

    class _setSSHSettings(Interface.Method):
        name = 'setSSHSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.security.SSHSettings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.security.SSHSettings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None

    class _getSSHHostKeys(Interface.Method):
        name = 'getSSHHostKeys'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.security.SSHHostKey.decode(x0, agent, useDefaults=useDefaults) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.security.SSHHostKey, DecodeException)
            return _ret_

    class _getRestrictedServiceAgreement(Interface.Method):
        name = 'getRestrictedServiceAgreement'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.security.RestrictedServiceAgreement.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.security.RestrictedServiceAgreement, DecodeException)
            return _ret_

    class _setRestrictedServiceAgreement(Interface.Method):
        name = 'setRestrictedServiceAgreement'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.security.RestrictedServiceAgreement, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.security.RestrictedServiceAgreement.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getSupportedFrontPanelPrivileges(Interface.Method):
        name = 'getSupportedFrontPanelPrivileges'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [x0 for x0 in rsp['_ret_']]
            for x0 in _ret_:
                if not typecheck._is_int(x0):
                    typecheck.is_string(x0, DecodeException)
            return _ret_

    class _getFrontPanelPrivileges(Interface.Method):
        name = 'getFrontPanelPrivileges'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [x0 for x0 in rsp['_ret_']]
            for x0 in _ret_:
                if not typecheck._is_int(x0):
                    typecheck.is_string(x0, DecodeException)
            return _ret_

    class _setFrontPanelPrivileges(Interface.Method):
        name = 'setFrontPanelPrivileges'

        @staticmethod
        def encode(privileges):
            for x0 in privileges:
                if not typecheck._is_int(x0):
                    typecheck.is_string(x0, AssertionError)
            args = {}
            args['privileges'] = [str(x0) for x0 in privileges]
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _setDefaultAdminAccountPassword(Interface.Method):
        name = 'setDefaultAdminAccountPassword'

        @staticmethod
        def encode(password, disableStrongPasswordReq):
            if not typecheck._is_int(password):
                typecheck.is_string(password, AssertionError)
            typecheck.is_bool(disableStrongPasswordReq, AssertionError)
            args = {}
            args['password'] = str(password)
            args['disableStrongPasswordReq'] = disableStrongPasswordReq
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _setAdminAccountPasswordHash(Interface.Method):
        name = 'setAdminAccountPasswordHash'

        @staticmethod
        def encode(passwordHash):
            if not typecheck._is_int(passwordHash):
                typecheck.is_string(passwordHash, AssertionError)
            args = {}
            args['passwordHash'] = str(passwordHash)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _isSecureBootActive(Interface.Method):
        name = 'isSecureBootActive'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_bool(_ret_, DecodeException)
            return _ret_

    class _getTpmInfo(Interface.Method):
        name = 'getTpmInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.security.TpmInfo.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.security.TpmInfo, DecodeException)
            return _ret_

    class _getActiveFipsSettings(Interface.Method):
        name = 'getActiveFipsSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.security.FipsSettings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.security.FipsSettings, DecodeException)
            return _ret_

    class _getPersistentFipsSettings(Interface.Method):
        name = 'getPersistentFipsSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.security.FipsSettings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.security.FipsSettings, DecodeException)
            return _ret_

    class _setPersistentFipsSettings(Interface.Method):
        name = 'setPersistentFipsSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.security.FipsSettings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.security.FipsSettings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None
    def __init__(self, target, agent):
        super(Security, self).__init__(target, agent)
        self.getHttpRedirSettings = Security._getHttpRedirSettings(self)
        self.setHttpRedirSettings = Security._setHttpRedirSettings(self)
        self.isHstsEnabled = Security._isHstsEnabled(self)
        self.setHstsEnabled = Security._setHstsEnabled(self)
        self.getIpFwSettings = Security._getIpFwSettings(self)
        self.setIpFwSettings = Security._setIpFwSettings(self)
        self.getIpV6FwSettings = Security._getIpV6FwSettings(self)
        self.setIpV6FwSettings = Security._setIpV6FwSettings(self)
        self.getRoleAccessControlSettings = Security._getRoleAccessControlSettings(self)
        self.setRoleAccessControlSettings = Security._setRoleAccessControlSettings(self)
        self.getRoleAccessControlSettingsV6 = Security._getRoleAccessControlSettingsV6(self)
        self.setRoleAccessControlSettingsV6 = Security._setRoleAccessControlSettingsV6(self)
        self.getBlockSettings = Security._getBlockSettings(self)
        self.setBlockSettings = Security._setBlockSettings(self)
        self.getPwSettings = Security._getPwSettings(self)
        self.setPwSettings = Security._setPwSettings(self)
        self.getIdleTimeoutSettings = Security._getIdleTimeoutSettings(self)
        self.setIdleTimeoutSettings = Security._setIdleTimeoutSettings(self)
        self.getSingleLoginLimitation = Security._getSingleLoginLimitation(self)
        self.setSingleLoginLimitation = Security._setSingleLoginLimitation(self)
        self.getSSHSettings = Security._getSSHSettings(self)
        self.setSSHSettings = Security._setSSHSettings(self)
        self.getSSHHostKeys = Security._getSSHHostKeys(self)
        self.getRestrictedServiceAgreement = Security._getRestrictedServiceAgreement(self)
        self.setRestrictedServiceAgreement = Security._setRestrictedServiceAgreement(self)
        self.getSupportedFrontPanelPrivileges = Security._getSupportedFrontPanelPrivileges(self)
        self.getFrontPanelPrivileges = Security._getFrontPanelPrivileges(self)
        self.setFrontPanelPrivileges = Security._setFrontPanelPrivileges(self)
        self.setDefaultAdminAccountPassword = Security._setDefaultAdminAccountPassword(self)
        self.setAdminAccountPasswordHash = Security._setAdminAccountPasswordHash(self)
        self.isSecureBootActive = Security._isSecureBootActive(self)
        self.getTpmInfo = Security._getTpmInfo(self)
        self.getActiveFipsSettings = Security._getActiveFipsSettings(self)
        self.getPersistentFipsSettings = Security._getPersistentFipsSettings(self)
        self.setPersistentFipsSettings = Security._setPersistentFipsSettings(self)
