// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from AssetStripLogger.idl.

package com.raritan.idl.assetmgrmodel;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface AssetStripLogger_1_0_1 {
  static public final TypeInfo typeInfo = new TypeInfo("assetmgrmodel.AssetStripLogger:1.0.1", null);

  public static final int NO_ERROR = 0;

  public static final int ERR_INVALID_PARAM = 1;

  static public class Info implements Cloneable {
    public int capacity = 0;
    public int oldestRecord = 0;
    public int newestRecord = 0;
    public int totalEventCount = 0;

    public Object clone() {
      Info copy = new Info();

      copy.capacity = this.capacity;
      copy.oldestRecord = this.oldestRecord;
      copy.newestRecord = this.newestRecord;
      copy.totalEventCount = this.totalEventCount;

      return copy;
    }

  }

  public enum RecordType {
    EMPTY,
    ASSET_TAG_CONNECTED,
    ASSET_TAG_DISCONNECTED,
    ASSET_STRIP_STATE_CHANGED;
  }

  static public class Record implements Cloneable {
    public java.util.Date timestamp = new java.util.Date();
    public com.raritan.idl.assetmgrmodel.AssetStripLogger_1_0_1.RecordType type = com.raritan.idl.assetmgrmodel.AssetStripLogger_1_0_1.RecordType.values()[0];
    public int assetStripNumber = 0;
    public int rackUnitNumber = 0;
    public int rackUnitPosition = 0;
    public int slotNumber = 0;
    public String tagId = new String();
    public String parentBladeId = new String();
    public com.raritan.idl.assetmgrmodel.AssetStrip_2_0_0.State state = com.raritan.idl.assetmgrmodel.AssetStrip_2_0_0.State.values()[0];

    public Object clone() {
      Record copy = new Record();

      copy.timestamp = this.timestamp;
      copy.type = this.type;
      copy.assetStripNumber = this.assetStripNumber;
      copy.rackUnitNumber = this.rackUnitNumber;
      copy.rackUnitPosition = this.rackUnitPosition;
      copy.slotNumber = this.slotNumber;
      copy.tagId = this.tagId;
      copy.parentBladeId = this.parentBladeId;
      copy.state = this.state;

      return copy;
    }

  }

  public class GetInfoResult {
    public com.raritan.idl.assetmgrmodel.AssetStripLogger_1_0_1.Info _ret_;
  }

  GetInfoResult getInfo() throws Exception;

  AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult> rsp);

  AsyncRequest getInfo(AsyncRpcResponse<GetInfoResult> rsp, RpcCtrl rpcCtrl);


  public class GetRecordsResult {
    public int _ret_;
    public java.util.List<com.raritan.idl.assetmgrmodel.AssetStripLogger_1_0_1.Record> records;
  }

  GetRecordsResult getRecords(int id, int count) throws Exception;

  AsyncRequest getRecords(int id, int count, AsyncRpcResponse<GetRecordsResult> rsp);

  AsyncRequest getRecords(int id, int count, AsyncRpcResponse<GetRecordsResult> rsp, RpcCtrl rpcCtrl);

}
