// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from PeripheralDeviceManager.idl.

package com.raritan.idl.peripheral;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface DeviceManager_2_0_2 {
  static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager:2.0.2", null);

  public static final int ERR_INVALID_PARAMS = 1;

  public enum ZCoordMode {
    RACKUNITS,
    FREEFORM;
  }

  static public class Settings implements Cloneable {
    public com.raritan.idl.peripheral.DeviceManager_2_0_2.ZCoordMode zCoordMode = com.raritan.idl.peripheral.DeviceManager_2_0_2.ZCoordMode.values()[0];
    public boolean autoManageNewDevices = false;
    public float deviceAltitude = 0.0f;
    public int presenceDetectionTimeout = 0;
    public java.util.Map<String, com.raritan.idl.sensors.NumericSensor_4_0_1.Thresholds> defaultThresholdsMap = new java.util.HashMap<>();

    public Object clone() {
      Settings copy = new Settings();

      copy.zCoordMode = this.zCoordMode;
      copy.autoManageNewDevices = this.autoManageNewDevices;
      copy.deviceAltitude = this.deviceAltitude;
      copy.presenceDetectionTimeout = this.presenceDetectionTimeout;
      copy.defaultThresholdsMap = new java.util.HashMap<String, com.raritan.idl.sensors.NumericSensor_4_0_1.Thresholds>(this.defaultThresholdsMap);

      return copy;
    }

  }

  static public class MetaData implements Cloneable {
    public int oneWirePortCount = 0;
    public int onboardDeviceCount = 0;

    public Object clone() {
      MetaData copy = new MetaData();

      copy.oneWirePortCount = this.oneWirePortCount;
      copy.onboardDeviceCount = this.onboardDeviceCount;

      return copy;
    }

  }

  static public class DeviceTypeInfo implements Cloneable {
    public com.raritan.idl.sensors.Sensor_4_0_1.TypeSpec type = new com.raritan.idl.sensors.Sensor_4_0_1.TypeSpec();
    public boolean isActuator = false;
    public String identifier = new String();
    public String name = new String();
    public com.raritan.idl.sensors.NumericSensor_4_0_1.Range defaultRange = new com.raritan.idl.sensors.NumericSensor_4_0_1.Range();
    public int defaultDecDigits = 0;

    public Object clone() {
      DeviceTypeInfo copy = new DeviceTypeInfo();

      Object typeCopy = this.type.clone();
      copy.type = (com.raritan.idl.sensors.Sensor_4_0_1.TypeSpec) typeCopy;
      copy.isActuator = this.isActuator;
      copy.identifier = this.identifier;
      copy.name = this.name;
      Object defaultRangeCopy = this.defaultRange.clone();
      copy.defaultRange = (com.raritan.idl.sensors.NumericSensor_4_0_1.Range) defaultRangeCopy;
      copy.defaultDecDigits = this.defaultDecDigits;

      return copy;
    }

  }

  static public class FirmwareUpdateState implements Cloneable {
    public boolean active = false;
    public int remaining = 0;

    public Object clone() {
      FirmwareUpdateState copy = new FirmwareUpdateState();

      copy.active = this.active;
      copy.remaining = this.remaining;

      return copy;
    }

  }

  public class SettingsChangedEvent extends com.raritan.idl.event.UserEvent {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_2_0_2.SettingsChangedEvent:1.0.0", com.raritan.idl.event.UserEvent.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.peripheral.DeviceManager_2_0_2.Settings oldSettings = new com.raritan.idl.peripheral.DeviceManager_2_0_2.Settings();
    public com.raritan.idl.peripheral.DeviceManager_2_0_2.Settings newSettings = new com.raritan.idl.peripheral.DeviceManager_2_0_2.Settings();
  }

  public class DeviceEvent_2_0_0 extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_2_0_2.DeviceEvent:2.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public java.util.List<com.raritan.idl.peripheral.Device_3_0_0> devices = new java.util.ArrayList<>();
    public java.util.List<com.raritan.idl.peripheral.Device_3_0_0> allDevices = new java.util.ArrayList<>();
  }

  public class DeviceAddedEvent_2_0_0 extends com.raritan.idl.peripheral.DeviceManager_2_0_2.DeviceEvent_2_0_0 {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_2_0_2.DeviceAddedEvent:2.0.0", com.raritan.idl.peripheral.DeviceManager_2_0_2.DeviceEvent_2_0_0.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  public class DeviceRemovedEvent_2_0_0 extends com.raritan.idl.peripheral.DeviceManager_2_0_2.DeviceEvent_2_0_0 {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_2_0_2.DeviceRemovedEvent:2.0.0", com.raritan.idl.peripheral.DeviceManager_2_0_2.DeviceEvent_2_0_0.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  public class UnknownDeviceAttachedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_2_0_2.UnknownDeviceAttachedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public String romCode = new String();
    public java.util.List<com.raritan.idl.peripheral.PosElement> position = new java.util.ArrayList<>();
  }

  public enum DeviceFirmwareUpdateState {
    UPDATE_STARTED,
    UPDATE_SUCCESSFUL,
    UPDATE_FAILED;
  }

  public class DeviceFirmwareUpdateStateChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_2_0_2.DeviceFirmwareUpdateStateChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public String oldVersion = new String();
    public String newVersion = new String();
    public String serial = new String();
    public com.raritan.idl.peripheral.DeviceManager_2_0_2.DeviceFirmwareUpdateState state = com.raritan.idl.peripheral.DeviceManager_2_0_2.DeviceFirmwareUpdateState.values()[0];
  }

  public class FirmwareUpdateStateChangedEvent extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_2_0_2.FirmwareUpdateStateChangedEvent:1.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public com.raritan.idl.peripheral.DeviceManager_2_0_2.FirmwareUpdateState newState = new com.raritan.idl.peripheral.DeviceManager_2_0_2.FirmwareUpdateState();
  }

  public class PackageEvent_2_0_0 extends com.raritan.idl.idl.Event {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_2_0_2.PackageEvent:2.0.0", com.raritan.idl.idl.Event.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

    public java.util.List<com.raritan.idl.peripheral.PackageInfo_2_0_0> packageInfos = new java.util.ArrayList<>();
    public java.util.List<com.raritan.idl.peripheral.PackageInfo_2_0_0> allPackages = new java.util.ArrayList<>();
  }

  public class PackageAddedEvent_2_0_0 extends com.raritan.idl.peripheral.DeviceManager_2_0_2.PackageEvent_2_0_0 {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_2_0_2.PackageAddedEvent:2.0.0", com.raritan.idl.peripheral.DeviceManager_2_0_2.PackageEvent_2_0_0.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  public class PackageRemovedEvent_2_0_0 extends com.raritan.idl.peripheral.DeviceManager_2_0_2.PackageEvent_2_0_0 {

    static public final TypeInfo typeInfo = new TypeInfo("peripheral.DeviceManager_2_0_2.PackageRemovedEvent:2.0.0", com.raritan.idl.peripheral.DeviceManager_2_0_2.PackageEvent_2_0_0.typeInfo);

    @Override
    protected TypeInfo getClassTypeInfo() {
      return typeInfo;
    }

  }

  static public class Statistics implements Cloneable {
    public int cSumErrCnt = 0;

    public Object clone() {
      Statistics copy = new Statistics();

      copy.cSumErrCnt = this.cSumErrCnt;

      return copy;
    }

  }

  public class GetDeviceSlotsResult {
    public java.util.List<com.raritan.idl.peripheral.DeviceSlot_2_0_1> _ret_;
  }

  GetDeviceSlotsResult getDeviceSlots() throws Exception;

  AsyncRequest getDeviceSlots(AsyncRpcResponse<GetDeviceSlotsResult> rsp);

  AsyncRequest getDeviceSlots(AsyncRpcResponse<GetDeviceSlotsResult> rsp, RpcCtrl rpcCtrl);


  public class GetDeviceSlotResult {
    public com.raritan.idl.peripheral.DeviceSlot_2_0_1 _ret_;
  }

  GetDeviceSlotResult getDeviceSlot(int idx) throws Exception;

  AsyncRequest getDeviceSlot(int idx, AsyncRpcResponse<GetDeviceSlotResult> rsp);

  AsyncRequest getDeviceSlot(int idx, AsyncRpcResponse<GetDeviceSlotResult> rsp, RpcCtrl rpcCtrl);


  public class GetDiscoveredDevicesResult {
    public java.util.List<com.raritan.idl.peripheral.Device_3_0_0> _ret_;
  }

  GetDiscoveredDevicesResult getDiscoveredDevices() throws Exception;

  AsyncRequest getDiscoveredDevices(AsyncRpcResponse<GetDiscoveredDevicesResult> rsp);

  AsyncRequest getDiscoveredDevices(AsyncRpcResponse<GetDiscoveredDevicesResult> rsp, RpcCtrl rpcCtrl);


  public class GetDiscoveredPackageInfosResult {
    public java.util.List<com.raritan.idl.peripheral.PackageInfo_2_0_0> _ret_;
  }

  GetDiscoveredPackageInfosResult getDiscoveredPackageInfos() throws Exception;

  AsyncRequest getDiscoveredPackageInfos(AsyncRpcResponse<GetDiscoveredPackageInfosResult> rsp);

  AsyncRequest getDiscoveredPackageInfos(AsyncRpcResponse<GetDiscoveredPackageInfosResult> rsp, RpcCtrl rpcCtrl);


  public class GetSettingsResult {
    public com.raritan.idl.peripheral.DeviceManager_2_0_2.Settings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(com.raritan.idl.peripheral.DeviceManager_2_0_2.Settings settings) throws Exception;

  AsyncRequest setSettings(com.raritan.idl.peripheral.DeviceManager_2_0_2.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(com.raritan.idl.peripheral.DeviceManager_2_0_2.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class GetMetaDataResult {
    public com.raritan.idl.peripheral.DeviceManager_2_0_2.MetaData _ret_;
  }

  GetMetaDataResult getMetaData() throws Exception;

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp);

  AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult> rsp, RpcCtrl rpcCtrl);


  public class GetDeviceTypeInfosResult {
    public java.util.List<com.raritan.idl.peripheral.DeviceManager_2_0_2.DeviceTypeInfo> _ret_;
  }

  GetDeviceTypeInfosResult getDeviceTypeInfos() throws Exception;

  AsyncRequest getDeviceTypeInfos(AsyncRpcResponse<GetDeviceTypeInfosResult> rsp);

  AsyncRequest getDeviceTypeInfos(AsyncRpcResponse<GetDeviceTypeInfosResult> rsp, RpcCtrl rpcCtrl);


  public class GetFirmwareUpdateStateResult {
    public com.raritan.idl.peripheral.DeviceManager_2_0_2.FirmwareUpdateState _ret_;
  }

  GetFirmwareUpdateStateResult getFirmwareUpdateState() throws Exception;

  AsyncRequest getFirmwareUpdateState(AsyncRpcResponse<GetFirmwareUpdateStateResult> rsp);

  AsyncRequest getFirmwareUpdateState(AsyncRpcResponse<GetFirmwareUpdateStateResult> rsp, RpcCtrl rpcCtrl);


  public class GetStatisticsResult {
    public com.raritan.idl.peripheral.DeviceManager_2_0_2.Statistics _ret_;
  }

  GetStatisticsResult getStatistics() throws Exception;

  AsyncRequest getStatistics(AsyncRpcResponse<GetStatisticsResult> rsp);

  AsyncRequest getStatistics(AsyncRpcResponse<GetStatisticsResult> rsp, RpcCtrl rpcCtrl);

}
