// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from GsmModem.idl.

package com.raritan.idl.serial;

import com.raritan.idl.*;
import com.raritan.util.AsyncRequest;

public interface GsmModem {
  static public final TypeInfo typeInfo = new TypeInfo("serial.GsmModem:1.0.0", null);

  public static final int SUCCESS = 0;

  public static final int ERR_INVALID_VALUE = 1;

  public static final int ERR_WRONG_PIN = 2;

  public static final int ERR_SMS_SEND_FAILED = 3;

  public static final int ERR_COMMUNICATION_FAILURE = 4;

  static public class Settings implements Cloneable {
    public String pin = new String();
    public String smsc = new String();

    public Object clone() {
      Settings copy = new Settings();

      copy.pin = this.pin;
      copy.smsc = this.smsc;

      return copy;
    }

  }

  static public class Information implements Cloneable {
    public String imei = new String();
    public String imsi = new String();
    public String manufacturer = new String();
    public String model = new String();
    public String revision = new String();
    public String ownNumber = new String();
    public String simSmsc = new String();
    public String networkName = new String();
    public String serviceProviderName = new String();
    public int receptionLevel = 0;

    public Object clone() {
      Information copy = new Information();

      copy.imei = this.imei;
      copy.imsi = this.imsi;
      copy.manufacturer = this.manufacturer;
      copy.model = this.model;
      copy.revision = this.revision;
      copy.ownNumber = this.ownNumber;
      copy.simSmsc = this.simSmsc;
      copy.networkName = this.networkName;
      copy.serviceProviderName = this.serviceProviderName;
      copy.receptionLevel = this.receptionLevel;

      return copy;
    }

  }

  public class GetSettingsResult {
    public com.raritan.idl.serial.GsmModem.Settings _ret_;
  }

  GetSettingsResult getSettings() throws Exception;

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp);

  AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SetSettingsResult {
    public int _ret_;
  }

  SetSettingsResult setSettings(com.raritan.idl.serial.GsmModem.Settings settings) throws Exception;

  AsyncRequest setSettings(com.raritan.idl.serial.GsmModem.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp);

  AsyncRequest setSettings(com.raritan.idl.serial.GsmModem.Settings settings, AsyncRpcResponse<SetSettingsResult> rsp, RpcCtrl rpcCtrl);


  public class SendSmsResult {
    public int _ret_;
  }

  SendSmsResult sendSms(String recipient, String text) throws Exception;

  AsyncRequest sendSms(String recipient, String text, AsyncRpcResponse<SendSmsResult> rsp);

  AsyncRequest sendSms(String recipient, String text, AsyncRpcResponse<SendSmsResult> rsp, RpcCtrl rpcCtrl);


  public class SendTestSmsResult {
    public int _ret_;
  }

  SendTestSmsResult sendTestSms(String recipient, com.raritan.idl.serial.GsmModem.Settings testSettings) throws Exception;

  AsyncRequest sendTestSms(String recipient, com.raritan.idl.serial.GsmModem.Settings testSettings, AsyncRpcResponse<SendTestSmsResult> rsp);

  AsyncRequest sendTestSms(String recipient, com.raritan.idl.serial.GsmModem.Settings testSettings, AsyncRpcResponse<SendTestSmsResult> rsp, RpcCtrl rpcCtrl);


  public class GetInformationResult {
    public int _ret_;
    public com.raritan.idl.serial.GsmModem.Information info;
  }

  GetInformationResult getInformation() throws Exception;

  AsyncRequest getInformation(AsyncRpcResponse<GetInformationResult> rsp);

  AsyncRequest getInformation(AsyncRpcResponse<GetInformationResult> rsp, RpcCtrl rpcCtrl);


  public class GetInformationWithPinResult {
    public int _ret_;
    public com.raritan.idl.serial.GsmModem.Information info;
  }

  GetInformationWithPinResult getInformationWithPin(String pin) throws Exception;

  AsyncRequest getInformationWithPin(String pin, AsyncRpcResponse<GetInformationWithPinResult> rsp);

  AsyncRequest getInformationWithPin(String pin, AsyncRpcResponse<GetInformationWithPinResult> rsp, RpcCtrl rpcCtrl);

}
