// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from EventEngine.idl.

package com.raritan.json_rpc.event;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class Engine_Proxy extends ObjectProxy implements com.raritan.idl.event.Engine {

  public Engine_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public Engine_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.event.Engine.typeInfo);
  }

  public static Engine_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new Engine_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public ListEventDescsResult listEventDescs(final java.util.List<String> eventIdPrefix) throws Exception {
    JSONObject params = new JSONObject();
    params.put("eventIdPrefix", new JSONArray() {{
      final java.util.List<String> array0 = eventIdPrefix;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(array0.get(i0_f));
      }
    }});
    final JSONObject result = rpcCall("listEventDescs", params);
    ListEventDescsResult ret = new ListEventDescsResult();
    ret._ret_ = result.getInt("_ret_");
    ret.eventDescs = new java.util.ArrayList<com.raritan.idl.event.Engine.EventDesc>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("eventDescs");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.event.Engine.EventDesc_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest listEventDescs(final java.util.List<String> eventIdPrefix, final AsyncRpcResponse<ListEventDescsResult> rsp) {
    return listEventDescs(eventIdPrefix, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest listEventDescs(final java.util.List<String> eventIdPrefix, final AsyncRpcResponse<ListEventDescsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("eventIdPrefix", new JSONArray() {{
        final java.util.List<String> array0 = eventIdPrefix;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(array0.get(i0_f));
        }
      }});
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("listEventDescs", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ListEventDescsResult ret = new ListEventDescsResult();
          ret._ret_ = result.getInt("_ret_");
          ret.eventDescs = new java.util.ArrayList<com.raritan.idl.event.Engine.EventDesc>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("eventDescs");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.event.Engine.EventDesc_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ListActionTypesResult listActionTypes() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("listActionTypes", params);
    ListActionTypesResult ret = new ListActionTypesResult();
    ret._ret_ = new java.util.ArrayList<String>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(array0.getString(i0_f));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest listActionTypes(final AsyncRpcResponse<ListActionTypesResult> rsp) {
    return listActionTypes(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest listActionTypes(final AsyncRpcResponse<ListActionTypesResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("listActionTypes", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ListActionTypesResult ret = new ListActionTypesResult();
          ret._ret_ = new java.util.ArrayList<String>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(array0.getString(i0_f));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public AddActionResult addAction(final com.raritan.idl.event.Engine.Action action) throws Exception {
    JSONObject params = new JSONObject();
    params.put("action", com.raritan.json_rpc.event.Engine.Action_Codec.encode(action));
    final JSONObject result = rpcCall("addAction", params);
    AddActionResult ret = new AddActionResult();
    ret._ret_ = result.getInt("_ret_");
    ret.actionId = result.getString("actionId");
    return ret;
  }

  @Override
  public AsyncRequest addAction(final com.raritan.idl.event.Engine.Action action, final AsyncRpcResponse<AddActionResult> rsp) {
    return addAction(action, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest addAction(final com.raritan.idl.event.Engine.Action action, final AsyncRpcResponse<AddActionResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("action", com.raritan.json_rpc.event.Engine.Action_Codec.encode(action));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("addAction", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          AddActionResult ret = new AddActionResult();
          ret._ret_ = result.getInt("_ret_");
          ret.actionId = result.getString("actionId");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ModifyActionResult modifyAction(final com.raritan.idl.event.Engine.Action action) throws Exception {
    JSONObject params = new JSONObject();
    params.put("action", com.raritan.json_rpc.event.Engine.Action_Codec.encode(action));
    final JSONObject result = rpcCall("modifyAction", params);
    ModifyActionResult ret = new ModifyActionResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest modifyAction(final com.raritan.idl.event.Engine.Action action, final AsyncRpcResponse<ModifyActionResult> rsp) {
    return modifyAction(action, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest modifyAction(final com.raritan.idl.event.Engine.Action action, final AsyncRpcResponse<ModifyActionResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("action", com.raritan.json_rpc.event.Engine.Action_Codec.encode(action));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("modifyAction", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ModifyActionResult ret = new ModifyActionResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public DeleteActionResult deleteAction(final String actionId) throws Exception {
    JSONObject params = new JSONObject();
    params.put("actionId", actionId);
    final JSONObject result = rpcCall("deleteAction", params);
    DeleteActionResult ret = new DeleteActionResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest deleteAction(final String actionId, final AsyncRpcResponse<DeleteActionResult> rsp) {
    return deleteAction(actionId, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest deleteAction(final String actionId, final AsyncRpcResponse<DeleteActionResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("actionId", actionId);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("deleteAction", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          DeleteActionResult ret = new DeleteActionResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ListActionsResult listActions() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("listActions", params);
    ListActionsResult ret = new ListActionsResult();
    ret._ret_ = new java.util.ArrayList<com.raritan.idl.event.Engine.Action>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.event.Engine.Action_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest listActions(final AsyncRpcResponse<ListActionsResult> rsp) {
    return listActions(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest listActions(final AsyncRpcResponse<ListActionsResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("listActions", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ListActionsResult ret = new ListActionsResult();
          ret._ret_ = new java.util.ArrayList<com.raritan.idl.event.Engine.Action>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.event.Engine.Action_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public TriggerActionResult triggerAction(final String actionId, final java.util.List<com.raritan.idl.event.KeyValue> context) throws Exception {
    JSONObject params = new JSONObject();
    params.put("actionId", actionId);
    params.put("context", new JSONArray() {{
      final java.util.List<com.raritan.idl.event.KeyValue> array0 = context;
      for (int i0 = 0; i0 < array0.size(); i0++) {
        final int i0_f = i0;
        this.put(com.raritan.json_rpc.event.KeyValue_Codec.encode(array0.get(i0_f)));
      }
    }});
    final JSONObject result = rpcCall("triggerAction", params);
    TriggerActionResult ret = new TriggerActionResult();
    ret._ret_ = result.getInt("_ret_");
    ret.errMsg = result.getString("errMsg");
    return ret;
  }

  @Override
  public AsyncRequest triggerAction(final String actionId, final java.util.List<com.raritan.idl.event.KeyValue> context, final AsyncRpcResponse<TriggerActionResult> rsp) {
    return triggerAction(actionId, context, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest triggerAction(final String actionId, final java.util.List<com.raritan.idl.event.KeyValue> context, final AsyncRpcResponse<TriggerActionResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("actionId", actionId);
      params.put("context", new JSONArray() {{
        final java.util.List<com.raritan.idl.event.KeyValue> array0 = context;
        for (int i0 = 0; i0 < array0.size(); i0++) {
          final int i0_f = i0;
          this.put(com.raritan.json_rpc.event.KeyValue_Codec.encode(array0.get(i0_f)));
        }
      }});
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("triggerAction", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          TriggerActionResult ret = new TriggerActionResult();
          ret._ret_ = result.getInt("_ret_");
          ret.errMsg = result.getString("errMsg");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public AddRuleResult addRule(final com.raritan.idl.event.Engine.Rule rule) throws Exception {
    JSONObject params = new JSONObject();
    params.put("rule", com.raritan.json_rpc.event.Engine.Rule_Codec.encode(rule));
    final JSONObject result = rpcCall("addRule", params);
    AddRuleResult ret = new AddRuleResult();
    ret._ret_ = result.getInt("_ret_");
    ret.ruleId = result.getString("ruleId");
    return ret;
  }

  @Override
  public AsyncRequest addRule(final com.raritan.idl.event.Engine.Rule rule, final AsyncRpcResponse<AddRuleResult> rsp) {
    return addRule(rule, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest addRule(final com.raritan.idl.event.Engine.Rule rule, final AsyncRpcResponse<AddRuleResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("rule", com.raritan.json_rpc.event.Engine.Rule_Codec.encode(rule));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("addRule", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          AddRuleResult ret = new AddRuleResult();
          ret._ret_ = result.getInt("_ret_");
          ret.ruleId = result.getString("ruleId");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ModifyRuleResult modifyRule(final com.raritan.idl.event.Engine.Rule rule) throws Exception {
    JSONObject params = new JSONObject();
    params.put("rule", com.raritan.json_rpc.event.Engine.Rule_Codec.encode(rule));
    final JSONObject result = rpcCall("modifyRule", params);
    ModifyRuleResult ret = new ModifyRuleResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest modifyRule(final com.raritan.idl.event.Engine.Rule rule, final AsyncRpcResponse<ModifyRuleResult> rsp) {
    return modifyRule(rule, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest modifyRule(final com.raritan.idl.event.Engine.Rule rule, final AsyncRpcResponse<ModifyRuleResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("rule", com.raritan.json_rpc.event.Engine.Rule_Codec.encode(rule));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("modifyRule", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ModifyRuleResult ret = new ModifyRuleResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public EnableRuleResult enableRule(final String ruleId) throws Exception {
    JSONObject params = new JSONObject();
    params.put("ruleId", ruleId);
    final JSONObject result = rpcCall("enableRule", params);
    EnableRuleResult ret = new EnableRuleResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest enableRule(final String ruleId, final AsyncRpcResponse<EnableRuleResult> rsp) {
    return enableRule(ruleId, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest enableRule(final String ruleId, final AsyncRpcResponse<EnableRuleResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("ruleId", ruleId);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("enableRule", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          EnableRuleResult ret = new EnableRuleResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public DisableRuleResult disableRule(final String ruleId) throws Exception {
    JSONObject params = new JSONObject();
    params.put("ruleId", ruleId);
    final JSONObject result = rpcCall("disableRule", params);
    DisableRuleResult ret = new DisableRuleResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest disableRule(final String ruleId, final AsyncRpcResponse<DisableRuleResult> rsp) {
    return disableRule(ruleId, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest disableRule(final String ruleId, final AsyncRpcResponse<DisableRuleResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("ruleId", ruleId);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("disableRule", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          DisableRuleResult ret = new DisableRuleResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public DeleteRuleResult deleteRule(final String ruleId) throws Exception {
    JSONObject params = new JSONObject();
    params.put("ruleId", ruleId);
    final JSONObject result = rpcCall("deleteRule", params);
    DeleteRuleResult ret = new DeleteRuleResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest deleteRule(final String ruleId, final AsyncRpcResponse<DeleteRuleResult> rsp) {
    return deleteRule(ruleId, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest deleteRule(final String ruleId, final AsyncRpcResponse<DeleteRuleResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("ruleId", ruleId);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("deleteRule", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          DeleteRuleResult ret = new DeleteRuleResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ListRulesResult listRules() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("listRules", params);
    ListRulesResult ret = new ListRulesResult();
    ret._ret_ = new java.util.ArrayList<com.raritan.idl.event.Engine.Rule>() {
      private static final long serialVersionUID = 1L;
      {
        final JSONArray array0 = result.getJSONArray("_ret_");
        for (int i0 = 0; i0 < array0.length(); i0++) {
          final int i0_f = i0;
          this.add(com.raritan.json_rpc.event.Engine.Rule_Codec.decode(array0.getJSONObject(i0_f), agent));
        }
      }
    };
    return ret;
  }

  @Override
  public AsyncRequest listRules(final AsyncRpcResponse<ListRulesResult> rsp) {
    return listRules(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest listRules(final AsyncRpcResponse<ListRulesResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("listRules", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ListRulesResult ret = new ListRulesResult();
          ret._ret_ = new java.util.ArrayList<com.raritan.idl.event.Engine.Rule>() {
            private static final long serialVersionUID = 1L;
            {
              final JSONArray array0 = result.getJSONArray("_ret_");
              for (int i0 = 0; i0 < array0.length(); i0++) {
                final int i0_f = i0;
                this.add(com.raritan.json_rpc.event.Engine.Rule_Codec.decode(array0.getJSONObject(i0_f), agent));
              }
            }
          };
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public DeliverEventResult deliverEvent(final com.raritan.idl.event.Event event) throws Exception {
    JSONObject params = new JSONObject();
    params.put("event", com.raritan.json_rpc.event.Event_Codec.encode(event));
    final JSONObject result = rpcCall("deliverEvent", params);
    DeliverEventResult ret = new DeliverEventResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest deliverEvent(final com.raritan.idl.event.Event event, final AsyncRpcResponse<DeliverEventResult> rsp) {
    return deliverEvent(event, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest deliverEvent(final com.raritan.idl.event.Event event, final AsyncRpcResponse<DeliverEventResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("event", com.raritan.json_rpc.event.Event_Codec.encode(event));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("deliverEvent", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          DeliverEventResult ret = new DeliverEventResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public RearmRuleResult rearmRule(final String ruleId) throws Exception {
    JSONObject params = new JSONObject();
    params.put("ruleId", ruleId);
    final JSONObject result = rpcCall("rearmRule", params);
    RearmRuleResult ret = new RearmRuleResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest rearmRule(final String ruleId, final AsyncRpcResponse<RearmRuleResult> rsp) {
    return rearmRule(ruleId, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest rearmRule(final String ruleId, final AsyncRpcResponse<RearmRuleResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("ruleId", ruleId);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("rearmRule", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          RearmRuleResult ret = new RearmRuleResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
