// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ServerMonitor.idl.

package com.raritan.json_rpc.servermon;

import org.json.*;

import com.raritan.idl.*;
import com.raritan.json_rpc.*;
import com.raritan.util.AsyncRequest;

public class ServerMonitor_Proxy extends ObjectProxy implements com.raritan.idl.servermon.ServerMonitor {

  public ServerMonitor_Proxy(Agent agent, String rid, TypeInfo typeInfo) {
    super(agent, rid, typeInfo);
  }

  public ServerMonitor_Proxy(Agent agent, String rid) {
    this(agent, rid, com.raritan.idl.servermon.ServerMonitor.typeInfo);
  }

  public static ServerMonitor_Proxy staticCast(ObjectProxy proxy) {
    return proxy == null ? null : new ServerMonitor_Proxy(proxy.getAgent(), proxy.getRid(), proxy.getStaticTypeInfo());
  }


  @Override
  public AddServerResult addServer(final com.raritan.idl.servermon.ServerMonitor.ServerSettings settings) throws Exception {
    JSONObject params = new JSONObject();
    params.put("settings", com.raritan.json_rpc.servermon.ServerMonitor.ServerSettings_Codec.encode(settings));
    final JSONObject result = rpcCall("addServer", params);
    AddServerResult ret = new AddServerResult();
    ret._ret_ = result.getInt("_ret_");
    ret.id = result.getInt("id");
    return ret;
  }

  @Override
  public AsyncRequest addServer(final com.raritan.idl.servermon.ServerMonitor.ServerSettings settings, final AsyncRpcResponse<AddServerResult> rsp) {
    return addServer(settings, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest addServer(final com.raritan.idl.servermon.ServerMonitor.ServerSettings settings, final AsyncRpcResponse<AddServerResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("settings", com.raritan.json_rpc.servermon.ServerMonitor.ServerSettings_Codec.encode(settings));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("addServer", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          AddServerResult ret = new AddServerResult();
          ret._ret_ = result.getInt("_ret_");
          ret.id = result.getInt("id");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ModifyServerResult modifyServer(final int id, final com.raritan.idl.servermon.ServerMonitor.ServerSettings settings) throws Exception {
    JSONObject params = new JSONObject();
    params.put("id", id);
    params.put("settings", com.raritan.json_rpc.servermon.ServerMonitor.ServerSettings_Codec.encode(settings));
    final JSONObject result = rpcCall("modifyServer", params);
    ModifyServerResult ret = new ModifyServerResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest modifyServer(final int id, final com.raritan.idl.servermon.ServerMonitor.ServerSettings settings, final AsyncRpcResponse<ModifyServerResult> rsp) {
    return modifyServer(id, settings, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest modifyServer(final int id, final com.raritan.idl.servermon.ServerMonitor.ServerSettings settings, final AsyncRpcResponse<ModifyServerResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("id", id);
      params.put("settings", com.raritan.json_rpc.servermon.ServerMonitor.ServerSettings_Codec.encode(settings));
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("modifyServer", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ModifyServerResult ret = new ModifyServerResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public DeleteServerResult deleteServer(final int id) throws Exception {
    JSONObject params = new JSONObject();
    params.put("id", id);
    final JSONObject result = rpcCall("deleteServer", params);
    DeleteServerResult ret = new DeleteServerResult();
    ret._ret_ = result.getInt("_ret_");
    return ret;
  }

  @Override
  public AsyncRequest deleteServer(final int id, final AsyncRpcResponse<DeleteServerResult> rsp) {
    return deleteServer(id, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest deleteServer(final int id, final AsyncRpcResponse<DeleteServerResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("id", id);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("deleteServer", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          DeleteServerResult ret = new DeleteServerResult();
          ret._ret_ = result.getInt("_ret_");
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public GetServerResult getServer(final int id) throws Exception {
    JSONObject params = new JSONObject();
    params.put("id", id);
    final JSONObject result = rpcCall("getServer", params);
    GetServerResult ret = new GetServerResult();
    ret._ret_ = result.getInt("_ret_");
    ret.server = com.raritan.json_rpc.servermon.ServerMonitor.Server_Codec.decode(result.getJSONObject("server"), agent);
    return ret;
  }

  @Override
  public AsyncRequest getServer(final int id, final AsyncRpcResponse<GetServerResult> rsp) {
    return getServer(id, rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest getServer(final int id, final AsyncRpcResponse<GetServerResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = new JSONObject();
    try {
      params.put("id", id);
    } catch (Exception e) {
      rsp.onFailure(e);
    }
    return rpcCall("getServer", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          GetServerResult ret = new GetServerResult();
          ret._ret_ = result.getInt("_ret_");
          ret.server = com.raritan.json_rpc.servermon.ServerMonitor.Server_Codec.decode(result.getJSONObject("server"), agent);
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }

  @Override
  public ListServersResult listServers() throws Exception {
    JSONObject params = null;
    final JSONObject result = rpcCall("listServers", params);
    ListServersResult ret = new ListServersResult();
    ret._ret_ = new java.util.HashMap<Integer, com.raritan.idl.servermon.ServerMonitor.Server>() {{
      final JSONArray array0 = result.getJSONArray("_ret_");
      for (int i0 = 0; i0 < array0.length(); i0++) {
        JSONObject elem0 = array0.getJSONObject(i0);
        final Integer key0 = elem0.getInt("key");
        final com.raritan.idl.servermon.ServerMonitor.Server value0 = com.raritan.json_rpc.servermon.ServerMonitor.Server_Codec.decode(elem0.getJSONObject("value"), agent);
        this.put(key0, value0);
      }
    }};
    return ret;
  }

  @Override
  public AsyncRequest listServers(final AsyncRpcResponse<ListServersResult> rsp) {
    return listServers(rsp, RpcCtrl.getDefault());
  }

  @Override
  public AsyncRequest listServers(final AsyncRpcResponse<ListServersResult> rsp, final RpcCtrl rpcCtrl) {
    JSONObject params = null;
    return rpcCall("listServers", params, new AsyncRpcResponse<JSONObject>() {
      @Override
      public void onSuccess(final JSONObject result) {
        try {
          ListServersResult ret = new ListServersResult();
          ret._ret_ = new java.util.HashMap<Integer, com.raritan.idl.servermon.ServerMonitor.Server>() {{
            final JSONArray array0 = result.getJSONArray("_ret_");
            for (int i0 = 0; i0 < array0.length(); i0++) {
              JSONObject elem0 = array0.getJSONObject(i0);
              final Integer key0 = elem0.getInt("key");
              final com.raritan.idl.servermon.ServerMonitor.Server value0 = com.raritan.json_rpc.servermon.ServerMonitor.Server_Codec.decode(elem0.getJSONObject("value"), agent);
              this.put(key0, value0);
            }
          }};
          rsp.onSuccess(ret);
        } catch (Exception e) {
          onFailure(e);
        }
      }
      @Override
      public void onFailure(Exception e) {
        rsp.onFailure(e);
      }
    }, rpcCtrl);
  }
}
