// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from DataPushService.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl._event {
  public class DataPushService_1_0_3 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("event.DataPushService:1.0.3", null);

    public DataPushService_1_0_3(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public DataPushService_1_0_3(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new DataPushService_1_0_3 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new DataPushService_1_0_3(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public enum EntryType {
      SENSORLIST,
      SENSORLOG,
      AMSLIST,
      AMSLOG,
      AUDITLOG,
    }

    public const int ERR_NO_SUCH_ID = 1;

    public const int ERR_INVALID_PARAMS = 2;

    public const int ERR_MAX_ENTRIES_REACHED = 3;

    public class MqttSettings : ICloneable {
      public object Clone() {
        MqttSettings copy = new MqttSettings();
        copy.topicPrefix = this.topicPrefix;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["topicPrefix"] = this.topicPrefix;
        return json;
      }

      public static MqttSettings Decode(LightJson.JsonObject json, Agent agent) {
        MqttSettings inst = new MqttSettings();
        inst.topicPrefix = (string)json["topicPrefix"];
        return inst;
      }

      public string topicPrefix = "";
    }

    public class EntrySettings : ICloneable {
      public object Clone() {
        EntrySettings copy = new EntrySettings();
        copy.url = this.url;
        copy.allowOffTimeRangeCerts = this.allowOffTimeRangeCerts;
        copy.caCertChain = this.caCertChain;
        copy.useAuth = this.useAuth;
        copy.username = this.username;
        copy.password = this.password;
        copy.type = this.type;
        copy.items = this.items;
        copy.mqttSettings = this.mqttSettings;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["url"] = this.url;
        json["allowOffTimeRangeCerts"] = this.allowOffTimeRangeCerts;
        json["caCertChain"] = this.caCertChain;
        json["useAuth"] = this.useAuth;
        json["username"] = this.username;
        json["password"] = this.password;
        json["type"] = (int)this.type;
        json["items"] = new JsonArray(this.items.Select(
          _value => (JsonValue)(_value)));
        json["mqttSettings"] = this.mqttSettings.Encode();
        return json;
      }

      public static EntrySettings Decode(LightJson.JsonObject json, Agent agent) {
        EntrySettings inst = new EntrySettings();
        inst.url = (string)json["url"];
        inst.allowOffTimeRangeCerts = (bool)json["allowOffTimeRangeCerts"];
        inst.caCertChain = (string)json["caCertChain"];
        inst.useAuth = (bool)json["useAuth"];
        inst.username = (string)json["username"];
        inst.password = (string)json["password"];
        inst.type = (Com.Raritan.Idl._event.DataPushService_1_0_3.EntryType)(int)json["type"];
        inst.items = new System.Collections.Generic.List<string>(json["items"].AsJsonArray.Select(
          _value => (string)_value));
        inst.mqttSettings = Com.Raritan.Idl._event.DataPushService_1_0_3.MqttSettings.Decode(json["mqttSettings"], agent);
        return inst;
      }

      public string url = "";
      public bool allowOffTimeRangeCerts = false;
      public string caCertChain = "";
      public bool useAuth = false;
      public string username = "";
      public string password = "";
      public Com.Raritan.Idl._event.DataPushService_1_0_3.EntryType type = Com.Raritan.Idl._event.DataPushService_1_0_3.EntryType.SENSORLIST;
      public System.Collections.Generic.IEnumerable<string> items = new System.Collections.Generic.List<string>();
      public Com.Raritan.Idl._event.DataPushService_1_0_3.MqttSettings mqttSettings = new Com.Raritan.Idl._event.DataPushService_1_0_3.MqttSettings();
    }

    public class EntryStatus : ICloneable {
      public object Clone() {
        EntryStatus copy = new EntryStatus();
        copy.busy = this.busy;
        copy.rescheduled = this.rescheduled;
        copy.lastAttemptTime = this.lastAttemptTime;
        copy.lastSuccessTime = this.lastSuccessTime;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["busy"] = this.busy;
        json["rescheduled"] = this.rescheduled;
        json["lastAttemptTime"] = (this.lastAttemptTime.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        json["lastSuccessTime"] = (this.lastSuccessTime.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        return json;
      }

      public static EntryStatus Decode(LightJson.JsonObject json, Agent agent) {
        EntryStatus inst = new EntryStatus();
        inst.busy = (bool)json["busy"];
        inst.rescheduled = (bool)json["rescheduled"];
        inst.lastAttemptTime = new System.DateTime(json["lastAttemptTime"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        inst.lastSuccessTime = new System.DateTime(json["lastSuccessTime"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        return inst;
      }

      public bool busy = false;
      public bool rescheduled = false;
      public System.DateTime lastAttemptTime = new System.DateTime(0);
      public System.DateTime lastSuccessTime = new System.DateTime(0);
    }

    public class EntryAddedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("event.DataPushService_1_0_3.EntryAddedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public int entryId = 0;
      public Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings settings = new Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings();
    }

    public class EntryModifiedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("event.DataPushService_1_0_3.EntryModifiedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public int entryId = 0;
      public Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings oldSettings = new Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings();
      public Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings newSettings = new Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings();
    }

    public class EntryDeletedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("event.DataPushService_1_0_3.EntryDeletedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public int entryId = 0;
    }

    public class EntryStatusChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("event.DataPushService_1_0_3.EntryStatusChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public int entryId = 0;
      public Com.Raritan.Idl._event.DataPushService_1_0_3.EntryStatus newStatus = new Com.Raritan.Idl._event.DataPushService_1_0_3.EntryStatus();
    }

    public class AddEntryResult {
      public int _ret_;
      public int entryId;
    }

    public AddEntryResult addEntry(Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings entrySettings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["entrySettings"] = entrySettings.Encode();

      var _result = RpcCall("addEntry", _parameters);
      var _ret = new AddEntryResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.entryId = (int)_result["entryId"];
      return _ret;
    }

    public AsyncRequest addEntry(Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings entrySettings, AsyncRpcResponse<AddEntryResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return addEntry(entrySettings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest addEntry(Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings entrySettings, AsyncRpcResponse<AddEntryResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["entrySettings"] = entrySettings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("addEntry", _parameters,
        _result => {
          try {
            var _ret = new AddEntryResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.entryId = (int)_result["entryId"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ModifyEntryResult {
      public int _ret_;
    }

    public ModifyEntryResult modifyEntry(int entryId, Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings entrySettings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["entryId"] = entryId;
      _parameters["entrySettings"] = entrySettings.Encode();

      var _result = RpcCall("modifyEntry", _parameters);
      var _ret = new ModifyEntryResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest modifyEntry(int entryId, Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings entrySettings, AsyncRpcResponse<ModifyEntryResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return modifyEntry(entryId, entrySettings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest modifyEntry(int entryId, Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings entrySettings, AsyncRpcResponse<ModifyEntryResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["entryId"] = entryId;
        _parameters["entrySettings"] = entrySettings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("modifyEntry", _parameters,
        _result => {
          try {
            var _ret = new ModifyEntryResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class DeleteEntryResult {
      public int _ret_;
    }

    public DeleteEntryResult deleteEntry(int entryId) {
      var _parameters = new LightJson.JsonObject();
      _parameters["entryId"] = entryId;

      var _result = RpcCall("deleteEntry", _parameters);
      var _ret = new DeleteEntryResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest deleteEntry(int entryId, AsyncRpcResponse<DeleteEntryResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return deleteEntry(entryId, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest deleteEntry(int entryId, AsyncRpcResponse<DeleteEntryResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["entryId"] = entryId;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("deleteEntry", _parameters,
        _result => {
          try {
            var _ret = new DeleteEntryResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetEntryResult {
      public int _ret_;
      public Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings entrySettings;
    }

    public GetEntryResult getEntry(int entryId) {
      var _parameters = new LightJson.JsonObject();
      _parameters["entryId"] = entryId;

      var _result = RpcCall("getEntry", _parameters);
      var _ret = new GetEntryResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.entrySettings = Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings.Decode(_result["entrySettings"], agent);
      return _ret;
    }

    public AsyncRequest getEntry(int entryId, AsyncRpcResponse<GetEntryResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getEntry(entryId, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getEntry(int entryId, AsyncRpcResponse<GetEntryResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["entryId"] = entryId;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getEntry", _parameters,
        _result => {
          try {
            var _ret = new GetEntryResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.entrySettings = Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings.Decode(_result["entrySettings"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ListEntriesResult {
      public System.Collections.Generic.IDictionary<int, Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings> _ret_;
    }

    public ListEntriesResult listEntries() {
      JsonObject _parameters = null;
      var _result = RpcCall("listEntries", _parameters);
      var _ret = new ListEntriesResult();
      _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
        _value => new System.Collections.Generic.KeyValuePair<int, Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings>(_value["key"], Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings.Decode(_value["value"], agent))));
      return _ret;
    }

    public AsyncRequest listEntries(AsyncRpcResponse<ListEntriesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return listEntries(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest listEntries(AsyncRpcResponse<ListEntriesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("listEntries", _parameters,
        _result => {
          try {
            var _ret = new ListEntriesResult();
            _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
              _value => new System.Collections.Generic.KeyValuePair<int, Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings>(_value["key"], Com.Raritan.Idl._event.DataPushService_1_0_3.EntrySettings.Decode(_value["value"], agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class PushDataResult {
      public int _ret_;
    }

    public PushDataResult pushData(int entryId) {
      var _parameters = new LightJson.JsonObject();
      _parameters["entryId"] = entryId;

      var _result = RpcCall("pushData", _parameters);
      var _ret = new PushDataResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest pushData(int entryId, AsyncRpcResponse<PushDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return pushData(entryId, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest pushData(int entryId, AsyncRpcResponse<PushDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["entryId"] = entryId;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("pushData", _parameters,
        _result => {
          try {
            var _ret = new PushDataResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class CancelDataPushResult {
    }

    public CancelDataPushResult cancelDataPush(int entryId) {
      var _parameters = new LightJson.JsonObject();
      _parameters["entryId"] = entryId;

      var _result = RpcCall("cancelDataPush", _parameters);
      var _ret = new CancelDataPushResult();
      return _ret;
    }

    public AsyncRequest cancelDataPush(int entryId, AsyncRpcResponse<CancelDataPushResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return cancelDataPush(entryId, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest cancelDataPush(int entryId, AsyncRpcResponse<CancelDataPushResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["entryId"] = entryId;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("cancelDataPush", _parameters,
        _result => {
          try {
            var _ret = new CancelDataPushResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetEntryStatusResult {
      public int _ret_;
      public Com.Raritan.Idl._event.DataPushService_1_0_3.EntryStatus entryStatus;
    }

    public GetEntryStatusResult getEntryStatus(int entryId) {
      var _parameters = new LightJson.JsonObject();
      _parameters["entryId"] = entryId;

      var _result = RpcCall("getEntryStatus", _parameters);
      var _ret = new GetEntryStatusResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.entryStatus = Com.Raritan.Idl._event.DataPushService_1_0_3.EntryStatus.Decode(_result["entryStatus"], agent);
      return _ret;
    }

    public AsyncRequest getEntryStatus(int entryId, AsyncRpcResponse<GetEntryStatusResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getEntryStatus(entryId, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getEntryStatus(int entryId, AsyncRpcResponse<GetEntryStatusResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["entryId"] = entryId;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getEntryStatus", _parameters,
        _result => {
          try {
            var _ret = new GetEntryStatusResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.entryStatus = Com.Raritan.Idl._event.DataPushService_1_0_3.EntryStatus.Decode(_result["entryStatus"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
