// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from EventEngine.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl._event {

  public class Event : ICloneable {
    public object Clone() {
      Event copy = new Event();
      copy.type = this.type;
      copy.id = this.id;
      copy.asserted = this.asserted;
      copy.timeStamp = this.timeStamp;
      copy.context = this.context;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["type"] = (int)this.type;
      json["id"] = new JsonArray(this.id.Select(
        _value => (JsonValue)(_value)));
      json["asserted"] = this.asserted;
      json["timeStamp"] = (this.timeStamp.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
      json["context"] = new JsonArray(this.context.Select(
        _value => (JsonValue)(_value.Encode())));
      return json;
    }

    public static Event Decode(LightJson.JsonObject json, Agent agent) {
      Event inst = new Event();
      inst.type = (Com.Raritan.Idl._event.Event.Type)(int)json["type"];
      inst.id = new System.Collections.Generic.List<string>(json["id"].AsJsonArray.Select(
        _value => (string)_value));
      inst.asserted = (bool)json["asserted"];
      inst.timeStamp = new System.DateTime(json["timeStamp"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
      inst.context = new System.Collections.Generic.List<Com.Raritan.Idl._event.KeyValue>(json["context"].AsJsonArray.Select(
        _value => Com.Raritan.Idl._event.KeyValue.Decode(_value, agent)));
      return inst;
    }


    public enum Type {
      STATE,
      TRIGGER,
    }
    public Com.Raritan.Idl._event.Event.Type type = Com.Raritan.Idl._event.Event.Type.STATE;
    public System.Collections.Generic.IEnumerable<string> id = new System.Collections.Generic.List<string>();
    public bool asserted = false;
    public System.DateTime timeStamp = new System.DateTime(0);
    public System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.KeyValue> context = new System.Collections.Generic.List<Com.Raritan.Idl._event.KeyValue>();
  }
}
