// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from TimerEventManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl._event {
  public class TimerEventManager : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("event.TimerEventManager:1.0.0", null);

    public TimerEventManager(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public TimerEventManager(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new TimerEventManager StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new TimerEventManager(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int NO_ERROR = 0;

    public const int ERR_INVALID_SCHEDULE = 1;

    public const int ERR_UNKNOWN_EVENT_ID = 2;

    public const int ERR_CREATE_EVENT_ID_FAILED = 3;

    public const int ERR_MAX_TIMERS_CREATED = 4;

    public const int JAN = 1;

    public const int FEB = 2;

    public const int MAR = 3;

    public const int APR = 4;

    public const int MAY = 5;

    public const int JUN = 6;

    public const int JUL = 7;

    public const int AUG = 8;

    public const int SEP = 9;

    public const int OCT = 10;

    public const int NOV = 11;

    public const int DEC = 12;

    public const int SUN = 0;

    public const int MON = 1;

    public const int TUE = 2;

    public const int WED = 3;

    public const int THU = 4;

    public const int FRI = 5;

    public const int SAT = 6;

    public class Range : ICloneable {
      public object Clone() {
        Range copy = new Range();
        copy.start = this.start;
        copy.end = this.end;
        copy.step = this.step;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["start"] = this.start;
        json["end"] = this.end;
        json["step"] = this.step;
        return json;
      }

      public static Range Decode(LightJson.JsonObject json, Agent agent) {
        Range inst = new Range();
        inst.start = (int)json["start"];
        inst.end = (int)json["end"];
        inst.step = (int)json["step"];
        return inst;
      }

      public int start = 0;
      public int end = 0;
      public int step = 0;
    }

    public class Schedule : ICloneable {
      public object Clone() {
        Schedule copy = new Schedule();
        copy.minute = this.minute;
        copy.hour = this.hour;
        copy.dayOfMonth = this.dayOfMonth;
        copy.month = this.month;
        copy.dayOfWeek = this.dayOfWeek;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["minute"] = new JsonArray(this.minute.Select(
          _value => (JsonValue)(_value.Encode())));
        json["hour"] = new JsonArray(this.hour.Select(
          _value => (JsonValue)(_value.Encode())));
        json["dayOfMonth"] = new JsonArray(this.dayOfMonth.Select(
          _value => (JsonValue)(_value.Encode())));
        json["month"] = new JsonArray(this.month.Select(
          _value => (JsonValue)(_value.Encode())));
        json["dayOfWeek"] = new JsonArray(this.dayOfWeek.Select(
          _value => (JsonValue)(_value.Encode())));
        return json;
      }

      public static Schedule Decode(LightJson.JsonObject json, Agent agent) {
        Schedule inst = new Schedule();
        inst.minute = new System.Collections.Generic.List<Com.Raritan.Idl._event.TimerEventManager.Range>(json["minute"].AsJsonArray.Select(
          _value => Com.Raritan.Idl._event.TimerEventManager.Range.Decode(_value, agent)));
        inst.hour = new System.Collections.Generic.List<Com.Raritan.Idl._event.TimerEventManager.Range>(json["hour"].AsJsonArray.Select(
          _value => Com.Raritan.Idl._event.TimerEventManager.Range.Decode(_value, agent)));
        inst.dayOfMonth = new System.Collections.Generic.List<Com.Raritan.Idl._event.TimerEventManager.Range>(json["dayOfMonth"].AsJsonArray.Select(
          _value => Com.Raritan.Idl._event.TimerEventManager.Range.Decode(_value, agent)));
        inst.month = new System.Collections.Generic.List<Com.Raritan.Idl._event.TimerEventManager.Range>(json["month"].AsJsonArray.Select(
          _value => Com.Raritan.Idl._event.TimerEventManager.Range.Decode(_value, agent)));
        inst.dayOfWeek = new System.Collections.Generic.List<Com.Raritan.Idl._event.TimerEventManager.Range>(json["dayOfWeek"].AsJsonArray.Select(
          _value => Com.Raritan.Idl._event.TimerEventManager.Range.Decode(_value, agent)));
        return inst;
      }

      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.TimerEventManager.Range> minute = new System.Collections.Generic.List<Com.Raritan.Idl._event.TimerEventManager.Range>();
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.TimerEventManager.Range> hour = new System.Collections.Generic.List<Com.Raritan.Idl._event.TimerEventManager.Range>();
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.TimerEventManager.Range> dayOfMonth = new System.Collections.Generic.List<Com.Raritan.Idl._event.TimerEventManager.Range>();
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.TimerEventManager.Range> month = new System.Collections.Generic.List<Com.Raritan.Idl._event.TimerEventManager.Range>();
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.TimerEventManager.Range> dayOfWeek = new System.Collections.Generic.List<Com.Raritan.Idl._event.TimerEventManager.Range>();
    }

    public class TimerEvent : ICloneable {
      public object Clone() {
        TimerEvent copy = new TimerEvent();
        copy.eventId = this.eventId;
        copy.executionTime = this.executionTime;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["eventId"] = new JsonArray(this.eventId.Select(
          _value => (JsonValue)(_value)));
        json["executionTime"] = this.executionTime.Encode();
        return json;
      }

      public static TimerEvent Decode(LightJson.JsonObject json, Agent agent) {
        TimerEvent inst = new TimerEvent();
        inst.eventId = new System.Collections.Generic.List<string>(json["eventId"].AsJsonArray.Select(
          _value => (string)_value));
        inst.executionTime = Com.Raritan.Idl._event.TimerEventManager.Schedule.Decode(json["executionTime"], agent);
        return inst;
      }

      public System.Collections.Generic.IEnumerable<string> eventId = new System.Collections.Generic.List<string>();
      public Com.Raritan.Idl._event.TimerEventManager.Schedule executionTime = new Com.Raritan.Idl._event.TimerEventManager.Schedule();
    }

    public class AddTimerEventResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<string> eventId;
    }

    public AddTimerEventResult addTimerEvent(Com.Raritan.Idl._event.TimerEventManager.Schedule schedule) {
      var _parameters = new LightJson.JsonObject();
      _parameters["schedule"] = schedule.Encode();

      var _result = RpcCall("addTimerEvent", _parameters);
      var _ret = new AddTimerEventResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.eventId = new System.Collections.Generic.List<string>(_result["eventId"].AsJsonArray.Select(
        _value => (string)_value));
      return _ret;
    }

    public AsyncRequest addTimerEvent(Com.Raritan.Idl._event.TimerEventManager.Schedule schedule, AsyncRpcResponse<AddTimerEventResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return addTimerEvent(schedule, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest addTimerEvent(Com.Raritan.Idl._event.TimerEventManager.Schedule schedule, AsyncRpcResponse<AddTimerEventResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["schedule"] = schedule.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("addTimerEvent", _parameters,
        _result => {
          try {
            var _ret = new AddTimerEventResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.eventId = new System.Collections.Generic.List<string>(_result["eventId"].AsJsonArray.Select(
              _value => (string)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ModifyTimerEventResult {
      public int _ret_;
    }

    public ModifyTimerEventResult modifyTimerEvent(System.Collections.Generic.IEnumerable<string> eventId, Com.Raritan.Idl._event.TimerEventManager.Schedule schedule) {
      var _parameters = new LightJson.JsonObject();
      _parameters["eventId"] = new JsonArray(eventId.Select(
        _value => (JsonValue)(_value)));
      _parameters["schedule"] = schedule.Encode();

      var _result = RpcCall("modifyTimerEvent", _parameters);
      var _ret = new ModifyTimerEventResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest modifyTimerEvent(System.Collections.Generic.IEnumerable<string> eventId, Com.Raritan.Idl._event.TimerEventManager.Schedule schedule, AsyncRpcResponse<ModifyTimerEventResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return modifyTimerEvent(eventId, schedule, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest modifyTimerEvent(System.Collections.Generic.IEnumerable<string> eventId, Com.Raritan.Idl._event.TimerEventManager.Schedule schedule, AsyncRpcResponse<ModifyTimerEventResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["eventId"] = new JsonArray(eventId.Select(
          _value => (JsonValue)(_value)));
        _parameters["schedule"] = schedule.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("modifyTimerEvent", _parameters,
        _result => {
          try {
            var _ret = new ModifyTimerEventResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class DeleteTimerEventResult {
      public int _ret_;
    }

    public DeleteTimerEventResult deleteTimerEvent(System.Collections.Generic.IEnumerable<string> eventId) {
      var _parameters = new LightJson.JsonObject();
      _parameters["eventId"] = new JsonArray(eventId.Select(
        _value => (JsonValue)(_value)));

      var _result = RpcCall("deleteTimerEvent", _parameters);
      var _ret = new DeleteTimerEventResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest deleteTimerEvent(System.Collections.Generic.IEnumerable<string> eventId, AsyncRpcResponse<DeleteTimerEventResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return deleteTimerEvent(eventId, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest deleteTimerEvent(System.Collections.Generic.IEnumerable<string> eventId, AsyncRpcResponse<DeleteTimerEventResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["eventId"] = new JsonArray(eventId.Select(
          _value => (JsonValue)(_value)));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("deleteTimerEvent", _parameters,
        _result => {
          try {
            var _ret = new DeleteTimerEventResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ListTimerEventsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl._event.TimerEventManager.TimerEvent> _ret_;
    }

    public ListTimerEventsResult listTimerEvents() {
      JsonObject _parameters = null;
      var _result = RpcCall("listTimerEvents", _parameters);
      var _ret = new ListTimerEventsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl._event.TimerEventManager.TimerEvent>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl._event.TimerEventManager.TimerEvent.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest listTimerEvents(AsyncRpcResponse<ListTimerEventsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return listTimerEvents(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest listTimerEvents(AsyncRpcResponse<ListTimerEventsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("listTimerEvents", _parameters,
        _result => {
          try {
            var _ret = new ListTimerEventsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl._event.TimerEventManager.TimerEvent>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl._event.TimerEventManager.TimerEvent.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
