// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from TacPlusManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.auth {
  public class TacPlusManager : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("auth.TacPlusManager:1.0.0", null);

    public TacPlusManager(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public TacPlusManager(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new TacPlusManager StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new TacPlusManager(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_INVALID_CFG = 1;

    public const int ERR_SERVER_UNSPECIFIED = 2;

    public const int ERR_INVALID_SHARED_SECRET = 3;

    public const int ERR_SERVER_UNREACHABLE = 4;

    public const int ERR_AUTHENTICATION_FAILED = 5;

    public const int ERR_NO_ROLES = 6;

    public const int ERR_NO_KNOWN_ROLES = 7;

    public class GetTacPlusServersResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.tacplus.ServerSettings> _ret_;
    }

    public GetTacPlusServersResult getTacPlusServers() {
      JsonObject _parameters = null;
      var _result = RpcCall("getTacPlusServers", _parameters);
      var _ret = new GetTacPlusServersResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.tacplus.ServerSettings>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.tacplus.ServerSettings.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getTacPlusServers(AsyncRpcResponse<GetTacPlusServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getTacPlusServers(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getTacPlusServers(AsyncRpcResponse<GetTacPlusServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getTacPlusServers", _parameters,
        _result => {
          try {
            var _ret = new GetTacPlusServersResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.tacplus.ServerSettings>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.tacplus.ServerSettings.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetTacPlusServersResult {
      public int _ret_;
    }

    public SetTacPlusServersResult setTacPlusServers(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.tacplus.ServerSettings> serverList) {
      var _parameters = new LightJson.JsonObject();
      _parameters["serverList"] = new JsonArray(serverList.Select(
        _value => (JsonValue)(_value.Encode())));

      var _result = RpcCall("setTacPlusServers", _parameters);
      var _ret = new SetTacPlusServersResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setTacPlusServers(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.tacplus.ServerSettings> serverList, AsyncRpcResponse<SetTacPlusServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setTacPlusServers(serverList, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setTacPlusServers(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.tacplus.ServerSettings> serverList, AsyncRpcResponse<SetTacPlusServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["serverList"] = new JsonArray(serverList.Select(
          _value => (JsonValue)(_value.Encode())));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setTacPlusServers", _parameters,
        _result => {
          try {
            var _ret = new SetTacPlusServersResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class TestTacPlusServerResult {
      public int _ret_;
    }

    public TestTacPlusServerResult testTacPlusServer(string username, string password, Com.Raritan.Idl.tacplus.ServerSettings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["username"] = username;
      _parameters["password"] = password;
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("testTacPlusServer", _parameters);
      var _ret = new TestTacPlusServerResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest testTacPlusServer(string username, string password, Com.Raritan.Idl.tacplus.ServerSettings settings, AsyncRpcResponse<TestTacPlusServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return testTacPlusServer(username, password, settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest testTacPlusServer(string username, string password, Com.Raritan.Idl.tacplus.ServerSettings settings, AsyncRpcResponse<TestTacPlusServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["username"] = username;
        _parameters["password"] = password;
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("testTacPlusServer", _parameters,
        _result => {
          try {
            var _ret = new TestTacPlusServerResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
