// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Modbus.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.devsettings {
  public class Modbus : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("devsettings.Modbus:1.0.0", null);

    public Modbus(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Modbus(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Modbus StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Modbus(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class TcpSettings : ICloneable {
      public object Clone() {
        TcpSettings copy = new TcpSettings();
        copy._readonly = this._readonly;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["readonly"] = this._readonly;
        return json;
      }

      public static TcpSettings Decode(LightJson.JsonObject json, Agent agent) {
        TcpSettings inst = new TcpSettings();
        inst._readonly = (bool)json["readonly"];
        return inst;
      }

      public bool _readonly = false;
    }

    public class Settings : ICloneable {
      public object Clone() {
        Settings copy = new Settings();
        copy.tcp = this.tcp;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["tcp"] = this.tcp.Encode();
        return json;
      }

      public static Settings Decode(LightJson.JsonObject json, Agent agent) {
        Settings inst = new Settings();
        inst.tcp = Com.Raritan.Idl.devsettings.Modbus.TcpSettings.Decode(json["tcp"], agent);
        return inst;
      }

      public Com.Raritan.Idl.devsettings.Modbus.TcpSettings tcp = new Com.Raritan.Idl.devsettings.Modbus.TcpSettings();
    }

    public class GetSettingsResult {
      public Com.Raritan.Idl.devsettings.Modbus.Settings _ret_;
    }

    public GetSettingsResult getSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSettings", _parameters);
      var _ret = new GetSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.devsettings.Modbus.Settings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSettings", _parameters,
        _result => {
          try {
            var _ret = new GetSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.devsettings.Modbus.Settings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSettingsResult {
    }

    public SetSettingsResult setSettings(Com.Raritan.Idl.devsettings.Modbus.Settings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setSettings", _parameters);
      var _ret = new SetSettingsResult();
      return _ret;
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.devsettings.Modbus.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.devsettings.Modbus.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSettings", _parameters,
        _result => {
          try {
            var _ret = new SetSettingsResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
