// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from HardwareHealth.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.fitness {
  public class HardwareHealth_1_0_3 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("fitness.HardwareHealth:1.0.3", null);

    public HardwareHealth_1_0_3(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public HardwareHealth_1_0_3(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new HardwareHealth_1_0_3 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new HardwareHealth_1_0_3(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int FAILURE_TYPE_NETWORK_DEVICE_NOT_DETECTED = 1;

    public const int FAILURE_TYPE_I2C_BUS_STUCK = 2;

    public const int FAILURE_TYPE_SUB_CTRL_NOT_REACHABLE = 3;

    public const int FAILURE_TYPE_SUB_CTRL_MALFUNCTION = 4;

    public const int FAILURE_TYPE_OUTLET_POWER_STATE_INCONSISTENT = 5;

    public const int FAILURE_TYPE_SUB_CTRL_INCOMPATIBLE = 6;

    public class Failure : ICloneable {
      public object Clone() {
        Failure copy = new Failure();
        copy.creationOrderId = this.creationOrderId;
        copy.componentId = this.componentId;
        copy.type = this.type;
        copy.description = this.description;
        copy.isAsserted = this.isAsserted;
        copy.lastAssertTimeStamp = this.lastAssertTimeStamp;
        copy.lastDeassertTimeStamp = this.lastDeassertTimeStamp;
        copy.assertCount = this.assertCount;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["creationOrderId"] = this.creationOrderId;
        json["componentId"] = this.componentId;
        json["type"] = this.type;
        json["description"] = this.description;
        json["isAsserted"] = this.isAsserted;
        json["lastAssertTimeStamp"] = (this.lastAssertTimeStamp.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        json["lastDeassertTimeStamp"] = (this.lastDeassertTimeStamp.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        json["assertCount"] = this.assertCount;
        return json;
      }

      public static Failure Decode(LightJson.JsonObject json, Agent agent) {
        Failure inst = new Failure();
        inst.creationOrderId = (int)json["creationOrderId"];
        inst.componentId = (string)json["componentId"];
        inst.type = (int)json["type"];
        inst.description = (string)json["description"];
        inst.isAsserted = (bool)json["isAsserted"];
        inst.lastAssertTimeStamp = new System.DateTime(json["lastAssertTimeStamp"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        inst.lastDeassertTimeStamp = new System.DateTime(json["lastDeassertTimeStamp"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        inst.assertCount = (int)json["assertCount"];
        return inst;
      }

      public int creationOrderId = 0;
      public string componentId = "";
      public int type = 0;
      public string description = "";
      public bool isAsserted = false;
      public System.DateTime lastAssertTimeStamp = new System.DateTime(0);
      public System.DateTime lastDeassertTimeStamp = new System.DateTime(0);
      public int assertCount = 0;
    }

    public class FailureStatusChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("fitness.HardwareHealth_1_0_3.FailureStatusChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public string componentId = "";
      public int failureType = 0;
      public bool isAsserted = false;
    }

    public class GetFailuresResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.fitness.HardwareHealth_1_0_3.Failure> _ret_;
    }

    public GetFailuresResult getFailures() {
      JsonObject _parameters = null;
      var _result = RpcCall("getFailures", _parameters);
      var _ret = new GetFailuresResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.fitness.HardwareHealth_1_0_3.Failure>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.fitness.HardwareHealth_1_0_3.Failure.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getFailures(AsyncRpcResponse<GetFailuresResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getFailures(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getFailures(AsyncRpcResponse<GetFailuresResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getFailures", _parameters,
        _result => {
          try {
            var _ret = new GetFailuresResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.fitness.HardwareHealth_1_0_3.Failure>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.fitness.HardwareHealth_1_0_3.Failure.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
