// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from LhxSensor.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.lhxmodel {
  public class Sensor : Com.Raritan.Idl.sensors.Sensor {

    static public readonly new TypeInfo typeInfo = new TypeInfo("lhxmodel.Sensor:1.0.0", Com.Raritan.Idl.sensors.Sensor.typeInfo);

    public Sensor(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Sensor(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Sensor StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Sensor(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public enum Events {
      EVT_KEY_THRESHOLDS,
      EVT_KEY_STATE,
      EVT_KEY_NUM_READING,
    }

    public class MetaData : ICloneable {
      public object Clone() {
        MetaData copy = new MetaData();
        copy.type = this.type;
        copy.numDecDigits = this.numDecDigits;
        copy.numRangeMin = this.numRangeMin;
        copy.numRangeMax = this.numRangeMax;
        copy.numThresholdMin = this.numThresholdMin;
        copy.numThresholdMax = this.numThresholdMax;
        copy.label = this.label;
        copy.id = this.id;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["type"] = this.type.Encode();
        json["numDecDigits"] = this.numDecDigits;
        json["numRangeMin"] = this.numRangeMin;
        json["numRangeMax"] = this.numRangeMax;
        json["numThresholdMin"] = this.numThresholdMin;
        json["numThresholdMax"] = this.numThresholdMax;
        json["label"] = this.label;
        json["id"] = this.id;
        return json;
      }

      public static MetaData Decode(LightJson.JsonObject json, Agent agent) {
        MetaData inst = new MetaData();
        inst.type = Com.Raritan.Idl.sensors.Sensor.TypeSpec.Decode(json["type"], agent);
        inst.numDecDigits = (int)json["numDecDigits"];
        inst.numRangeMin = (double)json["numRangeMin"];
        inst.numRangeMax = (double)json["numRangeMax"];
        inst.numThresholdMin = (double)json["numThresholdMin"];
        inst.numThresholdMax = (double)json["numThresholdMax"];
        inst.label = (string)json["label"];
        inst.id = (string)json["id"];
        return inst;
      }

      public Com.Raritan.Idl.sensors.Sensor.TypeSpec type = new Com.Raritan.Idl.sensors.Sensor.TypeSpec();
      public int numDecDigits = 0;
      public double numRangeMin = 0.0;
      public double numRangeMax = 0.0;
      public double numThresholdMin = 0.0;
      public double numThresholdMax = 0.0;
      public string label = "";
      public string id = "";
    }

    public class NumThresholds : ICloneable {
      public object Clone() {
        NumThresholds copy = new NumThresholds();
        copy.lowerCriticalIsEnabled = this.lowerCriticalIsEnabled;
        copy.lowerCritical = this.lowerCritical;
        copy.lowerWarningIsEnabled = this.lowerWarningIsEnabled;
        copy.lowerWarning = this.lowerWarning;
        copy.upperWarningIsEnabled = this.upperWarningIsEnabled;
        copy.upperWarning = this.upperWarning;
        copy.upperCriticalIsEnabled = this.upperCriticalIsEnabled;
        copy.upperCritical = this.upperCritical;
        copy.hysteresis = this.hysteresis;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["lowerCriticalIsEnabled"] = this.lowerCriticalIsEnabled;
        json["lowerCritical"] = this.lowerCritical;
        json["lowerWarningIsEnabled"] = this.lowerWarningIsEnabled;
        json["lowerWarning"] = this.lowerWarning;
        json["upperWarningIsEnabled"] = this.upperWarningIsEnabled;
        json["upperWarning"] = this.upperWarning;
        json["upperCriticalIsEnabled"] = this.upperCriticalIsEnabled;
        json["upperCritical"] = this.upperCritical;
        json["hysteresis"] = this.hysteresis;
        return json;
      }

      public static NumThresholds Decode(LightJson.JsonObject json, Agent agent) {
        NumThresholds inst = new NumThresholds();
        inst.lowerCriticalIsEnabled = (bool)json["lowerCriticalIsEnabled"];
        inst.lowerCritical = (double)json["lowerCritical"];
        inst.lowerWarningIsEnabled = (bool)json["lowerWarningIsEnabled"];
        inst.lowerWarning = (double)json["lowerWarning"];
        inst.upperWarningIsEnabled = (bool)json["upperWarningIsEnabled"];
        inst.upperWarning = (double)json["upperWarning"];
        inst.upperCriticalIsEnabled = (bool)json["upperCriticalIsEnabled"];
        inst.upperCritical = (double)json["upperCritical"];
        inst.hysteresis = (double)json["hysteresis"];
        return inst;
      }

      public bool lowerCriticalIsEnabled = false;
      public double lowerCritical = 0.0;
      public bool lowerWarningIsEnabled = false;
      public double lowerWarning = 0.0;
      public bool upperWarningIsEnabled = false;
      public double upperWarning = 0.0;
      public bool upperCriticalIsEnabled = false;
      public double upperCritical = 0.0;
      public double hysteresis = 0.0;
    }

    public const int STATE_NOT_AVAILABLE = -1;

    public const int STATE_CLOSED = 0;

    public const int STATE_OPEN = 1;

    public const int STATE_NUM_NORMAL = 0;

    public const int STATE_NUM_ABOVE_UPPER_CRITICAL = 1;

    public const int STATE_NUM_ABOVE_UPPER_WARNING = 2;

    public const int STATE_NUM_BELOW_LOWER_WARNING = 3;

    public const int STATE_NUM_BELOW_LOWER_CRITICAL = 4;

    public class Reading : ICloneable {
      public object Clone() {
        Reading copy = new Reading();
        copy.timestamp = this.timestamp;
        copy.state = this.state;
        copy.value = this.value;
        copy.isValid = this.isValid;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["timestamp"] = (this.timestamp.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        json["state"] = this.state;
        json["value"] = this.value;
        json["isValid"] = this.isValid;
        return json;
      }

      public static Reading Decode(LightJson.JsonObject json, Agent agent) {
        Reading inst = new Reading();
        inst.timestamp = new System.DateTime(json["timestamp"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        inst.state = (int)json["state"];
        inst.value = (double)json["value"];
        inst.isValid = (bool)json["isValid"];
        return inst;
      }

      public System.DateTime timestamp = new System.DateTime(0);
      public int state = 0;
      public double value = 0.0;
      public bool isValid = false;
    }

    public const int ERR_INVALID_PARAM = 1;

    public const int ERR_NOT_SUPPORTED = 2;

    public class GetMetaDataResult {
      public Com.Raritan.Idl.lhxmodel.Sensor.MetaData _ret_;
    }

    public GetMetaDataResult getMetaData() {
      JsonObject _parameters = null;
      var _result = RpcCall("getMetaData", _parameters);
      var _ret = new GetMetaDataResult();
      _ret._ret_ = Com.Raritan.Idl.lhxmodel.Sensor.MetaData.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getMetaData(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getMetaData", _parameters,
        _result => {
          try {
            var _ret = new GetMetaDataResult();
            _ret._ret_ = Com.Raritan.Idl.lhxmodel.Sensor.MetaData.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetThresholdsResult {
      public Com.Raritan.Idl.lhxmodel.Sensor.NumThresholds _ret_;
    }

    public GetThresholdsResult getThresholds() {
      JsonObject _parameters = null;
      var _result = RpcCall("getThresholds", _parameters);
      var _ret = new GetThresholdsResult();
      _ret._ret_ = Com.Raritan.Idl.lhxmodel.Sensor.NumThresholds.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getThresholds(AsyncRpcResponse<GetThresholdsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getThresholds(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getThresholds(AsyncRpcResponse<GetThresholdsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getThresholds", _parameters,
        _result => {
          try {
            var _ret = new GetThresholdsResult();
            _ret._ret_ = Com.Raritan.Idl.lhxmodel.Sensor.NumThresholds.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetThresholdsResult {
      public int _ret_;
    }

    public SetThresholdsResult setThresholds(Com.Raritan.Idl.lhxmodel.Sensor.NumThresholds thresholds) {
      var _parameters = new LightJson.JsonObject();
      _parameters["thresholds"] = thresholds.Encode();

      var _result = RpcCall("setThresholds", _parameters);
      var _ret = new SetThresholdsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setThresholds(Com.Raritan.Idl.lhxmodel.Sensor.NumThresholds thresholds, AsyncRpcResponse<SetThresholdsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setThresholds(thresholds, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setThresholds(Com.Raritan.Idl.lhxmodel.Sensor.NumThresholds thresholds, AsyncRpcResponse<SetThresholdsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["thresholds"] = thresholds.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setThresholds", _parameters,
        _result => {
          try {
            var _ret = new SetThresholdsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetReadingResult {
      public Com.Raritan.Idl.lhxmodel.Sensor.Reading _ret_;
    }

    public GetReadingResult getReading() {
      JsonObject _parameters = null;
      var _result = RpcCall("getReading", _parameters);
      var _ret = new GetReadingResult();
      _ret._ret_ = Com.Raritan.Idl.lhxmodel.Sensor.Reading.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getReading(AsyncRpcResponse<GetReadingResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getReading(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getReading(AsyncRpcResponse<GetReadingResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getReading", _parameters,
        _result => {
          try {
            var _ret = new GetReadingResult();
            _ret._ret_ = Com.Raritan.Idl.lhxmodel.Sensor.Reading.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
