// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ModelPush.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.modelpush {
  public class ModelPush : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("modelpush.ModelPush:1.0.0", null);

    public ModelPush(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public ModelPush(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new ModelPush StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new ModelPush(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_INVALID_PARAMS = 1;

    public class Configuration : ICloneable {
      public object Clone() {
        Configuration copy = new Configuration();
        copy.enabled = this.enabled;
        copy.interval = this.interval;
        copy.host = this.host;
        copy.port = this.port;
        copy.path = this.path;
        copy.useHttps = this.useHttps;
        copy.caCert = this.caCert;
        copy.useAuth = this.useAuth;
        copy.username = this.username;
        copy.password = this.password;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["enabled"] = this.enabled;
        json["interval"] = this.interval;
        json["host"] = this.host;
        json["port"] = this.port;
        json["path"] = this.path;
        json["useHttps"] = this.useHttps;
        json["caCert"] = this.caCert;
        json["useAuth"] = this.useAuth;
        json["username"] = this.username;
        json["password"] = this.password;
        return json;
      }

      public static Configuration Decode(LightJson.JsonObject json, Agent agent) {
        Configuration inst = new Configuration();
        inst.enabled = (bool)json["enabled"];
        inst.interval = (int)json["interval"];
        inst.host = (string)json["host"];
        inst.port = (int)json["port"];
        inst.path = (string)json["path"];
        inst.useHttps = (bool)json["useHttps"];
        inst.caCert = (string)json["caCert"];
        inst.useAuth = (bool)json["useAuth"];
        inst.username = (string)json["username"];
        inst.password = (string)json["password"];
        return inst;
      }

      public bool enabled = false;
      public int interval = 0;
      public string host = "";
      public int port = 0;
      public string path = "";
      public bool useHttps = false;
      public string caCert = "";
      public bool useAuth = false;
      public string username = "";
      public string password = "";
    }

    public class GetConfigurationResult {
      public Com.Raritan.Idl.modelpush.ModelPush.Configuration _ret_;
    }

    public GetConfigurationResult getConfiguration() {
      JsonObject _parameters = null;
      var _result = RpcCall("getConfiguration", _parameters);
      var _ret = new GetConfigurationResult();
      _ret._ret_ = Com.Raritan.Idl.modelpush.ModelPush.Configuration.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getConfiguration(AsyncRpcResponse<GetConfigurationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getConfiguration(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getConfiguration(AsyncRpcResponse<GetConfigurationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getConfiguration", _parameters,
        _result => {
          try {
            var _ret = new GetConfigurationResult();
            _ret._ret_ = Com.Raritan.Idl.modelpush.ModelPush.Configuration.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetConfigurationResult {
      public int _ret_;
    }

    public SetConfigurationResult setConfiguration(Com.Raritan.Idl.modelpush.ModelPush.Configuration cfg) {
      var _parameters = new LightJson.JsonObject();
      _parameters["cfg"] = cfg.Encode();

      var _result = RpcCall("setConfiguration", _parameters);
      var _ret = new SetConfigurationResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setConfiguration(Com.Raritan.Idl.modelpush.ModelPush.Configuration cfg, AsyncRpcResponse<SetConfigurationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setConfiguration(cfg, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setConfiguration(Com.Raritan.Idl.modelpush.ModelPush.Configuration cfg, AsyncRpcResponse<SetConfigurationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["cfg"] = cfg.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setConfiguration", _parameters,
        _result => {
          try {
            var _ret = new SetConfigurationResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
