// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Diagnostics.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.net {
  public class Diagnostics_1_0_1 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("net.Diagnostics:1.0.1", null);

    public Diagnostics_1_0_1(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Diagnostics_1_0_1(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Diagnostics_1_0_1 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Diagnostics_1_0_1(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int NO_ERROR = 0;

    public const int ERR_INVALID_PARAM = 1;

    public const int ERR_EXEC_FAIL = 2;

    public const int ERR_TIMEOUT = 3;

    public const int ERR_RESOLVE_FAIL = 4;

    public class PingResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<string> results;
    }

    public PingResult ping(string hostName, int count) {
      var _parameters = new LightJson.JsonObject();
      _parameters["hostName"] = hostName;
      _parameters["count"] = count;

      var _result = RpcCall("ping", _parameters);
      var _ret = new PingResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.results = new System.Collections.Generic.List<string>(_result["results"].AsJsonArray.Select(
        _value => (string)_value));
      return _ret;
    }

    public AsyncRequest ping(string hostName, int count, AsyncRpcResponse<PingResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return ping(hostName, count, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest ping(string hostName, int count, AsyncRpcResponse<PingResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["hostName"] = hostName;
        _parameters["count"] = count;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("ping", _parameters,
        _result => {
          try {
            var _ret = new PingResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.results = new System.Collections.Generic.List<string>(_result["results"].AsJsonArray.Select(
              _value => (string)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class TraceRouteResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<string> results;
    }

    public TraceRouteResult traceRoute(string hostName, int timeout, bool useIcmp) {
      var _parameters = new LightJson.JsonObject();
      _parameters["hostName"] = hostName;
      _parameters["timeout"] = timeout;
      _parameters["useIcmp"] = useIcmp;

      var _result = RpcCall("traceRoute", _parameters);
      var _ret = new TraceRouteResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.results = new System.Collections.Generic.List<string>(_result["results"].AsJsonArray.Select(
        _value => (string)_value));
      return _ret;
    }

    public AsyncRequest traceRoute(string hostName, int timeout, bool useIcmp, AsyncRpcResponse<TraceRouteResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return traceRoute(hostName, timeout, useIcmp, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest traceRoute(string hostName, int timeout, bool useIcmp, AsyncRpcResponse<TraceRouteResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["hostName"] = hostName;
        _parameters["timeout"] = timeout;
        _parameters["useIcmp"] = useIcmp;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("traceRoute", _parameters,
        _result => {
          try {
            var _ret = new TraceRouteResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.results = new System.Collections.Generic.List<string>(_result["results"].AsJsonArray.Select(
              _value => (string)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ListTcpConnectionsResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<string> results;
    }

    public ListTcpConnectionsResult listTcpConnections() {
      JsonObject _parameters = null;
      var _result = RpcCall("listTcpConnections", _parameters);
      var _ret = new ListTcpConnectionsResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.results = new System.Collections.Generic.List<string>(_result["results"].AsJsonArray.Select(
        _value => (string)_value));
      return _ret;
    }

    public AsyncRequest listTcpConnections(AsyncRpcResponse<ListTcpConnectionsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return listTcpConnections(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest listTcpConnections(AsyncRpcResponse<ListTcpConnectionsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("listTcpConnections", _parameters,
        _result => {
          try {
            var _ret = new ListTcpConnectionsResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.results = new System.Collections.Generic.List<string>(_result["results"].AsJsonArray.Select(
              _value => (string)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ListTcpUdpListenSocketsResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<string> results;
    }

    public ListTcpUdpListenSocketsResult listTcpUdpListenSockets() {
      JsonObject _parameters = null;
      var _result = RpcCall("listTcpUdpListenSockets", _parameters);
      var _ret = new ListTcpUdpListenSocketsResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.results = new System.Collections.Generic.List<string>(_result["results"].AsJsonArray.Select(
        _value => (string)_value));
      return _ret;
    }

    public AsyncRequest listTcpUdpListenSockets(AsyncRpcResponse<ListTcpUdpListenSocketsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return listTcpUdpListenSockets(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest listTcpUdpListenSockets(AsyncRpcResponse<ListTcpUdpListenSocketsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("listTcpUdpListenSockets", _parameters,
        _result => {
          try {
            var _ret = new ListTcpUdpListenSocketsResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.results = new System.Collections.Generic.List<string>(_result["results"].AsJsonArray.Select(
              _value => (string)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ResolveHostNameResult {
      public System.Collections.Generic.IEnumerable<string> results;
    }

    public ResolveHostNameResult resolveHostName(string hostName) {
      var _parameters = new LightJson.JsonObject();
      _parameters["hostName"] = hostName;

      var _result = RpcCall("resolveHostName", _parameters);
      var _ret = new ResolveHostNameResult();
      _ret.results = new System.Collections.Generic.List<string>(_result["results"].AsJsonArray.Select(
        _value => (string)_value));
      return _ret;
    }

    public AsyncRequest resolveHostName(string hostName, AsyncRpcResponse<ResolveHostNameResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return resolveHostName(hostName, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest resolveHostName(string hostName, AsyncRpcResponse<ResolveHostNameResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["hostName"] = hostName;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("resolveHostName", _parameters,
        _result => {
          try {
            var _ret = new ResolveHostNameResult();
            _ret.results = new System.Collections.Generic.List<string>(_result["results"].AsJsonArray.Select(
              _value => (string)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
