// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Net.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.net {

  public class EapAuthSettings_2_0_0 : ICloneable {
    public object Clone() {
      EapAuthSettings_2_0_0 copy = new EapAuthSettings_2_0_0();
      copy.identity = this.identity;
      copy.password = this.password;
      copy.clearPassword = this.clearPassword;
      copy.outerMethod = this.outerMethod;
      copy.innerMethod = this.innerMethod;
      copy.caCertChain = this.caCertChain;
      copy.forceTrustedCert = this.forceTrustedCert;
      copy.allowOffTimeRangeCerts = this.allowOffTimeRangeCerts;
      copy.allowNotYetValidCertsIfTimeBeforeBuild = this.allowNotYetValidCertsIfTimeBeforeBuild;
      copy.authServerName = this.authServerName;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["identity"] = this.identity;
      json["password"] = this.password;
      json["clearPassword"] = this.clearPassword;
      json["outerMethod"] = (int)this.outerMethod;
      json["innerMethod"] = (int)this.innerMethod;
      json["caCertChain"] = this.caCertChain;
      json["forceTrustedCert"] = this.forceTrustedCert;
      json["allowOffTimeRangeCerts"] = this.allowOffTimeRangeCerts;
      json["allowNotYetValidCertsIfTimeBeforeBuild"] = this.allowNotYetValidCertsIfTimeBeforeBuild;
      json["authServerName"] = this.authServerName;
      return json;
    }

    public static EapAuthSettings_2_0_0 Decode(LightJson.JsonObject json, Agent agent) {
      EapAuthSettings_2_0_0 inst = new EapAuthSettings_2_0_0();
      inst.identity = (string)json["identity"];
      inst.password = (string)json["password"];
      inst.clearPassword = (bool)json["clearPassword"];
      inst.outerMethod = (Com.Raritan.Idl.net.EapOuterAuthMethod)(int)json["outerMethod"];
      inst.innerMethod = (Com.Raritan.Idl.net.EapInnerAuthMethod)(int)json["innerMethod"];
      inst.caCertChain = (string)json["caCertChain"];
      inst.forceTrustedCert = (bool)json["forceTrustedCert"];
      inst.allowOffTimeRangeCerts = (bool)json["allowOffTimeRangeCerts"];
      inst.allowNotYetValidCertsIfTimeBeforeBuild = (bool)json["allowNotYetValidCertsIfTimeBeforeBuild"];
      inst.authServerName = (string)json["authServerName"];
      return inst;
    }

    public string identity = "";
    public string password = "";
    public bool clearPassword = false;
    public Com.Raritan.Idl.net.EapOuterAuthMethod outerMethod = Com.Raritan.Idl.net.EapOuterAuthMethod.PEAP;
    public Com.Raritan.Idl.net.EapInnerAuthMethod innerMethod = Com.Raritan.Idl.net.EapInnerAuthMethod.MSCHAPv2;
    public string caCertChain = "";
    public bool forceTrustedCert = false;
    public bool allowOffTimeRangeCerts = false;
    public bool allowNotYetValidCertsIfTimeBeforeBuild = false;
    public string authServerName = "";
  }
}
