// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Pdu.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.pdumodel {
  public class Pdu_4_1_2 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.Pdu:4.1.2", null);

    public Pdu_4_1_2(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Pdu_4_1_2(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Pdu_4_1_2 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Pdu_4_1_2(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_INVALID_PARAM = 1;

    public class MetaData : ICloneable {
      public object Clone() {
        MetaData copy = new MetaData();
        copy.nameplate = this.nameplate;
        copy.ctrlBoardSerial = this.ctrlBoardSerial;
        copy.hwRevision = this.hwRevision;
        copy.fwRevision = this.fwRevision;
        copy.macAddress = this.macAddress;
        copy.hasSwitchableOutlets = this.hasSwitchableOutlets;
        copy.hasMeteredOutlets = this.hasMeteredOutlets;
        copy.hasLatchingOutletRelays = this.hasLatchingOutletRelays;
        copy.isInlineMeter = this.isInlineMeter;
        copy.isEnergyPulseSupported = this.isEnergyPulseSupported;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["nameplate"] = this.nameplate.Encode();
        json["ctrlBoardSerial"] = this.ctrlBoardSerial;
        json["hwRevision"] = this.hwRevision;
        json["fwRevision"] = this.fwRevision;
        json["macAddress"] = this.macAddress;
        json["hasSwitchableOutlets"] = this.hasSwitchableOutlets;
        json["hasMeteredOutlets"] = this.hasMeteredOutlets;
        json["hasLatchingOutletRelays"] = this.hasLatchingOutletRelays;
        json["isInlineMeter"] = this.isInlineMeter;
        json["isEnergyPulseSupported"] = this.isEnergyPulseSupported;
        return json;
      }

      public static MetaData Decode(LightJson.JsonObject json, Agent agent) {
        MetaData inst = new MetaData();
        inst.nameplate = Com.Raritan.Idl.pdumodel.Nameplate.Decode(json["nameplate"], agent);
        inst.ctrlBoardSerial = (string)json["ctrlBoardSerial"];
        inst.hwRevision = (string)json["hwRevision"];
        inst.fwRevision = (string)json["fwRevision"];
        inst.macAddress = (string)json["macAddress"];
        inst.hasSwitchableOutlets = (bool)json["hasSwitchableOutlets"];
        inst.hasMeteredOutlets = (bool)json["hasMeteredOutlets"];
        inst.hasLatchingOutletRelays = (bool)json["hasLatchingOutletRelays"];
        inst.isInlineMeter = (bool)json["isInlineMeter"];
        inst.isEnergyPulseSupported = (bool)json["isEnergyPulseSupported"];
        return inst;
      }

      public Com.Raritan.Idl.pdumodel.Nameplate nameplate = new Com.Raritan.Idl.pdumodel.Nameplate();
      public string ctrlBoardSerial = "";
      public string hwRevision = "";
      public string fwRevision = "";
      public string macAddress = "";
      public bool hasSwitchableOutlets = false;
      public bool hasMeteredOutlets = false;
      public bool hasLatchingOutletRelays = false;
      public bool isInlineMeter = false;
      public bool isEnergyPulseSupported = false;
    }

    public class Sensors : ICloneable {
      public object Clone() {
        Sensors copy = new Sensors();
        copy.powerSupplyStatus = this.powerSupplyStatus;
        copy.activePower = this.activePower;
        copy.activeEnergy = this.activeEnergy;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["powerSupplyStatus"] = new JsonArray(this.powerSupplyStatus.Select(
          _value => (JsonValue)(_value != null ? _value.Encode() : JsonValue.Null)));
        json["activePower"] = this.activePower != null ? this.activePower.Encode() : JsonValue.Null;
        json["activeEnergy"] = this.activeEnergy != null ? this.activeEnergy.Encode() : JsonValue.Null;
        return json;
      }

      public static Sensors Decode(LightJson.JsonObject json, Agent agent) {
        Sensors inst = new Sensors();
        inst.powerSupplyStatus = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.StateSensor_4_0_2>(json["powerSupplyStatus"].AsJsonArray.Select(
          _value => Com.Raritan.Idl.sensors.StateSensor_4_0_2.StaticCast(ObjectProxy.Decode(_value, agent))));
        inst.activePower = Com.Raritan.Idl.sensors.NumericSensor_4_0_2.StaticCast(ObjectProxy.Decode(json["activePower"], agent));
        inst.activeEnergy = Com.Raritan.Idl.sensors.NumericSensor_4_0_2.StaticCast(ObjectProxy.Decode(json["activeEnergy"], agent));
        return inst;
      }

      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.sensors.StateSensor_4_0_2> powerSupplyStatus = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.StateSensor_4_0_2>();
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_2 activePower = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_2 activeEnergy = null;
    }

    public class Statistic : ICloneable {
      public object Clone() {
        Statistic copy = new Statistic();
        copy.cbStats = this.cbStats;
        copy.ctrlStats = this.ctrlStats;
        copy.outletStats = this.outletStats;
        copy.peripheralStats = this.peripheralStats;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["cbStats"] = new JsonArray(this.cbStats.Select(
          _value => (JsonValue)(_value.Encode())));
        json["ctrlStats"] = new JsonArray(this.ctrlStats.Select(
          _value => (JsonValue)(_value.Encode())));
        json["outletStats"] = new JsonArray(this.outletStats.Select(
          _value => (JsonValue)(_value.Encode())));
        json["peripheralStats"] = this.peripheralStats.Encode();
        return json;
      }

      public static Statistic Decode(LightJson.JsonObject json, Agent agent) {
        Statistic inst = new Statistic();
        inst.cbStats = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.CircuitBreakerStatistic>(json["cbStats"].AsJsonArray.Select(
          _value => Com.Raritan.Idl.pdumodel.CircuitBreakerStatistic.Decode(_value, agent)));
        inst.ctrlStats = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.CtrlStatistic>(json["ctrlStats"].AsJsonArray.Select(
          _value => Com.Raritan.Idl.pdumodel.CtrlStatistic.Decode(_value, agent)));
        inst.outletStats = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.OutletStatistic>(json["outletStats"].AsJsonArray.Select(
          _value => Com.Raritan.Idl.pdumodel.OutletStatistic.Decode(_value, agent)));
        inst.peripheralStats = Com.Raritan.Idl.peripheral.DeviceManager_3_0_0.Statistics.Decode(json["peripheralStats"], agent);
        return inst;
      }

      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.CircuitBreakerStatistic> cbStats = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.CircuitBreakerStatistic>();
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.CtrlStatistic> ctrlStats = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.CtrlStatistic>();
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.OutletStatistic> outletStats = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.OutletStatistic>();
      public Com.Raritan.Idl.peripheral.DeviceManager_3_0_0.Statistics peripheralStats = new Com.Raritan.Idl.peripheral.DeviceManager_3_0_0.Statistics();
    }

    public enum StartupState {
      SS_ON,
      SS_OFF,
      SS_LASTKNOWN,
    }

    public class Settings : ICloneable {
      public object Clone() {
        Settings copy = new Settings();
        copy.name = this.name;
        copy.startupState = this.startupState;
        copy.cycleDelay = this.cycleDelay;
        copy.inRushGuardDelay = this.inRushGuardDelay;
        copy.outletPowerStateSequence = this.outletPowerStateSequence;
        copy.powerOnDelay = this.powerOnDelay;
        copy.latchingRelays = this.latchingRelays;
        copy.energyPulseEnabled = this.energyPulseEnabled;
        copy.energyPulsesPerKWh = this.energyPulsesPerKWh;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["name"] = this.name;
        json["startupState"] = (int)this.startupState;
        json["cycleDelay"] = this.cycleDelay;
        json["inRushGuardDelay"] = this.inRushGuardDelay;
        json["outletPowerStateSequence"] = new JsonArray(this.outletPowerStateSequence.Select(
          _value => (JsonValue)(_value)));
        json["powerOnDelay"] = this.powerOnDelay;
        json["latchingRelays"] = this.latchingRelays;
        json["energyPulseEnabled"] = this.energyPulseEnabled;
        json["energyPulsesPerKWh"] = this.energyPulsesPerKWh;
        return json;
      }

      public static Settings Decode(LightJson.JsonObject json, Agent agent) {
        Settings inst = new Settings();
        inst.name = (string)json["name"];
        inst.startupState = (Com.Raritan.Idl.pdumodel.Pdu_4_1_2.StartupState)(int)json["startupState"];
        inst.cycleDelay = (int)json["cycleDelay"];
        inst.inRushGuardDelay = (int)json["inRushGuardDelay"];
        inst.outletPowerStateSequence = new System.Collections.Generic.List<int>(json["outletPowerStateSequence"].AsJsonArray.Select(
          _value => (int)_value));
        inst.powerOnDelay = (int)json["powerOnDelay"];
        inst.latchingRelays = (bool)json["latchingRelays"];
        inst.energyPulseEnabled = (bool)json["energyPulseEnabled"];
        inst.energyPulsesPerKWh = (int)json["energyPulsesPerKWh"];
        return inst;
      }

      public string name = "";
      public Com.Raritan.Idl.pdumodel.Pdu_4_1_2.StartupState startupState = Com.Raritan.Idl.pdumodel.Pdu_4_1_2.StartupState.SS_ON;
      public int cycleDelay = 0;
      public int inRushGuardDelay = 0;
      public System.Collections.Generic.IEnumerable<int> outletPowerStateSequence = new System.Collections.Generic.List<int>();
      public int powerOnDelay = 0;
      public bool latchingRelays = false;
      public bool energyPulseEnabled = false;
      public int energyPulsesPerKWh = 0;
    }

    public class OutletSequenceState : ICloneable {
      public object Clone() {
        OutletSequenceState copy = new OutletSequenceState();
        copy.sequenceRunning = this.sequenceRunning;
        copy.nextOutletToSwitch = this.nextOutletToSwitch;
        copy.timeUntilNextSwitch = this.timeUntilNextSwitch;
        copy.outletsRemaining = this.outletsRemaining;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["sequenceRunning"] = this.sequenceRunning;
        json["nextOutletToSwitch"] = this.nextOutletToSwitch;
        json["timeUntilNextSwitch"] = this.timeUntilNextSwitch;
        json["outletsRemaining"] = this.outletsRemaining;
        return json;
      }

      public static OutletSequenceState Decode(LightJson.JsonObject json, Agent agent) {
        OutletSequenceState inst = new OutletSequenceState();
        inst.sequenceRunning = (bool)json["sequenceRunning"];
        inst.nextOutletToSwitch = (int)json["nextOutletToSwitch"];
        inst.timeUntilNextSwitch = (int)json["timeUntilNextSwitch"];
        inst.outletsRemaining = (int)json["outletsRemaining"];
        return inst;
      }

      public bool sequenceRunning = false;
      public int nextOutletToSwitch = 0;
      public int timeUntilNextSwitch = 0;
      public int outletsRemaining = 0;
    }

    public class SettingsChangedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.Pdu_4_1_2.SettingsChangedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public Com.Raritan.Idl.pdumodel.Pdu_4_1_2.Settings oldSettings = new Com.Raritan.Idl.pdumodel.Pdu_4_1_2.Settings();
      public Com.Raritan.Idl.pdumodel.Pdu_4_1_2.Settings newSettings = new Com.Raritan.Idl.pdumodel.Pdu_4_1_2.Settings();
    }

    public class LoadSheddingModeChangedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.Pdu_4_1_2.LoadSheddingModeChangedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public bool enabled = false;
    }

    public class OutletSequenceStateChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.Pdu_4_1_2.OutletSequenceStateChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.pdumodel.Pdu_4_1_2.OutletSequenceState newState = new Com.Raritan.Idl.pdumodel.Pdu_4_1_2.OutletSequenceState();
    }

    public class GetNameplateResult {
      public Com.Raritan.Idl.pdumodel.Nameplate _ret_;
    }

    public GetNameplateResult getNameplate() {
      JsonObject _parameters = null;
      var _result = RpcCall("getNameplate", _parameters);
      var _ret = new GetNameplateResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.Nameplate.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getNameplate(AsyncRpcResponse<GetNameplateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getNameplate(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getNameplate(AsyncRpcResponse<GetNameplateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getNameplate", _parameters,
        _result => {
          try {
            var _ret = new GetNameplateResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.Nameplate.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetMetaDataResult {
      public Com.Raritan.Idl.pdumodel.Pdu_4_1_2.MetaData _ret_;
    }

    public GetMetaDataResult getMetaData() {
      JsonObject _parameters = null;
      var _result = RpcCall("getMetaData", _parameters);
      var _ret = new GetMetaDataResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.Pdu_4_1_2.MetaData.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getMetaData(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getMetaData", _parameters,
        _result => {
          try {
            var _ret = new GetMetaDataResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.Pdu_4_1_2.MetaData.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSensorsResult {
      public Com.Raritan.Idl.pdumodel.Pdu_4_1_2.Sensors _ret_;
    }

    public GetSensorsResult getSensors() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSensors", _parameters);
      var _ret = new GetSensorsResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.Pdu_4_1_2.Sensors.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSensors(AsyncRpcResponse<GetSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSensors(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSensors(AsyncRpcResponse<GetSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSensors", _parameters,
        _result => {
          try {
            var _ret = new GetSensorsResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.Pdu_4_1_2.Sensors.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSensorLoggerResult {
      public Com.Raritan.Idl.sensors.Logger_2_1_5 _ret_;
    }

    public GetSensorLoggerResult getSensorLogger() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSensorLogger", _parameters);
      var _ret = new GetSensorLoggerResult();
      _ret._ret_ = Com.Raritan.Idl.sensors.Logger_2_1_5.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
      return _ret;
    }

    public AsyncRequest getSensorLogger(AsyncRpcResponse<GetSensorLoggerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSensorLogger(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSensorLogger(AsyncRpcResponse<GetSensorLoggerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSensorLogger", _parameters,
        _result => {
          try {
            var _ret = new GetSensorLoggerResult();
            _ret._ret_ = Com.Raritan.Idl.sensors.Logger_2_1_5.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetControllersResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.Controller_4_0_0> _ret_;
    }

    public GetControllersResult getControllers() {
      JsonObject _parameters = null;
      var _result = RpcCall("getControllers", _parameters);
      var _ret = new GetControllersResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Controller_4_0_0>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.pdumodel.Controller_4_0_0.StaticCast(ObjectProxy.Decode(_value, agent))));
      return _ret;
    }

    public AsyncRequest getControllers(AsyncRpcResponse<GetControllersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getControllers(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getControllers(AsyncRpcResponse<GetControllersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getControllers", _parameters,
        _result => {
          try {
            var _ret = new GetControllersResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Controller_4_0_0>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.pdumodel.Controller_4_0_0.StaticCast(ObjectProxy.Decode(_value, agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetOutletsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.Outlet_2_1_1> _ret_;
    }

    public GetOutletsResult getOutlets() {
      JsonObject _parameters = null;
      var _result = RpcCall("getOutlets", _parameters);
      var _ret = new GetOutletsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Outlet_2_1_1>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.pdumodel.Outlet_2_1_1.StaticCast(ObjectProxy.Decode(_value, agent))));
      return _ret;
    }

    public AsyncRequest getOutlets(AsyncRpcResponse<GetOutletsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getOutlets(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getOutlets(AsyncRpcResponse<GetOutletsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getOutlets", _parameters,
        _result => {
          try {
            var _ret = new GetOutletsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Outlet_2_1_1>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.pdumodel.Outlet_2_1_1.StaticCast(ObjectProxy.Decode(_value, agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetOverCurrentProtectorsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_1> _ret_;
    }

    public GetOverCurrentProtectorsResult getOverCurrentProtectors() {
      JsonObject _parameters = null;
      var _result = RpcCall("getOverCurrentProtectors", _parameters);
      var _ret = new GetOverCurrentProtectorsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_1>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_1.StaticCast(ObjectProxy.Decode(_value, agent))));
      return _ret;
    }

    public AsyncRequest getOverCurrentProtectors(AsyncRpcResponse<GetOverCurrentProtectorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getOverCurrentProtectors(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getOverCurrentProtectors(AsyncRpcResponse<GetOverCurrentProtectorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getOverCurrentProtectors", _parameters,
        _result => {
          try {
            var _ret = new GetOverCurrentProtectorsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_1>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_1.StaticCast(ObjectProxy.Decode(_value, agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetInletsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.Inlet_2_0_1> _ret_;
    }

    public GetInletsResult getInlets() {
      JsonObject _parameters = null;
      var _result = RpcCall("getInlets", _parameters);
      var _ret = new GetInletsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Inlet_2_0_1>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.pdumodel.Inlet_2_0_1.StaticCast(ObjectProxy.Decode(_value, agent))));
      return _ret;
    }

    public AsyncRequest getInlets(AsyncRpcResponse<GetInletsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getInlets(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getInlets(AsyncRpcResponse<GetInletsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getInlets", _parameters,
        _result => {
          try {
            var _ret = new GetInletsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Inlet_2_0_1>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.pdumodel.Inlet_2_0_1.StaticCast(ObjectProxy.Decode(_value, agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetTransferSwitchesResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.TransferSwitch_4_0_2> _ret_;
    }

    public GetTransferSwitchesResult getTransferSwitches() {
      JsonObject _parameters = null;
      var _result = RpcCall("getTransferSwitches", _parameters);
      var _ret = new GetTransferSwitchesResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.TransferSwitch_4_0_2>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.pdumodel.TransferSwitch_4_0_2.StaticCast(ObjectProxy.Decode(_value, agent))));
      return _ret;
    }

    public AsyncRequest getTransferSwitches(AsyncRpcResponse<GetTransferSwitchesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getTransferSwitches(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getTransferSwitches(AsyncRpcResponse<GetTransferSwitchesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getTransferSwitches", _parameters,
        _result => {
          try {
            var _ret = new GetTransferSwitchesResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.TransferSwitch_4_0_2>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.pdumodel.TransferSwitch_4_0_2.StaticCast(ObjectProxy.Decode(_value, agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetPeripheralDeviceManagerResult {
      public Com.Raritan.Idl.peripheral.DeviceManager_3_0_0 _ret_;
    }

    public GetPeripheralDeviceManagerResult getPeripheralDeviceManager() {
      JsonObject _parameters = null;
      var _result = RpcCall("getPeripheralDeviceManager", _parameters);
      var _ret = new GetPeripheralDeviceManagerResult();
      _ret._ret_ = Com.Raritan.Idl.peripheral.DeviceManager_3_0_0.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
      return _ret;
    }

    public AsyncRequest getPeripheralDeviceManager(AsyncRpcResponse<GetPeripheralDeviceManagerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getPeripheralDeviceManager(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getPeripheralDeviceManager(AsyncRpcResponse<GetPeripheralDeviceManagerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getPeripheralDeviceManager", _parameters,
        _result => {
          try {
            var _ret = new GetPeripheralDeviceManagerResult();
            _ret._ret_ = Com.Raritan.Idl.peripheral.DeviceManager_3_0_0.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetBeeperResult {
      public Com.Raritan.Idl.hmi.InternalBeeper_2_0_0 _ret_;
    }

    public GetBeeperResult getBeeper() {
      JsonObject _parameters = null;
      var _result = RpcCall("getBeeper", _parameters);
      var _ret = new GetBeeperResult();
      _ret._ret_ = Com.Raritan.Idl.hmi.InternalBeeper_2_0_0.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
      return _ret;
    }

    public AsyncRequest getBeeper(AsyncRpcResponse<GetBeeperResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getBeeper(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getBeeper(AsyncRpcResponse<GetBeeperResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getBeeper", _parameters,
        _result => {
          try {
            var _ret = new GetBeeperResult();
            _ret._ret_ = Com.Raritan.Idl.hmi.InternalBeeper_2_0_0.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSettingsResult {
      public Com.Raritan.Idl.pdumodel.Pdu_4_1_2.Settings _ret_;
    }

    public GetSettingsResult getSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSettings", _parameters);
      var _ret = new GetSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.Pdu_4_1_2.Settings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSettings", _parameters,
        _result => {
          try {
            var _ret = new GetSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.Pdu_4_1_2.Settings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class IsLoadSheddingActiveResult {
      public bool _ret_;
    }

    public IsLoadSheddingActiveResult isLoadSheddingActive() {
      JsonObject _parameters = null;
      var _result = RpcCall("isLoadSheddingActive", _parameters);
      var _ret = new IsLoadSheddingActiveResult();
      _ret._ret_ = (bool)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest isLoadSheddingActive(AsyncRpcResponse<IsLoadSheddingActiveResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return isLoadSheddingActive(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest isLoadSheddingActive(AsyncRpcResponse<IsLoadSheddingActiveResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("isLoadSheddingActive", _parameters,
        _result => {
          try {
            var _ret = new IsLoadSheddingActiveResult();
            _ret._ret_ = (bool)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSettingsResult {
      public int _ret_;
    }

    public SetSettingsResult setSettings(Com.Raritan.Idl.pdumodel.Pdu_4_1_2.Settings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setSettings", _parameters);
      var _ret = new SetSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.pdumodel.Pdu_4_1_2.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.pdumodel.Pdu_4_1_2.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSettings", _parameters,
        _result => {
          try {
            var _ret = new SetSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetLoadSheddingActiveResult {
    }

    public SetLoadSheddingActiveResult setLoadSheddingActive(bool active) {
      var _parameters = new LightJson.JsonObject();
      _parameters["active"] = active;

      var _result = RpcCall("setLoadSheddingActive", _parameters);
      var _ret = new SetLoadSheddingActiveResult();
      return _ret;
    }

    public AsyncRequest setLoadSheddingActive(bool active, AsyncRpcResponse<SetLoadSheddingActiveResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setLoadSheddingActive(active, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setLoadSheddingActive(bool active, AsyncRpcResponse<SetLoadSheddingActiveResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["active"] = active;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setLoadSheddingActive", _parameters,
        _result => {
          try {
            var _ret = new SetLoadSheddingActiveResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetFeaturePortsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.portsmodel.Port_2_0_1> _ret_;
    }

    public GetFeaturePortsResult getFeaturePorts() {
      JsonObject _parameters = null;
      var _result = RpcCall("getFeaturePorts", _parameters);
      var _ret = new GetFeaturePortsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.portsmodel.Port_2_0_1>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.portsmodel.Port_2_0_1.StaticCast(ObjectProxy.Decode(_value, agent))));
      return _ret;
    }

    public AsyncRequest getFeaturePorts(AsyncRpcResponse<GetFeaturePortsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getFeaturePorts(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getFeaturePorts(AsyncRpcResponse<GetFeaturePortsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getFeaturePorts", _parameters,
        _result => {
          try {
            var _ret = new GetFeaturePortsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.portsmodel.Port_2_0_1>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.portsmodel.Port_2_0_1.StaticCast(ObjectProxy.Decode(_value, agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class EnterRS485ConfigModeAndAssignCtrlBoardAddressResult {
      public int _ret_;
    }

    public EnterRS485ConfigModeAndAssignCtrlBoardAddressResult enterRS485ConfigModeAndAssignCtrlBoardAddress(int addr) {
      var _parameters = new LightJson.JsonObject();
      _parameters["addr"] = addr;

      var _result = RpcCall("enterRS485ConfigModeAndAssignCtrlBoardAddress", _parameters);
      var _ret = new EnterRS485ConfigModeAndAssignCtrlBoardAddressResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest enterRS485ConfigModeAndAssignCtrlBoardAddress(int addr, AsyncRpcResponse<EnterRS485ConfigModeAndAssignCtrlBoardAddressResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return enterRS485ConfigModeAndAssignCtrlBoardAddress(addr, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest enterRS485ConfigModeAndAssignCtrlBoardAddress(int addr, AsyncRpcResponse<EnterRS485ConfigModeAndAssignCtrlBoardAddressResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["addr"] = addr;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("enterRS485ConfigModeAndAssignCtrlBoardAddress", _parameters,
        _result => {
          try {
            var _ret = new EnterRS485ConfigModeAndAssignCtrlBoardAddressResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class EnterRS485ConfigModeAndAssignSCBoardAddressResult {
      public int _ret_;
    }

    public EnterRS485ConfigModeAndAssignSCBoardAddressResult enterRS485ConfigModeAndAssignSCBoardAddress(int deviceId, int addr) {
      var _parameters = new LightJson.JsonObject();
      _parameters["deviceId"] = deviceId;
      _parameters["addr"] = addr;

      var _result = RpcCall("enterRS485ConfigModeAndAssignSCBoardAddress", _parameters);
      var _ret = new EnterRS485ConfigModeAndAssignSCBoardAddressResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest enterRS485ConfigModeAndAssignSCBoardAddress(int deviceId, int addr, AsyncRpcResponse<EnterRS485ConfigModeAndAssignSCBoardAddressResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return enterRS485ConfigModeAndAssignSCBoardAddress(deviceId, addr, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest enterRS485ConfigModeAndAssignSCBoardAddress(int deviceId, int addr, AsyncRpcResponse<EnterRS485ConfigModeAndAssignSCBoardAddressResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["deviceId"] = deviceId;
        _parameters["addr"] = addr;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("enterRS485ConfigModeAndAssignSCBoardAddress", _parameters,
        _result => {
          try {
            var _ret = new EnterRS485ConfigModeAndAssignSCBoardAddressResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class LeaveRS485ConfigModeResult {
      public int _ret_;
    }

    public LeaveRS485ConfigModeResult leaveRS485ConfigMode() {
      JsonObject _parameters = null;
      var _result = RpcCall("leaveRS485ConfigMode", _parameters);
      var _ret = new LeaveRS485ConfigModeResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest leaveRS485ConfigMode(AsyncRpcResponse<LeaveRS485ConfigModeResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return leaveRS485ConfigMode(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest leaveRS485ConfigMode(AsyncRpcResponse<LeaveRS485ConfigModeResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("leaveRS485ConfigMode", _parameters,
        _result => {
          try {
            var _ret = new LeaveRS485ConfigModeResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetAllOutletPowerStatesResult {
      public int _ret_;
    }

    public SetAllOutletPowerStatesResult setAllOutletPowerStates(Com.Raritan.Idl.pdumodel.Outlet_2_1_1.PowerState pstate) {
      var _parameters = new LightJson.JsonObject();
      _parameters["pstate"] = (int)pstate;

      var _result = RpcCall("setAllOutletPowerStates", _parameters);
      var _ret = new SetAllOutletPowerStatesResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setAllOutletPowerStates(Com.Raritan.Idl.pdumodel.Outlet_2_1_1.PowerState pstate, AsyncRpcResponse<SetAllOutletPowerStatesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setAllOutletPowerStates(pstate, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setAllOutletPowerStates(Com.Raritan.Idl.pdumodel.Outlet_2_1_1.PowerState pstate, AsyncRpcResponse<SetAllOutletPowerStatesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["pstate"] = (int)pstate;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setAllOutletPowerStates", _parameters,
        _result => {
          try {
            var _ret = new SetAllOutletPowerStatesResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetMultipleOutletPowerStatesResult {
      public int _ret_;
    }

    public SetMultipleOutletPowerStatesResult setMultipleOutletPowerStates(System.Collections.Generic.IEnumerable<int> outletNumbers, Com.Raritan.Idl.pdumodel.Outlet_2_1_1.PowerState state, bool respectSequence) {
      var _parameters = new LightJson.JsonObject();
      _parameters["outletNumbers"] = new JsonArray(outletNumbers.Select(
        _value => (JsonValue)(_value)));
      _parameters["state"] = (int)state;
      _parameters["respectSequence"] = respectSequence;

      var _result = RpcCall("setMultipleOutletPowerStates", _parameters);
      var _ret = new SetMultipleOutletPowerStatesResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setMultipleOutletPowerStates(System.Collections.Generic.IEnumerable<int> outletNumbers, Com.Raritan.Idl.pdumodel.Outlet_2_1_1.PowerState state, bool respectSequence, AsyncRpcResponse<SetMultipleOutletPowerStatesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setMultipleOutletPowerStates(outletNumbers, state, respectSequence, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setMultipleOutletPowerStates(System.Collections.Generic.IEnumerable<int> outletNumbers, Com.Raritan.Idl.pdumodel.Outlet_2_1_1.PowerState state, bool respectSequence, AsyncRpcResponse<SetMultipleOutletPowerStatesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["outletNumbers"] = new JsonArray(outletNumbers.Select(
          _value => (JsonValue)(_value)));
        _parameters["state"] = (int)state;
        _parameters["respectSequence"] = respectSequence;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setMultipleOutletPowerStates", _parameters,
        _result => {
          try {
            var _ret = new SetMultipleOutletPowerStatesResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class CycleAllOutletPowerStatesResult {
      public int _ret_;
    }

    public CycleAllOutletPowerStatesResult cycleAllOutletPowerStates() {
      JsonObject _parameters = null;
      var _result = RpcCall("cycleAllOutletPowerStates", _parameters);
      var _ret = new CycleAllOutletPowerStatesResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest cycleAllOutletPowerStates(AsyncRpcResponse<CycleAllOutletPowerStatesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return cycleAllOutletPowerStates(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest cycleAllOutletPowerStates(AsyncRpcResponse<CycleAllOutletPowerStatesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("cycleAllOutletPowerStates", _parameters,
        _result => {
          try {
            var _ret = new CycleAllOutletPowerStatesResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class CycleMultipleOutletPowerStatesResult {
      public int _ret_;
    }

    public CycleMultipleOutletPowerStatesResult cycleMultipleOutletPowerStates(System.Collections.Generic.IEnumerable<int> outletNumbers, bool respectSequence) {
      var _parameters = new LightJson.JsonObject();
      _parameters["outletNumbers"] = new JsonArray(outletNumbers.Select(
        _value => (JsonValue)(_value)));
      _parameters["respectSequence"] = respectSequence;

      var _result = RpcCall("cycleMultipleOutletPowerStates", _parameters);
      var _ret = new CycleMultipleOutletPowerStatesResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest cycleMultipleOutletPowerStates(System.Collections.Generic.IEnumerable<int> outletNumbers, bool respectSequence, AsyncRpcResponse<CycleMultipleOutletPowerStatesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return cycleMultipleOutletPowerStates(outletNumbers, respectSequence, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest cycleMultipleOutletPowerStates(System.Collections.Generic.IEnumerable<int> outletNumbers, bool respectSequence, AsyncRpcResponse<CycleMultipleOutletPowerStatesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["outletNumbers"] = new JsonArray(outletNumbers.Select(
          _value => (JsonValue)(_value)));
        _parameters["respectSequence"] = respectSequence;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("cycleMultipleOutletPowerStates", _parameters,
        _result => {
          try {
            var _ret = new CycleMultipleOutletPowerStatesResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetStatisticResult {
      public Com.Raritan.Idl.pdumodel.Pdu_4_1_2.Statistic _ret_;
    }

    public GetStatisticResult getStatistic() {
      JsonObject _parameters = null;
      var _result = RpcCall("getStatistic", _parameters);
      var _ret = new GetStatisticResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.Pdu_4_1_2.Statistic.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getStatistic(AsyncRpcResponse<GetStatisticResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getStatistic(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getStatistic(AsyncRpcResponse<GetStatisticResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getStatistic", _parameters,
        _result => {
          try {
            var _ret = new GetStatisticResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.Pdu_4_1_2.Statistic.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetOutletSequenceStateResult {
      public Com.Raritan.Idl.pdumodel.Pdu_4_1_2.OutletSequenceState _ret_;
    }

    public GetOutletSequenceStateResult getOutletSequenceState() {
      JsonObject _parameters = null;
      var _result = RpcCall("getOutletSequenceState", _parameters);
      var _ret = new GetOutletSequenceStateResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.Pdu_4_1_2.OutletSequenceState.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getOutletSequenceState(AsyncRpcResponse<GetOutletSequenceStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getOutletSequenceState(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getOutletSequenceState(AsyncRpcResponse<GetOutletSequenceStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getOutletSequenceState", _parameters,
        _result => {
          try {
            var _ret = new GetOutletSequenceStateResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.Pdu_4_1_2.OutletSequenceState.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class CancelOutletSequenceResult {
    }

    public CancelOutletSequenceResult cancelOutletSequence() {
      JsonObject _parameters = null;
      var _result = RpcCall("cancelOutletSequence", _parameters);
      var _ret = new CancelOutletSequenceResult();
      return _ret;
    }

    public AsyncRequest cancelOutletSequence(AsyncRpcResponse<CancelOutletSequenceResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return cancelOutletSequence(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest cancelOutletSequence(AsyncRpcResponse<CancelOutletSequenceResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("cancelOutletSequence", _parameters,
        _result => {
          try {
            var _ret = new CancelOutletSequenceResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
