// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ExternalSensorManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.sensors {
  public class ExternalSensorManager : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("sensors.ExternalSensorManager:1.0.0", null);

    public ExternalSensorManager(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public ExternalSensorManager(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new ExternalSensorManager StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new ExternalSensorManager(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_INVALID_PARAMS = 1;

    public const int ERR_NOT_SUPPORTED = 2;

    public enum Events {
      EVT_KEY_SETTINGS_CHANGED,
      EVT_KEY_EXTERNALSENSOR_ADDED,
      EVT_KEY_EXTERNALSENSOR_REMOVED,
    }

    public enum ZCoordMode {
      RACKUNITS,
      FREEFORM,
    }

    public class Settings : ICloneable {
      public object Clone() {
        Settings copy = new Settings();
        copy.zCoordMode = this.zCoordMode;
        copy.deviceAltitude = this.deviceAltitude;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["zCoordMode"] = (int)this.zCoordMode;
        json["deviceAltitude"] = this.deviceAltitude;
        return json;
      }

      public static Settings Decode(LightJson.JsonObject json, Agent agent) {
        Settings inst = new Settings();
        inst.zCoordMode = (Com.Raritan.Idl.sensors.ExternalSensorManager.ZCoordMode)(int)json["zCoordMode"];
        inst.deviceAltitude = (float)json["deviceAltitude"];
        return inst;
      }

      public Com.Raritan.Idl.sensors.ExternalSensorManager.ZCoordMode zCoordMode = Com.Raritan.Idl.sensors.ExternalSensorManager.ZCoordMode.RACKUNITS;
      public float deviceAltitude = 0.0f;
    }

    public class MetaData : ICloneable {
      public object Clone() {
        MetaData copy = new MetaData();
        copy.onboardSensors = this.onboardSensors;
        copy.portCount = this.portCount;
        copy.isPowControlled = this.isPowControlled;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["onboardSensors"] = this.onboardSensors;
        json["portCount"] = this.portCount;
        json["isPowControlled"] = this.isPowControlled;
        return json;
      }

      public static MetaData Decode(LightJson.JsonObject json, Agent agent) {
        MetaData inst = new MetaData();
        inst.onboardSensors = (bool)json["onboardSensors"];
        inst.portCount = (int)json["portCount"];
        inst.isPowControlled = (bool)json["isPowControlled"];
        return inst;
      }

      public bool onboardSensors = false;
      public int portCount = 0;
      public bool isPowControlled = false;
    }

    public class GetExternalSensorSlotsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.sensors.ExternalSensorSlot> _ret_;
    }

    public GetExternalSensorSlotsResult getExternalSensorSlots() {
      JsonObject _parameters = null;
      var _result = RpcCall("getExternalSensorSlots", _parameters);
      var _ret = new GetExternalSensorSlotsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.ExternalSensorSlot>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.sensors.ExternalSensorSlot.StaticCast(ObjectProxy.Decode(_value, agent))));
      return _ret;
    }

    public AsyncRequest getExternalSensorSlots(AsyncRpcResponse<GetExternalSensorSlotsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getExternalSensorSlots(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getExternalSensorSlots(AsyncRpcResponse<GetExternalSensorSlotsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getExternalSensorSlots", _parameters,
        _result => {
          try {
            var _ret = new GetExternalSensorSlotsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.ExternalSensorSlot>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.sensors.ExternalSensorSlot.StaticCast(ObjectProxy.Decode(_value, agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetDiscoveredExternalSensorsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.sensors.ExternalSensorData> _ret_;
    }

    public GetDiscoveredExternalSensorsResult getDiscoveredExternalSensors() {
      JsonObject _parameters = null;
      var _result = RpcCall("getDiscoveredExternalSensors", _parameters);
      var _ret = new GetDiscoveredExternalSensorsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.ExternalSensorData>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.sensors.ExternalSensorData.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getDiscoveredExternalSensors(AsyncRpcResponse<GetDiscoveredExternalSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getDiscoveredExternalSensors(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getDiscoveredExternalSensors(AsyncRpcResponse<GetDiscoveredExternalSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getDiscoveredExternalSensors", _parameters,
        _result => {
          try {
            var _ret = new GetDiscoveredExternalSensorsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.sensors.ExternalSensorData>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.sensors.ExternalSensorData.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSettingsResult {
      public Com.Raritan.Idl.sensors.ExternalSensorManager.Settings _ret_;
    }

    public GetSettingsResult getSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSettings", _parameters);
      var _ret = new GetSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.sensors.ExternalSensorManager.Settings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSettings", _parameters,
        _result => {
          try {
            var _ret = new GetSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.sensors.ExternalSensorManager.Settings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSettingsResult {
      public int _ret_;
    }

    public SetSettingsResult setSettings(Com.Raritan.Idl.sensors.ExternalSensorManager.Settings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setSettings", _parameters);
      var _ret = new SetSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.sensors.ExternalSensorManager.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.sensors.ExternalSensorManager.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSettings", _parameters,
        _result => {
          try {
            var _ret = new SetSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetMetaDataResult {
      public Com.Raritan.Idl.sensors.ExternalSensorManager.MetaData _ret_;
    }

    public GetMetaDataResult getMetaData() {
      JsonObject _parameters = null;
      var _result = RpcCall("getMetaData", _parameters);
      var _ret = new GetMetaDataResult();
      _ret._ret_ = Com.Raritan.Idl.sensors.ExternalSensorManager.MetaData.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getMetaData(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getMetaData", _parameters,
        _result => {
          try {
            var _ret = new GetMetaDataResult();
            _ret._ret_ = Com.Raritan.Idl.sensors.ExternalSensorManager.MetaData.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetPortPowerResult {
      public int _ret_;
    }

    public SetPortPowerResult setPortPower(int port, bool hasPower) {
      var _parameters = new LightJson.JsonObject();
      _parameters["port"] = port;
      _parameters["hasPower"] = hasPower;

      var _result = RpcCall("setPortPower", _parameters);
      var _ret = new SetPortPowerResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setPortPower(int port, bool hasPower, AsyncRpcResponse<SetPortPowerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setPortPower(port, hasPower, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setPortPower(int port, bool hasPower, AsyncRpcResponse<SetPortPowerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["port"] = port;
        _parameters["hasPower"] = hasPower;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setPortPower", _parameters,
        _result => {
          try {
            var _ret = new SetPortPowerResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetAllPortPowerResult {
      public int _ret_;
    }

    public SetAllPortPowerResult setAllPortPower(bool hasPower) {
      var _parameters = new LightJson.JsonObject();
      _parameters["hasPower"] = hasPower;

      var _result = RpcCall("setAllPortPower", _parameters);
      var _ret = new SetAllPortPowerResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setAllPortPower(bool hasPower, AsyncRpcResponse<SetAllPortPowerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setAllPortPower(hasPower, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setAllPortPower(bool hasPower, AsyncRpcResponse<SetAllPortPowerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["hasPower"] = hasPower;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setAllPortPower", _parameters,
        _result => {
          try {
            var _ret = new SetAllPortPowerResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
