// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from SerialPort.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.serial {
  public class SerialPort : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("serial.SerialPort:1.0.0", null);

    public SerialPort(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public SerialPort(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new SerialPort StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new SerialPort(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int SUCCESS = 0;

    public const int ERR_INVALID_VALUE = 1;

    public const int ERR_NO_MODEM = 2;

    public enum PortState {
      CONSOLE,
      ANALOGMODEM,
      GSMMODEM,
    }

    public enum BaudRate {
      BR1200,
      BR2400,
      BR4800,
      BR9600,
      BR19200,
      BR38400,
      BR57600,
      BR115200,
    }

    public class State : ICloneable {
      public object Clone() {
        State copy = new State();
        copy.state = this.state;
        copy.deviceName = this.deviceName;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["state"] = (int)this.state;
        json["deviceName"] = this.deviceName;
        return json;
      }

      public static State Decode(LightJson.JsonObject json, Agent agent) {
        State inst = new State();
        inst.state = (Com.Raritan.Idl.serial.SerialPort.PortState)(int)json["state"];
        inst.deviceName = (string)json["deviceName"];
        return inst;
      }

      public Com.Raritan.Idl.serial.SerialPort.PortState state = Com.Raritan.Idl.serial.SerialPort.PortState.CONSOLE;
      public string deviceName = "";
    }

    public class ConsoleSettings : ICloneable {
      public object Clone() {
        ConsoleSettings copy = new ConsoleSettings();
        copy.baudRate = this.baudRate;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["baudRate"] = (int)this.baudRate;
        return json;
      }

      public static ConsoleSettings Decode(LightJson.JsonObject json, Agent agent) {
        ConsoleSettings inst = new ConsoleSettings();
        inst.baudRate = (Com.Raritan.Idl.serial.SerialPort.BaudRate)(int)json["baudRate"];
        return inst;
      }

      public Com.Raritan.Idl.serial.SerialPort.BaudRate baudRate = Com.Raritan.Idl.serial.SerialPort.BaudRate.BR1200;
    }

    public class GetConsoleSettingsResult {
      public Com.Raritan.Idl.serial.SerialPort.ConsoleSettings _ret_;
    }

    public GetConsoleSettingsResult getConsoleSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getConsoleSettings", _parameters);
      var _ret = new GetConsoleSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.serial.SerialPort.ConsoleSettings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getConsoleSettings(AsyncRpcResponse<GetConsoleSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getConsoleSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getConsoleSettings(AsyncRpcResponse<GetConsoleSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getConsoleSettings", _parameters,
        _result => {
          try {
            var _ret = new GetConsoleSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.serial.SerialPort.ConsoleSettings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetConsoleSettingsResult {
      public int _ret_;
    }

    public SetConsoleSettingsResult setConsoleSettings(Com.Raritan.Idl.serial.SerialPort.ConsoleSettings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setConsoleSettings", _parameters);
      var _ret = new SetConsoleSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setConsoleSettings(Com.Raritan.Idl.serial.SerialPort.ConsoleSettings settings, AsyncRpcResponse<SetConsoleSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setConsoleSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setConsoleSettings(Com.Raritan.Idl.serial.SerialPort.ConsoleSettings settings, AsyncRpcResponse<SetConsoleSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setConsoleSettings", _parameters,
        _result => {
          try {
            var _ret = new SetConsoleSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetStateResult {
      public Com.Raritan.Idl.serial.SerialPort.State _ret_;
    }

    public GetStateResult getState() {
      JsonObject _parameters = null;
      var _result = RpcCall("getState", _parameters);
      var _ret = new GetStateResult();
      _ret._ret_ = Com.Raritan.Idl.serial.SerialPort.State.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getState(AsyncRpcResponse<GetStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getState(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getState(AsyncRpcResponse<GetStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getState", _parameters,
        _result => {
          try {
            var _ret = new GetStateResult();
            _ret._ret_ = Com.Raritan.Idl.serial.SerialPort.State.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetGsmModemResult {
      public int _ret_;
      public Com.Raritan.Idl.serial.GsmModem modem;
    }

    public GetGsmModemResult getGsmModem() {
      JsonObject _parameters = null;
      var _result = RpcCall("getGsmModem", _parameters);
      var _ret = new GetGsmModemResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.modem = Com.Raritan.Idl.serial.GsmModem.StaticCast(ObjectProxy.Decode(_result["modem"], agent));
      return _ret;
    }

    public AsyncRequest getGsmModem(AsyncRpcResponse<GetGsmModemResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getGsmModem(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getGsmModem(AsyncRpcResponse<GetGsmModemResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getGsmModem", _parameters,
        _result => {
          try {
            var _ret = new GetGsmModemResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.modem = Com.Raritan.Idl.serial.GsmModem.StaticCast(ObjectProxy.Decode(_result["modem"], agent));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
