// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from DoorAccessControl.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.smartlock {
  public class DoorAccessControl : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("smartlock.DoorAccessControl:1.0.0", null);

    public DoorAccessControl(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public DoorAccessControl(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new DoorAccessControl StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new DoorAccessControl(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_INVALID_SETTINGS = 1;

    public const int ERR_NO_SUCH_ID = 2;

    public const int ERR_MAX_RULES_REACHED = 3;

    public class AbsoluteTimeCondition : ICloneable {
      public object Clone() {
        AbsoluteTimeCondition copy = new AbsoluteTimeCondition();
        copy.enabled = this.enabled;
        copy.validFrom = this.validFrom;
        copy.validTill = this.validTill;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["enabled"] = this.enabled;
        json["validFrom"] = (this.validFrom.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        json["validTill"] = (this.validTill.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        return json;
      }

      public static AbsoluteTimeCondition Decode(LightJson.JsonObject json, Agent agent) {
        AbsoluteTimeCondition inst = new AbsoluteTimeCondition();
        inst.enabled = (bool)json["enabled"];
        inst.validFrom = new System.DateTime(json["validFrom"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        inst.validTill = new System.DateTime(json["validTill"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        return inst;
      }

      public bool enabled = false;
      public System.DateTime validFrom = new System.DateTime(0);
      public System.DateTime validTill = new System.DateTime(0);
    }

    public class PeriodicTimeCondition : ICloneable {
      public object Clone() {
        PeriodicTimeCondition copy = new PeriodicTimeCondition();
        copy.enabled = this.enabled;
        copy.daysOfWeek = this.daysOfWeek;
        copy.fromHourOfDay = this.fromHourOfDay;
        copy.tillHourOfDay = this.tillHourOfDay;
        copy.fromMinuteOfHour = this.fromMinuteOfHour;
        copy.tillMinuteOfHour = this.tillMinuteOfHour;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["enabled"] = this.enabled;
        json["daysOfWeek"] = new JsonArray(this.daysOfWeek.Select(
          _value => (JsonValue)(_value)));
        json["fromHourOfDay"] = this.fromHourOfDay;
        json["tillHourOfDay"] = this.tillHourOfDay;
        json["fromMinuteOfHour"] = this.fromMinuteOfHour;
        json["tillMinuteOfHour"] = this.tillMinuteOfHour;
        return json;
      }

      public static PeriodicTimeCondition Decode(LightJson.JsonObject json, Agent agent) {
        PeriodicTimeCondition inst = new PeriodicTimeCondition();
        inst.enabled = (bool)json["enabled"];
        inst.daysOfWeek = new System.Collections.Generic.List<int>(json["daysOfWeek"].AsJsonArray.Select(
          _value => (int)_value));
        inst.fromHourOfDay = (int)json["fromHourOfDay"];
        inst.tillHourOfDay = (int)json["tillHourOfDay"];
        inst.fromMinuteOfHour = (int)json["fromMinuteOfHour"];
        inst.tillMinuteOfHour = (int)json["tillMinuteOfHour"];
        return inst;
      }

      public bool enabled = false;
      public System.Collections.Generic.IEnumerable<int> daysOfWeek = new System.Collections.Generic.List<int>();
      public int fromHourOfDay = 0;
      public int tillHourOfDay = 0;
      public int fromMinuteOfHour = 0;
      public int tillMinuteOfHour = 0;
    }

    public class CardReaderInfo : ICloneable {
      public object Clone() {
        CardReaderInfo copy = new CardReaderInfo();
        copy.linkId = this.linkId;
        copy.position = this.position;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["linkId"] = this.linkId;
        json["position"] = this.position;
        return json;
      }

      public static CardReaderInfo Decode(LightJson.JsonObject json, Agent agent) {
        CardReaderInfo inst = new CardReaderInfo();
        inst.linkId = (int)json["linkId"];
        inst.position = (string)json["position"];
        return inst;
      }

      public int linkId = 0;
      public string position = "";
    }

    public class KeypadInfo : ICloneable {
      public object Clone() {
        KeypadInfo copy = new KeypadInfo();
        copy.linkId = this.linkId;
        copy.position = this.position;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["linkId"] = this.linkId;
        json["position"] = this.position;
        return json;
      }

      public static KeypadInfo Decode(LightJson.JsonObject json, Agent agent) {
        KeypadInfo inst = new KeypadInfo();
        inst.linkId = (int)json["linkId"];
        inst.position = (string)json["position"];
        return inst;
      }

      public int linkId = 0;
      public string position = "";
    }

    public class CardCondition : ICloneable {
      public object Clone() {
        CardCondition copy = new CardCondition();
        copy.enabled = this.enabled;
        copy.cardUid = this.cardUid;
        copy.cardReader = this.cardReader;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["enabled"] = this.enabled;
        json["cardUid"] = this.cardUid;
        json["cardReader"] = this.cardReader.Encode();
        return json;
      }

      public static CardCondition Decode(LightJson.JsonObject json, Agent agent) {
        CardCondition inst = new CardCondition();
        inst.enabled = (bool)json["enabled"];
        inst.cardUid = (string)json["cardUid"];
        inst.cardReader = Com.Raritan.Idl.smartlock.DoorAccessControl.CardReaderInfo.Decode(json["cardReader"], agent);
        return inst;
      }

      public bool enabled = false;
      public string cardUid = "";
      public Com.Raritan.Idl.smartlock.DoorAccessControl.CardReaderInfo cardReader = new Com.Raritan.Idl.smartlock.DoorAccessControl.CardReaderInfo();
    }

    public class KeypadCondition : ICloneable {
      public object Clone() {
        KeypadCondition copy = new KeypadCondition();
        copy.enabled = this.enabled;
        copy.pin = this.pin;
        copy.keypad = this.keypad;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["enabled"] = this.enabled;
        json["pin"] = this.pin;
        json["keypad"] = this.keypad.Encode();
        return json;
      }

      public static KeypadCondition Decode(LightJson.JsonObject json, Agent agent) {
        KeypadCondition inst = new KeypadCondition();
        inst.enabled = (bool)json["enabled"];
        inst.pin = (string)json["pin"];
        inst.keypad = Com.Raritan.Idl.smartlock.DoorAccessControl.KeypadInfo.Decode(json["keypad"], agent);
        return inst;
      }

      public bool enabled = false;
      public string pin = "";
      public Com.Raritan.Idl.smartlock.DoorAccessControl.KeypadInfo keypad = new Com.Raritan.Idl.smartlock.DoorAccessControl.KeypadInfo();
    }

    public class DoorAccessRule : ICloneable {
      public object Clone() {
        DoorAccessRule copy = new DoorAccessRule();
        copy.name = this.name;
        copy.doorHandleLocks = this.doorHandleLocks;
        copy.cardCondition1 = this.cardCondition1;
        copy.cardCondition2 = this.cardCondition2;
        copy.keypadCondition1 = this.keypadCondition1;
        copy.keypadCondition2 = this.keypadCondition2;
        copy.conditionsTimeout = this.conditionsTimeout;
        copy.absoluteTime = this.absoluteTime;
        copy.periodicTime = this.periodicTime;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["name"] = this.name;
        json["doorHandleLocks"] = new JsonArray(this.doorHandleLocks.Select(
          _value => (JsonValue)(_value != null ? _value.Encode() : JsonValue.Null)));
        json["cardCondition1"] = this.cardCondition1.Encode();
        json["cardCondition2"] = this.cardCondition2.Encode();
        json["keypadCondition1"] = this.keypadCondition1.Encode();
        json["keypadCondition2"] = this.keypadCondition2.Encode();
        json["conditionsTimeout"] = this.conditionsTimeout;
        json["absoluteTime"] = this.absoluteTime.Encode();
        json["periodicTime"] = this.periodicTime.Encode();
        return json;
      }

      public static DoorAccessRule Decode(LightJson.JsonObject json, Agent agent) {
        DoorAccessRule inst = new DoorAccessRule();
        inst.name = (string)json["name"];
        inst.doorHandleLocks = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.DeviceSlot_3_0_0>(json["doorHandleLocks"].AsJsonArray.Select(
          _value => Com.Raritan.Idl.peripheral.DeviceSlot_3_0_0.StaticCast(ObjectProxy.Decode(_value, agent))));
        inst.cardCondition1 = Com.Raritan.Idl.smartlock.DoorAccessControl.CardCondition.Decode(json["cardCondition1"], agent);
        inst.cardCondition2 = Com.Raritan.Idl.smartlock.DoorAccessControl.CardCondition.Decode(json["cardCondition2"], agent);
        inst.keypadCondition1 = Com.Raritan.Idl.smartlock.DoorAccessControl.KeypadCondition.Decode(json["keypadCondition1"], agent);
        inst.keypadCondition2 = Com.Raritan.Idl.smartlock.DoorAccessControl.KeypadCondition.Decode(json["keypadCondition2"], agent);
        inst.conditionsTimeout = (int)json["conditionsTimeout"];
        inst.absoluteTime = Com.Raritan.Idl.smartlock.DoorAccessControl.AbsoluteTimeCondition.Decode(json["absoluteTime"], agent);
        inst.periodicTime = Com.Raritan.Idl.smartlock.DoorAccessControl.PeriodicTimeCondition.Decode(json["periodicTime"], agent);
        return inst;
      }

      public string name = "";
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.DeviceSlot_3_0_0> doorHandleLocks = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.DeviceSlot_3_0_0>();
      public Com.Raritan.Idl.smartlock.DoorAccessControl.CardCondition cardCondition1 = new Com.Raritan.Idl.smartlock.DoorAccessControl.CardCondition();
      public Com.Raritan.Idl.smartlock.DoorAccessControl.CardCondition cardCondition2 = new Com.Raritan.Idl.smartlock.DoorAccessControl.CardCondition();
      public Com.Raritan.Idl.smartlock.DoorAccessControl.KeypadCondition keypadCondition1 = new Com.Raritan.Idl.smartlock.DoorAccessControl.KeypadCondition();
      public Com.Raritan.Idl.smartlock.DoorAccessControl.KeypadCondition keypadCondition2 = new Com.Raritan.Idl.smartlock.DoorAccessControl.KeypadCondition();
      public int conditionsTimeout = 0;
      public Com.Raritan.Idl.smartlock.DoorAccessControl.AbsoluteTimeCondition absoluteTime = new Com.Raritan.Idl.smartlock.DoorAccessControl.AbsoluteTimeCondition();
      public Com.Raritan.Idl.smartlock.DoorAccessControl.PeriodicTimeCondition periodicTime = new Com.Raritan.Idl.smartlock.DoorAccessControl.PeriodicTimeCondition();
    }

    public enum DoorAccessDenialReason {
      DENIED_NO_MATCHING_RULE,
      DENIED_ABSOLUTE_TIME_CONDITION,
      DENIED_PERIODIC_TIME_CONDITION,
      DENIED_CONDITIONS_TIMEOUT,
    }

    public class DoorAccessGrantedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("smartlock.DoorAccessControl.DoorAccessGrantedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public int ruleId = 0;
      public Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule rule = new Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule();
    }

    public class DoorAccessDeniedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("smartlock.DoorAccessControl.DoorAccessDeniedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessDenialReason reason = Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessDenialReason.DENIED_NO_MATCHING_RULE;
      public int ruleId = 0;
      public string ruleName = "";
    }

    public class DoorAccessRuleAddedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("smartlock.DoorAccessControl.DoorAccessRuleAddedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public int ruleId = 0;
      public Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule rule = new Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule();
    }

    public class DoorAccessRuleChangedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("smartlock.DoorAccessControl.DoorAccessRuleChangedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public int ruleId = 0;
      public Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule oldRule = new Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule();
      public Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule newRule = new Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule();
    }

    public class DoorAccessRuleDeletedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("smartlock.DoorAccessControl.DoorAccessRuleDeletedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public int ruleId = 0;
      public Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule rule = new Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule();
    }

    public class GetDoorAccessRulesResult {
      public System.Collections.Generic.IDictionary<int, Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule> _ret_;
    }

    public GetDoorAccessRulesResult getDoorAccessRules() {
      JsonObject _parameters = null;
      var _result = RpcCall("getDoorAccessRules", _parameters);
      var _ret = new GetDoorAccessRulesResult();
      _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
        _value => new System.Collections.Generic.KeyValuePair<int, Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule>(_value["key"], Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule.Decode(_value["value"], agent))));
      return _ret;
    }

    public AsyncRequest getDoorAccessRules(AsyncRpcResponse<GetDoorAccessRulesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getDoorAccessRules(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getDoorAccessRules(AsyncRpcResponse<GetDoorAccessRulesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getDoorAccessRules", _parameters,
        _result => {
          try {
            var _ret = new GetDoorAccessRulesResult();
            _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
              _value => new System.Collections.Generic.KeyValuePair<int, Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule>(_value["key"], Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule.Decode(_value["value"], agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetAllDoorAccessRulesResult {
      public int _ret_;
      public System.Collections.Generic.IEnumerable<int> invalidRuleIds;
    }

    public SetAllDoorAccessRulesResult setAllDoorAccessRules(System.Collections.Generic.IDictionary<int, Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule> rules) {
      var _parameters = new LightJson.JsonObject();
      _parameters["rules"] = new JsonArray(rules.Select(_entry => (JsonValue) new JsonObject(new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, LightJson.JsonValue>> {
        new System.Collections.Generic.KeyValuePair<string, JsonValue>("key", _entry.Key),
        new System.Collections.Generic.KeyValuePair<string, JsonValue>("value", _entry.Value.Encode())
      })));

      var _result = RpcCall("setAllDoorAccessRules", _parameters);
      var _ret = new SetAllDoorAccessRulesResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.invalidRuleIds = new System.Collections.Generic.List<int>(_result["invalidRuleIds"].AsJsonArray.Select(
        _value => (int)_value));
      return _ret;
    }

    public AsyncRequest setAllDoorAccessRules(System.Collections.Generic.IDictionary<int, Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule> rules, AsyncRpcResponse<SetAllDoorAccessRulesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setAllDoorAccessRules(rules, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setAllDoorAccessRules(System.Collections.Generic.IDictionary<int, Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule> rules, AsyncRpcResponse<SetAllDoorAccessRulesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["rules"] = new JsonArray(rules.Select(_entry => (JsonValue) new JsonObject(new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, LightJson.JsonValue>> {
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("key", _entry.Key),
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("value", _entry.Value.Encode())
        })));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setAllDoorAccessRules", _parameters,
        _result => {
          try {
            var _ret = new SetAllDoorAccessRulesResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.invalidRuleIds = new System.Collections.Generic.List<int>(_result["invalidRuleIds"].AsJsonArray.Select(
              _value => (int)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class AddDoorAccessRuleResult {
      public int _ret_;
      public int ruleId;
    }

    public AddDoorAccessRuleResult addDoorAccessRule(Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule rule) {
      var _parameters = new LightJson.JsonObject();
      _parameters["rule"] = rule.Encode();

      var _result = RpcCall("addDoorAccessRule", _parameters);
      var _ret = new AddDoorAccessRuleResult();
      _ret._ret_ = (int)_result["_ret_"];
      _ret.ruleId = (int)_result["ruleId"];
      return _ret;
    }

    public AsyncRequest addDoorAccessRule(Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule rule, AsyncRpcResponse<AddDoorAccessRuleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return addDoorAccessRule(rule, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest addDoorAccessRule(Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule rule, AsyncRpcResponse<AddDoorAccessRuleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["rule"] = rule.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("addDoorAccessRule", _parameters,
        _result => {
          try {
            var _ret = new AddDoorAccessRuleResult();
            _ret._ret_ = (int)_result["_ret_"];
            _ret.ruleId = (int)_result["ruleId"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ModifyDoorAccessRuleResult {
      public int _ret_;
    }

    public ModifyDoorAccessRuleResult modifyDoorAccessRule(int id, Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule modifiedRule) {
      var _parameters = new LightJson.JsonObject();
      _parameters["id"] = id;
      _parameters["modifiedRule"] = modifiedRule.Encode();

      var _result = RpcCall("modifyDoorAccessRule", _parameters);
      var _ret = new ModifyDoorAccessRuleResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest modifyDoorAccessRule(int id, Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule modifiedRule, AsyncRpcResponse<ModifyDoorAccessRuleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return modifyDoorAccessRule(id, modifiedRule, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest modifyDoorAccessRule(int id, Com.Raritan.Idl.smartlock.DoorAccessControl.DoorAccessRule modifiedRule, AsyncRpcResponse<ModifyDoorAccessRuleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["id"] = id;
        _parameters["modifiedRule"] = modifiedRule.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("modifyDoorAccessRule", _parameters,
        _result => {
          try {
            var _ret = new ModifyDoorAccessRuleResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class DeleteDoorAccessRuleResult {
      public int _ret_;
    }

    public DeleteDoorAccessRuleResult deleteDoorAccessRule(int id) {
      var _parameters = new LightJson.JsonObject();
      _parameters["id"] = id;

      var _result = RpcCall("deleteDoorAccessRule", _parameters);
      var _ret = new DeleteDoorAccessRuleResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest deleteDoorAccessRule(int id, AsyncRpcResponse<DeleteDoorAccessRuleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return deleteDoorAccessRule(id, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest deleteDoorAccessRule(int id, AsyncRpcResponse<DeleteDoorAccessRuleResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["id"] = id;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("deleteDoorAccessRule", _parameters,
        _result => {
          try {
            var _ret = new DeleteDoorAccessRuleResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
