// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2026 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Webcam.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.webcam {

  public class ImageMetaData : ICloneable {
    public object Clone() {
      ImageMetaData copy = new ImageMetaData();
      copy.format = this.format;
      copy.timestamp = this.timestamp;
      copy.location = this.location;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["format"] = this.format.Encode();
      json["timestamp"] = this.timestamp;
      json["location"] = this.location.Encode();
      return json;
    }

    public static ImageMetaData Decode(LightJson.JsonObject json, Agent agent) {
      ImageMetaData inst = new ImageMetaData();
      inst.format = Com.Raritan.Idl.webcam.Format_2_0_0.Decode(json["format"], agent);
      inst.timestamp = (long)json["timestamp"];
      inst.location = Com.Raritan.Idl.webcam.Location.Decode(json["location"], agent);
      return inst;
    }

    public Com.Raritan.Idl.webcam.Format_2_0_0 format = new Com.Raritan.Idl.webcam.Format_2_0_0();
    public long timestamp = 0;
    public Com.Raritan.Idl.webcam.Location location = new Com.Raritan.Idl.webcam.Location();
  }
}
