# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from ServerSSLCert.idl.

use strict;

package Raritan::RPC::cert::ServerSSLCert_4_0_0;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "cert.ServerSSLCert:4.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::cert::ServerSSLCert_4_0_0::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant SUCCESS => 0;

use constant ERR_BUSY => 1;

use constant ERR_CSR_OR_CERT_PENDING => 101;

use constant ERR_KEY_MISSING => 200;

use constant ERR_CERT_MISSING => 201;

use constant ERR_CERT_FORMAT_INVALID => 202;

use constant ERR_CERT_KEY_MISMATCH => 203;

use constant ERR_KEY_FORMAT_INVALID => 204;

use constant ERR_GEN_KEY_LEN_INVALID => 100;

use constant ERR_GEN_CSR_OR_CERT_PENDING => 101;

use constant ERR_GEN_KEY_GEN_FAILED => 102;

use constant ERR_GEN_KEY_TYPE_INVALID => 103;

use constant ERR_GEN_ELLIPTIC_CURVE_INVALID => 104;

use constant ERR_GEN_VALIDITY_OUT_OF_RANGE => 105;

use constant ERR_INSTALL_KEY_MISSING => 200;

use constant ERR_INSTALL_CERT_MISSING => 201;

use constant ERR_INSTALL_CERT_FORMAT_INVALID => 202;

use constant ERR_INSTALL_CERT_KEY_MISMATCH => 203;

use constant ERR_INSTALL_KEY_FORMAT_INVALID => 204;

use Raritan::RPC::cert::ServerSSLCert_4_0_0::KeyInfo;

sub getSupportedKeyInfos($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSupportedKeyInfos', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::cert::ServerSSLCert_4_0_0::KeyInfo::decode($agent, $rsp->{'_ret_'}->[$i0]);
    }
    return $_ret_;
}

use Raritan::RPC::cert::ServerSSLCert_4_0_0::ReqInfo;

sub generateUnsignedKeyPair($$$) {
    my ($self, $reqInfo, $challenge) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'reqInfo'} = Raritan::RPC::cert::ServerSSLCert_4_0_0::ReqInfo::encode($reqInfo);
    $args->{'challenge'} = "$challenge";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'generateUnsignedKeyPair', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::cert::ServerSSLCert_4_0_0::ReqInfo;

sub generateSelfSignedKeyPair($$$) {
    my ($self, $reqInfo, $days) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'reqInfo'} = Raritan::RPC::cert::ServerSSLCert_4_0_0::ReqInfo::encode($reqInfo);
    $args->{'days'} = 1 * $days;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'generateSelfSignedKeyPair', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub deletePending($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'deletePending', $args);
}

use Raritan::RPC::cert::ServerSSLCert_4_0_0::Info;

sub getInfo($$) {
    my ($self, $info) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getInfo', $args);
    $$info = Raritan::RPC::cert::ServerSSLCert_4_0_0::Info::decode($agent, $rsp->{'info'});
}

sub getActiveCertChainPEM($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getActiveCertChainPEM', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub getActiveKeyPEM($$) {
    my ($self, $keyPassword) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'keyPassword'} = "$keyPassword";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getActiveKeyPEM', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub getPendingRequestPEM($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getPendingRequestPEM', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub getPendingCertChainPEM($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getPendingCertChainPEM', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub getPendingKeyPEM($$) {
    my ($self, $keyPassword) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'keyPassword'} = "$keyPassword";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getPendingKeyPEM', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub setPendingCertChainPEM($$) {
    my ($self, $certChain) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'certChain'} = "$certChain";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setPendingCertChainPEM', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub setPendingKeyAndCertChainPEM($$$$) {
    my ($self, $key, $certChain, $keyPassword) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'key'} = "$key";
    $args->{'certChain'} = "$certChain";
    $args->{'keyPassword'} = "$keyPassword";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setPendingKeyAndCertChainPEM', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub installPendingKeyPair($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'installPendingKeyPair', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('cert.ServerSSLCert', 4, 0, 0, 'Raritan::RPC::cert::ServerSSLCert_4_0_0');
1;
