# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from DateTime.idl.

use strict;

package Raritan::RPC::datetime::DateTime_3_0_1;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "datetime.DateTime:3.0.1";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::datetime::DateTime_3_0_1::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use Raritan::RPC::datetime::DateTime_3_0_1::ZoneInfo;

sub getZoneInfos($$$) {
    my ($self, $zoneInfos, $useOlson) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'useOlson'} = ($useOlson) ? JSON::true : JSON::false;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getZoneInfos', $args);
    $$zoneInfos = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'zoneInfos'}}; $i0++) {
        $$zoneInfos->[$i0] = Raritan::RPC::datetime::DateTime_3_0_1::ZoneInfo::decode($agent, $rsp->{'zoneInfos'}->[$i0]);
    }
}

sub checkNtpServer($$) {
    my ($self, $ntpServer) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'ntpServer'} = "$ntpServer";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'checkNtpServer', $args);
    my $_ret_;
    $_ret_ = ($rsp->{'_ret_'}) ? 1 : 0;
    return $_ret_;
}

sub getActiveNtpServers($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getActiveNtpServers', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = $rsp->{'_ret_'}->[$i0];
    }
    return $_ret_;
}

use Raritan::RPC::datetime::DateTime_3_0_1::Cfg;

sub getCfg($$) {
    my ($self, $cfg) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getCfg', $args);
    $$cfg = Raritan::RPC::datetime::DateTime_3_0_1::Cfg::decode($agent, $rsp->{'cfg'});
}

use Raritan::RPC::datetime::DateTime_3_0_1::Cfg;

sub setCfg($$) {
    my ($self, $cfg) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'cfg'} = Raritan::RPC::datetime::DateTime_3_0_1::Cfg::encode($cfg);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setCfg', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::datetime::DateTime_3_0_1::ZoneInfo;

sub getTime($$$$$$) {
    my ($self, $useOlson, $zone, $dstEnabled, $utcOffset, $currentTime) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'useOlson'} = ($useOlson) ? JSON::true : JSON::false;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getTime', $args);
    $$zone = Raritan::RPC::datetime::DateTime_3_0_1::ZoneInfo::decode($agent, $rsp->{'zone'});
    $$dstEnabled = ($rsp->{'dstEnabled'}) ? 1 : 0;
    $$utcOffset = $rsp->{'utcOffset'};
    $$currentTime = $rsp->{'currentTime'};
}

Raritan::RPC::Registry::registerProxyClass('datetime.DateTime', 3, 0, 1, 'Raritan::RPC::datetime::DateTime_3_0_1');
1;
