# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from Firmware.idl.

use strict;

package Raritan::RPC::firmware::Firmware;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "firmware.Firmware:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::firmware::Firmware::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

sub reboot($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'reboot', $args);
}

sub factoryReset($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'factoryReset', $args);
}

sub getVersion($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getVersion', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::firmware::UpdateHistoryEntry;

sub getUpdateHistory($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getUpdateHistory', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::firmware::UpdateHistoryEntry::decode($agent, $rsp->{'_ret_'}->[$i0]);
    }
    return $_ret_;
}

sub updateAvailable($$$$$) {
    my ($self, $failedCheck, $lastChecked, $version, $url) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'updateAvailable', $args);
    $$failedCheck = ($rsp->{'failedCheck'}) ? 1 : 0;
    $$lastChecked = $rsp->{'lastChecked'};
    $$version = $rsp->{'version'};
    $$url = $rsp->{'url'};
    my $_ret_;
    $_ret_ = ($rsp->{'_ret_'}) ? 1 : 0;
    return $_ret_;
}

sub enableOnlineCheck($$) {
    my ($self, $enable) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'enable'} = ($enable) ? JSON::true : JSON::false;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'enableOnlineCheck', $args);
}

sub onlineCheckEnabled($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'onlineCheckEnabled', $args);
    my $_ret_;
    $_ret_ = ($rsp->{'_ret_'}) ? 1 : 0;
    return $_ret_;
}

sub performOnlineCheck($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'performOnlineCheck', $args);
}

sub downloadImage($$) {
    my ($self, $url) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'url'} = "$url";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'downloadImage', $args);
    my $_ret_;
    $_ret_ = ($rsp->{'_ret_'}) ? 1 : 0;
    return $_ret_;
}

sub cancelDownload($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'cancelDownload', $args);
}

use Raritan::RPC::firmware::ImageStatus;

sub getImageStatus($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getImageStatus', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::firmware::ImageStatus::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

sub discardImage($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'discardImage', $args);
}

use Raritan::RPC::firmware::ImageInfo;

sub getImageInfo($$) {
    my ($self, $info) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getImageInfo', $args);
    $$info = Raritan::RPC::firmware::ImageInfo::decode($agent, $rsp->{'info'});
    my $_ret_;
    $_ret_ = ($rsp->{'_ret_'}) ? 1 : 0;
    return $_ret_;
}


sub startUpdate($$) {
    my ($self, $flags) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'flags'} = [];
    for (my $i0 = 0; $i0 <= $#{$flags}; $i0++) {
        $args->{'flags'}->[$i0] = 1 * $flags->[$i0];
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'startUpdate', $args);
}

Raritan::RPC::Registry::registerProxyClass('firmware.Firmware', 1, 0, 0, 'Raritan::RPC::firmware::Firmware');
1;
