# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from Diagnostics.idl.

use strict;

package Raritan::RPC::net::Diagnostics_1_0_1;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "net.Diagnostics:1.0.1";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::net::Diagnostics_1_0_1::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant NO_ERROR => 0;

use constant ERR_INVALID_PARAM => 1;

use constant ERR_EXEC_FAIL => 2;

use constant ERR_TIMEOUT => 3;

use constant ERR_RESOLVE_FAIL => 4;

sub ping($$$$) {
    my ($self, $hostName, $count, $results) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'hostName'} = "$hostName";
    $args->{'count'} = 1 * $count;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'ping', $args);
    $$results = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'results'}}; $i0++) {
        $$results->[$i0] = $rsp->{'results'}->[$i0];
    }
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub traceRoute($$$$$) {
    my ($self, $hostName, $timeout, $useIcmp, $results) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'hostName'} = "$hostName";
    $args->{'timeout'} = 1 * $timeout;
    $args->{'useIcmp'} = ($useIcmp) ? JSON::true : JSON::false;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'traceRoute', $args);
    $$results = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'results'}}; $i0++) {
        $$results->[$i0] = $rsp->{'results'}->[$i0];
    }
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub listTcpConnections($$) {
    my ($self, $results) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'listTcpConnections', $args);
    $$results = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'results'}}; $i0++) {
        $$results->[$i0] = $rsp->{'results'}->[$i0];
    }
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub listTcpUdpListenSockets($$) {
    my ($self, $results) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'listTcpUdpListenSockets', $args);
    $$results = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'results'}}; $i0++) {
        $$results->[$i0] = $rsp->{'results'}->[$i0];
    }
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub resolveHostName($$$) {
    my ($self, $hostName, $results) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'hostName'} = "$hostName";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'resolveHostName', $args);
    $$results = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'results'}}; $i0++) {
        $$results->[$i0] = $rsp->{'results'}->[$i0];
    }
}

Raritan::RPC::Registry::registerProxyClass('net.Diagnostics', 1, 0, 1, 'Raritan::RPC::net::Diagnostics_1_0_1');
1;
