# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2026 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from SensorLogger.idl.

use strict;

package Raritan::RPC::sensors::Logger;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "sensors.Logger:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::sensors::Logger::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use Raritan::RPC::sensors::Logger::Settings;

sub getSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSettings', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::sensors::Logger::Settings::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

sub setSettings($$$) {
    my ($self, $isEnabled, $samplesPerRecord) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'isEnabled'} = ($isEnabled) ? JSON::true : JSON::false;
    $args->{'samplesPerRecord'} = 1 * $samplesPerRecord;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub getTimeStamps($$$$) {
    my ($self, $timestamps, $recid, $count) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'recid'} = 1 * $recid;
    $args->{'count'} = 1 * $count;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getTimeStamps', $args);
    $$timestamps = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'timestamps'}}; $i0++) {
        $$timestamps->[$i0] = $rsp->{'timestamps'}->[$i0];
    }
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::sensors::Logger::Record;

sub getSensorRecords($$$$$) {
    my ($self, $recs, $sensor, $recid, $count) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'sensor'} = Raritan::RPC::ObjectCodec::encode($sensor);
    $args->{'recid'} = 1 * $recid;
    $args->{'count'} = 1 * $count;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSensorRecords', $args);
    $$recs = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'recs'}}; $i0++) {
        $$recs->[$i0] = Raritan::RPC::sensors::Logger::Record::decode($agent, $rsp->{'recs'}->[$i0]);
    }
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::sensors::Logger::Record;

sub getPeripheralDeviceRecords($$$$$) {
    my ($self, $recs, $slot, $recid, $count) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'slot'} = Raritan::RPC::ObjectCodec::encode($slot);
    $args->{'recid'} = 1 * $recid;
    $args->{'count'} = 1 * $count;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getPeripheralDeviceRecords', $args);
    $$recs = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'recs'}}; $i0++) {
        $$recs->[$i0] = Raritan::RPC::sensors::Logger::Record::decode($agent, $rsp->{'recs'}->[$i0]);
    }
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::sensors::Logger::TimedRecord;

sub getSensorTimedRecords($$$$$) {
    my ($self, $recs, $sensor, $recid, $count) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'sensor'} = Raritan::RPC::ObjectCodec::encode($sensor);
    $args->{'recid'} = 1 * $recid;
    $args->{'count'} = 1 * $count;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSensorTimedRecords', $args);
    $$recs = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'recs'}}; $i0++) {
        $$recs->[$i0] = Raritan::RPC::sensors::Logger::TimedRecord::decode($agent, $rsp->{'recs'}->[$i0]);
    }
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::sensors::Logger::TimedRecord;

sub getPeripheralDeviceTimedRecords($$$$$) {
    my ($self, $recs, $slot, $recid, $count) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'slot'} = Raritan::RPC::ObjectCodec::encode($slot);
    $args->{'recid'} = 1 * $recid;
    $args->{'count'} = 1 * $count;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getPeripheralDeviceTimedRecords', $args);
    $$recs = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'recs'}}; $i0++) {
        $$recs->[$i0] = Raritan::RPC::sensors::Logger::TimedRecord::decode($agent, $rsp->{'recs'}->[$i0]);
    }
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::sensors::Logger::SensorSet;

sub getLoggedSensors($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getLoggedSensors', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::sensors::Logger::SensorSet::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

use Raritan::RPC::sensors::Logger::SensorSet;

sub setLoggedSensors($$) {
    my ($self, $sensors) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'sensors'} = Raritan::RPC::sensors::Logger::SensorSet::encode($sensors);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setLoggedSensors', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub enableAllSensors($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'enableAllSensors', $args);
}

sub disableAllSensors($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'disableAllSensors', $args);
}

sub getSensorSetTimestamp($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSensorSetTimestamp', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::sensors::Logger::LogRow;

sub getLogRow($$$) {
    my ($self, $row, $recid) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'recid'} = 1 * $recid;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getLogRow', $args);
    $$row = Raritan::RPC::sensors::Logger::LogRow::decode($agent, $rsp->{'row'});
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('sensors.Logger', 1, 0, 0, 'Raritan::RPC::sensors::Logger');
1;
